/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.werner;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.werner.Backbone;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.werner.Loop;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class LoopDetector<INLOC extends IcfgLocation> {
    private final ILogger mLogger;
    private final ManagedScript mScript;
    private final Map<IcfgLocation, Loop> mLoopBodies;
    private final IUltimateServiceProvider mServices;
    private final Set<INLOC> mErrorLocations;
    private final Set<INLOC> mLoopHeads;
    private final Set<IcfgLocation> mIllegalLoopHeads;
    private final Map<IcfgLocation, IcfgLocation> mNesting;
    private final Map<IcfgLocation, IcfgLocation> mNested;
    private final Map<IcfgLocation, IcfgLocation> mLoopExitNodes;
    private final HashMap<IcfgLocation, Deque<Backbone>> mBackbones;
    private final int mBackboneLimit;

    public LoopDetector(ILogger logger, IIcfg<INLOC> originalIcfg, Set<INLOC> loopHeads, ManagedScript script, IUltimateServiceProvider services, int backboneLimit) {
        this.mLogger = Objects.requireNonNull(logger);
        this.mServices = services;
        this.mScript = script;
        this.mErrorLocations = IcfgUtils.getErrorLocations(originalIcfg);
        this.mLoopHeads = loopHeads;
        this.mIllegalLoopHeads = new HashSet<IcfgLocation>();
        this.mNesting = new HashMap<IcfgLocation, IcfgLocation>();
        this.mNested = new HashMap<IcfgLocation, IcfgLocation>();
        this.mLoopBodies = new HashMap<IcfgLocation, Loop>();
        this.mLoopExitNodes = new HashMap<IcfgLocation, IcfgLocation>();
        this.mBackbones = new HashMap();
        this.mBackboneLimit = backboneLimit;
        for (IcfgLocation loopHead : this.mLoopHeads) {
            Loop loop = new Loop(loopHead, this.mScript);
            this.mLoopBodies.put(loopHead, loop);
        }
        this.getLoop();
        this.mLogger.debug((Object)("Found Backbones: " + this.mBackbones));
        if (this.mBackbones.size() > this.mBackboneLimit) {
            this.mLogger.warn((Object)"Found more backbones than the limit allows... This might take a while.");
        }
        this.mLogger.debug((Object)("Loop detector done." + System.lineSeparator()));
    }

    private void getLoop() {
        for (IcfgLocation loopHead : this.mLoopHeads) {
            this.mLogger.debug((Object)("LoopHead: " + loopHead));
            Deque<Backbone> backbones = this.getBackbonePath(this.mLoopBodies.get(loopHead));
            this.mBackbones.put(loopHead, backbones);
        }
        this.checkBackbones();
        for (Loop loop : this.mLoopBodies.values()) {
            IcfgLocation loopHead = loop.getLoophead();
            if (!this.mLoopExitNodes.containsKey(loopHead)) {
                HashSet<IcfgLocation> forbidden = new HashSet<IcfgLocation>();
                forbidden.add(loopHead);
                this.findLoopExits(loopHead, forbidden);
            }
            if (this.mIllegalLoopHeads.contains(loopHead) || this.mBackbones.get(loopHead).isEmpty() || !this.mLoopExitNodes.containsKey(loopHead)) {
                this.mLoopBodies.remove(loopHead);
                continue;
            }
            Deque<Backbone> backbones = this.mBackbones.get(loop.getLoophead());
            loop.setBackbones(backbones);
            Pair<UnmodifiableTransFormula, Set<IcfgEdge>> path = this.mergeBackbones(backbones);
            loop.setFormula((UnmodifiableTransFormula)path.getFirst());
            loop.setPath((Set)path.getSecond());
            loop.setInVars(((UnmodifiableTransFormula)path.getFirst()).getInVars());
            loop.setOutVars(((UnmodifiableTransFormula)path.getFirst()).getOutVars());
            loop.setLoopExit(this.mLoopExitNodes.get(loopHead));
        }
    }

    private void checkBackbones() {
        ArrayDeque<Backbone> backbones = new ArrayDeque<Backbone>();
        for (Deque<Backbone> bone : this.mBackbones.values()) {
            backbones.addAll(bone);
        }
        for (Backbone backbone1 : backbones) {
            IcfgLocation loopHead1 = backbone1.getNodes().getFirst();
            for (Backbone backbone2 : backbones) {
                IcfgLocation loopHead2 = backbone2.getNodes().getFirst();
                if (loopHead1.equals((Object)loopHead2) || !backbone1.getNodes().contains(loopHead2) || !backbone2.getNodes().contains(loopHead1)) continue;
                if (this.mIllegalLoopHeads.contains(loopHead1)) {
                    this.mIllegalLoopHeads.add(loopHead2);
                    continue;
                }
                if (this.mIllegalLoopHeads.contains(loopHead2)) {
                    this.mIllegalLoopHeads.add(loopHead1);
                    continue;
                }
                this.checkNesting(loopHead1, loopHead2);
                if (this.mNested.containsKey(loopHead2) && this.mNested.get(loopHead2).equals((Object)loopHead1)) {
                    this.mBackbones.get(loopHead2).remove(backbone2);
                    backbone1.addNestedLoop(loopHead2);
                    this.mLoopBodies.get(loopHead1).addNestedLoop(this.mLoopBodies.get(loopHead2));
                    continue;
                }
                if (this.mNested.containsKey(loopHead1) && this.mNested.get(loopHead1).equals((Object)loopHead2)) {
                    this.mBackbones.get(loopHead1).remove(backbone1);
                    backbone1.addNestedLoop(loopHead1);
                    this.mLoopBodies.get(loopHead2).addNestedLoop(this.mLoopBodies.get(loopHead1));
                    continue;
                }
                this.mIllegalLoopHeads.add(backbone1.getNodes().getFirst());
                this.mIllegalLoopHeads.add(backbone2.getNodes().getFirst());
            }
        }
        for (IcfgLocation forbidden : this.mIllegalLoopHeads) {
            this.mBackbones.remove(forbidden);
            this.mLoopBodies.remove(forbidden);
        }
        this.mLogger.debug((Object)"Backbones checked.");
    }

    private boolean findLoopHeader(IcfgEdge transition, IcfgLocation start, IcfgLocation target, Set<IcfgEdge> forbidden, Set<IcfgLocation> forbiddenNode, boolean plain) {
        HashSet<IcfgEdge> forbiddenEdges = new HashSet<IcfgEdge>(forbidden);
        HashSet<IcfgLocation> forbiddenNodes = new HashSet<IcfgLocation>(forbiddenNode);
        HashSet<INLOC> newHeads = new HashSet<INLOC>(this.mLoopHeads);
        ArrayDeque<IcfgEdge> stack = new ArrayDeque<IcfgEdge>();
        ArrayDeque<IcfgLocation> visited = new ArrayDeque<IcfgLocation>();
        stack.push(transition);
        newHeads.remove(target);
        newHeads.removeAll(this.mIllegalLoopHeads);
        visited.addLast(start);
        while (!stack.isEmpty()) {
            IcfgEdge edge = (IcfgEdge)stack.pop();
            IcfgLocation node = (IcfgLocation)edge.getTarget();
            if (node.equals((Object)target)) {
                return true;
            }
            if (visited.contains(node) || forbiddenEdges.contains(edge) || forbiddenNodes.contains(node) || node.equals((Object)start)) continue;
            if (newHeads.contains(node) && !plain) {
                if (this.mLoopExitNodes.containsKey(node)) {
                    stack.addAll(this.mLoopBodies.get(node).getExitTransitions());
                } else {
                    forbiddenNodes.add(start);
                    this.findLoopExits(node, forbiddenNodes);
                }
            }
            visited.addLast(node);
            stack.addAll(node.getOutgoingEdges());
        }
        return false;
    }

    private boolean findLoopHeader(Deque<IcfgEdge> transition, IcfgLocation start, IcfgLocation target, Set<IcfgEdge> forbidden, Set<IcfgLocation> forbiddenNode, boolean plain) {
        HashSet<IcfgEdge> forbiddenEdges = new HashSet<IcfgEdge>(forbidden);
        HashSet<IcfgLocation> forbiddenNodes = new HashSet<IcfgLocation>(forbiddenNode);
        HashSet<INLOC> newHeads = new HashSet<INLOC>(this.mLoopHeads);
        ArrayDeque<IcfgEdge> stack = new ArrayDeque<IcfgEdge>();
        ArrayDeque<IcfgLocation> visited = new ArrayDeque<IcfgLocation>();
        stack.addAll(transition);
        newHeads.remove(target);
        newHeads.removeAll(this.mIllegalLoopHeads);
        visited.addLast(start);
        while (!stack.isEmpty()) {
            IcfgEdge edge = (IcfgEdge)stack.pop();
            IcfgLocation node = (IcfgLocation)edge.getTarget();
            if (node.equals((Object)target)) {
                return true;
            }
            if (visited.contains(node) || forbiddenEdges.contains(edge) || forbiddenNodes.contains(node) || node.equals((Object)start)) continue;
            if (newHeads.contains(node) && !plain) {
                if (this.mLoopExitNodes.containsKey(node)) {
                    stack.addAll(this.mLoopBodies.get(node).getExitTransitions());
                } else {
                    forbiddenNodes.add(start);
                    this.findLoopExits(node, forbiddenNodes);
                }
            }
            visited.addLast(node);
            stack.addAll(node.getOutgoingEdges());
        }
        return false;
    }

    private void checkNesting(IcfgLocation loopHead1, IcfgLocation loopHead2) {
        if (this.mNested.containsKey(loopHead1) && this.mNested.get(loopHead1).equals((Object)loopHead2) || this.mNesting.containsKey(loopHead1) && this.mNesting.get(loopHead1).equals((Object)loopHead2)) {
            return;
        }
        HashSet<IcfgLocation> forbidden = new HashSet<IcfgLocation>();
        forbidden.add(loopHead2);
        forbidden.add(loopHead1);
        ArrayDeque<IcfgEdge> loopHead1Edges = new ArrayDeque<IcfgEdge>(loopHead1.getOutgoingEdges());
        if (this.mNested.containsKey(loopHead1)) {
            forbidden.add(this.mNested.get(loopHead1));
        }
        if (!this.findLoopHeader(loopHead1Edges, loopHead1, loopHead1, Collections.emptySet(), forbidden, false)) {
            this.mNested.put(loopHead2, loopHead1);
        }
        forbidden.clear();
        forbidden.add(loopHead2);
        forbidden.add(loopHead1);
        ArrayDeque<IcfgEdge> loopHead2Edges = new ArrayDeque<IcfgEdge>(loopHead2.getOutgoingEdges());
        if (this.mNested.containsKey(loopHead2)) {
            forbidden.add(this.mNested.get(loopHead2));
        }
        if (!this.findLoopHeader(loopHead2Edges, loopHead2, loopHead2, Collections.emptySet(), forbidden, false)) {
            this.mNested.put(loopHead1, loopHead2);
        }
    }

    private void findLoopExits(IcfgLocation loopHead, Set<IcfgLocation> forbiddenNodes) {
        for (IcfgEdge exit : loopHead.getOutgoingEdges()) {
            if (this.findLoopHeader(exit, loopHead, loopHead, Collections.emptySet(), forbiddenNodes, false)) continue;
            this.mLoopExitNodes.put(loopHead, (IcfgLocation)exit.getTarget());
            this.mLoopBodies.get(loopHead).setLoopExit((IcfgLocation)exit.getTarget());
        }
    }

    private Deque<Backbone> getBackbonePath(Loop loop) {
        ArrayDeque<Backbone> backbones = new ArrayDeque<Backbone>();
        IcfgLocation loopHead = loop.getLoophead();
        ArrayDeque<Backbone> possibleBackbones = new ArrayDeque<Backbone>();
        for (IcfgEdge initialTransition : loopHead.getOutgoingEdges()) {
            Backbone firstPossibleBackbone = new Backbone(initialTransition);
            possibleBackbones.add(firstPossibleBackbone);
        }
        while (!possibleBackbones.isEmpty()) {
            HashSet<IcfgLocation> visited = new HashSet<IcfgLocation>();
            Backbone backbone = (Backbone)possibleBackbones.pop();
            visited.addAll(backbone.getNodes());
            Boolean done = false;
            while (!((IcfgLocation)backbone.getPath().getLast().getTarget()).equals((Object)loopHead)) {
                IcfgEdge edge = backbone.getPath().getLast();
                IcfgLocation target = (IcfgLocation)backbone.getPath().getLast().getTarget();
                if (this.mErrorLocations.contains(target)) {
                    this.mLogger.debug((Object)"FOUND ERROR LOCATIONS");
                    TransFormula errorFormula = this.calculateFormula(backbone.getPath());
                    backbone.setFormula(errorFormula);
                    loop.addErrorPath((IcfgLocation)edge.getTarget(), backbone);
                    this.mLogger.debug((Object)"ERROR PATH DONE");
                    done = true;
                    break;
                }
                if (!this.findLoopHeader(edge, loopHead, loopHead, Collections.emptySet(), visited, false) || visited.contains(target)) {
                    done = true;
                    break;
                }
                visited.add(target);
                if (target.getOutgoingEdges().isEmpty()) continue;
                int i = 1;
                while (i < target.getOutgoingEdges().size()) {
                    Backbone newPossibleBackbone = new Backbone(backbone);
                    newPossibleBackbone.addTransition((IcfgEdge)target.getOutgoingEdges().get(i));
                    possibleBackbones.addLast(newPossibleBackbone);
                    ++i;
                }
                backbone.addTransition((IcfgEdge)target.getOutgoingEdges().get(0));
            }
            if (done.booleanValue()) continue;
            TransFormula tf = this.calculateFormula(backbone.getPath());
            backbone.setFormula(tf);
            backbones.addLast(backbone);
        }
        return backbones;
    }

    private TransFormula calculateFormula(Deque<IcfgEdge> path) {
        ArrayList<UnmodifiableTransFormula> transformulas = new ArrayList<UnmodifiableTransFormula>();
        for (IcfgEdge edge : path) {
            transformulas.add(edge.getTransformula());
        }
        return TransFormulaUtils.sequentialComposition((ILogger)this.mLogger, (IUltimateServiceProvider)this.mServices, (ManagedScript)this.mScript, (boolean)true, (boolean)true, (boolean)false, (SmtUtils.XnfConversionTechnique)SmtUtils.XnfConversionTechnique.BOTTOM_UP_WITH_LOCAL_SIMPLIFICATION, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.NONE, transformulas);
    }

    private Pair<UnmodifiableTransFormula, Set<IcfgEdge>> mergeBackbones(Deque<Backbone> backbones) {
        HashSet<IcfgEdge> path = new HashSet<IcfgEdge>();
        UnmodifiableTransFormula loopFormula = (UnmodifiableTransFormula)backbones.getFirst().getFormula();
        for (Backbone backbone : backbones) {
            path.addAll(backbone.getPath());
            loopFormula = TransFormulaUtils.parallelComposition((ILogger)this.mLogger, (IUltimateServiceProvider)this.mServices, (ManagedScript)this.mScript, null, (boolean)false, (SmtUtils.XnfConversionTechnique)SmtUtils.XnfConversionTechnique.BOTTOM_UP_WITH_LOCAL_SIMPLIFICATION, (boolean)false, (UnmodifiableTransFormula[])new UnmodifiableTransFormula[]{loopFormula, (UnmodifiableTransFormula)backbone.getFormula()});
        }
        return new Pair((Object)loopFormula, path);
    }

    public Map<IcfgLocation, Loop> getLoopBodies() {
        return this.mLoopBodies;
    }
}

