/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.werner;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.HashMap;
import java.util.Map;

public class SymbolicMemory {
    private final IUltimateServiceProvider mServices;
    private final Map<IProgramVar, Term> mMemoryMapping;
    private final ManagedScript mScript;
    private final IIcfgSymbolTable mOldSymbolTable;
    private final Map<IProgramVar, TermVariable> mInVars;
    private final Map<IProgramVar, TermVariable> mOutVars;

    public SymbolicMemory(ManagedScript script, IUltimateServiceProvider services, TransFormula tf, IIcfgSymbolTable oldSymbolTable) {
        this.mScript = script;
        this.mServices = services;
        this.mOldSymbolTable = oldSymbolTable;
        this.mInVars = tf.getInVars();
        this.mOutVars = tf.getOutVars();
        this.mMemoryMapping = new HashMap<IProgramVar, Term>();
        for (Map.Entry<IProgramVar, TermVariable> entry : this.mInVars.entrySet()) {
            this.mMemoryMapping.put(entry.getKey(), (Term)entry.getValue());
        }
        for (Map.Entry<IProgramVar, TermVariable> entry : this.mOutVars.entrySet()) {
            if (this.mMemoryMapping.containsKey(entry.getKey())) continue;
            this.mMemoryMapping.put(entry.getKey(), (Term)entry.getValue());
        }
    }

    public void updateVars(Map<IProgramVar, Term> value) {
        for (Map.Entry<IProgramVar, Term> entry : value.entrySet()) {
            Term t = entry.getValue();
            HashMap<Term, Term> substitution = new HashMap<Term, Term>();
            if (t instanceof TermVariable && this.mMemoryMapping.containsKey(entry.getKey())) {
                substitution.put(t, this.mMemoryMapping.get(entry.getKey()));
            }
            if (t instanceof TermVariable && !this.mMemoryMapping.containsKey(entry.getKey())) {
                this.mMemoryMapping.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (t instanceof ConstantTerm) {
                substitution.put(this.mMemoryMapping.get(entry.getKey()), t);
            } else if (substitution.isEmpty()) {
                ApplicationTerm appTerm = (ApplicationTerm)t;
                substitution.putAll(this.termUnravel((Term)appTerm));
            }
            Term t2 = Substitution.apply((ManagedScript)this.mScript, substitution, (Term)t);
            this.mMemoryMapping.replace(entry.getKey(), t2);
        }
    }

    public UnmodifiableTransFormula updateCondition(UnmodifiableTransFormula tf) {
        Term t = tf.getFormula();
        if (t instanceof QuantifiedFormula) {
            return null;
        }
        ApplicationTerm appTerm = (ApplicationTerm)tf.getFormula();
        HashMap<Term, Term> substitution = new HashMap<Term, Term>();
        substitution.putAll(this.termUnravel((Term)appTerm, tf.getInVars()));
        TransFormulaBuilder tfb = new TransFormulaBuilder(this.mInVars, this.mOutVars, true, null, true, null, true);
        Term term = Substitution.apply((ManagedScript)this.mScript, substitution, (Term)tf.getFormula());
        tfb.setFormula(SmtUtils.simplify((ManagedScript)this.mScript, (Term)term, (IUltimateServiceProvider)this.mServices, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA));
        tfb.setInfeasibility(UnmodifiableTransFormula.Infeasibility.NOT_DETERMINED);
        return tfb.finishConstruction(this.mScript);
    }

    private Map<Term, Term> termUnravel(Term term) {
        HashMap<Term, Term> result = new HashMap<Term, Term>();
        if (term instanceof TermVariable) {
            if (this.mMemoryMapping.containsKey(this.mOldSymbolTable.getProgramVar((TermVariable)term))) {
                result.put(term, this.mMemoryMapping.get(this.mOldSymbolTable.getProgramVar((TermVariable)term)));
            }
            return result;
        }
        if (term instanceof ConstantTerm) {
            return result;
        }
        ApplicationTerm appTerm = (ApplicationTerm)term;
        Term[] termArray = appTerm.getParameters();
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Term subTerm = termArray[n2];
            result.putAll(this.termUnravel(subTerm));
            ++n2;
        }
        return result;
    }

    private Map<Term, Term> termUnravel(Term term, Map<IProgramVar, TermVariable> progVars) {
        HashMap<Term, Term> result = new HashMap<Term, Term>();
        if (term instanceof TermVariable) {
            for (Map.Entry<IProgramVar, TermVariable> entry : progVars.entrySet()) {
                if (!entry.getValue().equals(term) || !this.mMemoryMapping.containsKey(entry.getKey()) || this.mMemoryMapping.get(entry.getKey()) instanceof ConstantTerm) continue;
                result.put(term, this.mMemoryMapping.get(entry.getKey()));
            }
            return result;
        }
        if (term instanceof ConstantTerm) {
            return result;
        }
        ApplicationTerm appTerm = (ApplicationTerm)term;
        Term[] termArray = appTerm.getParameters();
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Term subTerm = termArray[n2];
            result.putAll(this.termUnravel(subTerm, progVars));
            ++n2;
        }
        return result;
    }

    public Map<IProgramVar, TermVariable> getInVars() {
        return this.mInVars;
    }

    public Map<IProgramVar, TermVariable> getOutVars() {
        return this.mOutVars;
    }

    public Term getValue(IProgramVar var) {
        return this.mMemoryMapping.get(var);
    }

    public Map<IProgramVar, Term> getMemory() {
        return this.mMemoryMapping;
    }

    public Map<IProgramVar, TermVariable> getVars() {
        HashMap<IProgramVar, TermVariable> result = new HashMap<IProgramVar, TermVariable>();
        for (Map.Entry<IProgramVar, Term> entry : this.mMemoryMapping.entrySet()) {
            result.put(entry.getKey(), (TermVariable)entry.getValue());
        }
        return result;
    }
}

