/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.werner;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.ILocationFactory;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.IcfgTransformationBacktranslator;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.TransformedIcfgBuilder;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.werner.Backbone;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.werner.IteratedSymbolicMemory;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.werner.Loop;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.werner.LoopAcceleratorLite;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.werner.LoopDetector;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.werner.SymbolicMemory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.BasicIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgReturnTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgInternalTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.SimultaneousUpdate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.TermClassifier;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class WernerLoopAccelerationIcfgTransformer<INLOC extends IcfgLocation, OUTLOC extends IcfgLocation> {
    private final ILogger mLogger;
    private final Map<IcfgLocation, Loop> mLoopBodies;
    private final LoopDetector<INLOC> mLoopDetector;
    private final IIcfg<OUTLOC> mResult;
    private final ManagedScript mScript;
    private final IUltimateServiceProvider mServices;
    private final IIcfgSymbolTable mOldSymbolTable;
    private final List<TermVariable> mPathCounter;
    private final Map<TermVariable, TermVariable> mNewPathCounter;
    private final Map<IcfgLocation, Boolean> mOverApproximation;
    private final DealingWithArraysTypes mDealingWithArrays;
    private Set<INLOC> mLoopHeads;
    private final Set<Loop> mAcceleratedLoops;
    private final IcfgTransformationBacktranslator mBackTranslationTracker;

    public WernerLoopAccelerationIcfgTransformer(ILogger logger, IIcfg<INLOC> originalIcfg, ILocationFactory<INLOC, OUTLOC> funLocFac, IcfgTransformationBacktranslator backtranslationTracker, Class<OUTLOC> outLocationClass, String newIcfgIdentifier, IUltimateServiceProvider services, DealingWithArraysTypes options, int backboneLimit) {
        IIcfg<INLOC> origIcfg = Objects.requireNonNull(originalIcfg);
        this.mBackTranslationTracker = backtranslationTracker;
        this.mScript = origIcfg.getCfgSmtToolkit().getManagedScript();
        this.mLogger = Objects.requireNonNull(logger);
        this.mServices = services;
        this.mLoopHeads = new HashSet<INLOC>(originalIcfg.getLoopLocations());
        this.mDealingWithArrays = options;
        this.preprocessIcfg(originalIcfg.getInitialNodes());
        this.mOldSymbolTable = originalIcfg.getCfgSmtToolkit().getSymbolTable();
        this.mPathCounter = new ArrayList<TermVariable>();
        this.mNewPathCounter = new HashMap<TermVariable, TermVariable>();
        this.mOverApproximation = new HashMap<IcfgLocation, Boolean>();
        this.mAcceleratedLoops = new HashSet<Loop>();
        this.mLoopDetector = new LoopDetector<INLOC>(this.mLogger, origIcfg, this.mLoopHeads, this.mScript, this.mServices, backboneLimit);
        this.mLoopBodies = this.mLoopDetector.getLoopBodies();
        this.mResult = this.transform(originalIcfg, funLocFac, backtranslationTracker, outLocationClass, newIcfgIdentifier);
    }

    private IIcfg<OUTLOC> transform(IIcfg<INLOC> originalIcfg, ILocationFactory<INLOC, OUTLOC> funLocFac, IcfgTransformationBacktranslator backtranslationTracker, Class<OUTLOC> outLocationClass, String newIcfgIdentifier) {
        for (Map.Entry<IcfgLocation, Loop> entry : this.mLoopBodies.entrySet()) {
            Loop acceleratedLoop;
            if (entry.getValue().getPath().isEmpty() || (acceleratedLoop = this.summarizeLoop(entry.getValue())) == null) continue;
            this.mAcceleratedLoops.add(acceleratedLoop);
        }
        BasicIcfg resultIcfg = new BasicIcfg(newIcfgIdentifier, originalIcfg.getCfgSmtToolkit(), outLocationClass);
        TransformedIcfgBuilder<INLOC, OUTLOC> lst = new TransformedIcfgBuilder<INLOC, OUTLOC>(this.mLogger, funLocFac, backtranslationTracker, originalIcfg, resultIcfg);
        this.processLocations(originalIcfg.getInitialNodes(), lst);
        lst.finish();
        return resultIcfg;
    }

    private Loop summarizeLoop(Loop loop) {
        this.mPathCounter.clear();
        this.mNewPathCounter.clear();
        if (this.mAcceleratedLoops.contains(loop) || SmtUtils.isTrueLiteral((Term)loop.getFormula().getFormula()) || SmtUtils.isFalseLiteral((Term)loop.getFormula().getFormula())) {
            return null;
        }
        if (!loop.getNestedLoops().isEmpty()) {
            for (Loop nestedLoop : loop.getNestedLoops()) {
                this.mOverApproximation.put(nestedLoop.getLoophead(), true);
                this.summarizeLoop(nestedLoop);
            }
            this.mOverApproximation.put(loop.getLoophead(), true);
        }
        for (Backbone backbone : loop.getBackbones()) {
            this.calculateSymbolicMemory(backbone, loop);
            if (backbone.getCondition() != null) continue;
            return null;
        }
        int i = 0;
        while (i < this.mPathCounter.size()) {
            TermVariable newBackbonePathCounter = this.mScript.constructFreshTermVariable("tau", this.mScript.getScript().sort("Int", new Sort[0]));
            this.mNewPathCounter.put(this.mPathCounter.get(i), newBackbonePathCounter);
            ++i;
        }
        loop.addVar(this.mPathCounter);
        ArrayList<TermVariable> newPathCounterVals = new ArrayList<TermVariable>(this.mNewPathCounter.values());
        loop.addVar(newPathCounterVals);
        ArrayList<TermVariable> pathCounters = new ArrayList<TermVariable>(this.mPathCounter);
        IteratedSymbolicMemory iteratedSymbolicMemory = new IteratedSymbolicMemory(this.mScript, this.mServices, this.mLogger, loop, pathCounters, this.mNewPathCounter);
        iteratedSymbolicMemory.updateMemory();
        iteratedSymbolicMemory.updateCondition();
        Term loopSummary = iteratedSymbolicMemory.getAbstractCondition();
        this.mOverApproximation.putIfAbsent(loop.getLoophead(), iteratedSymbolicMemory.isOverapprox());
        if (!loop.getNestedLoops().isEmpty()) {
            for (Loop nestedLoop : loop.getNestedLoops()) {
                for (UnmodifiableTransFormula exitTerm : nestedLoop.getExitConditions()) {
                    loopSummary = SmtUtils.or((Script)this.mScript.getScript(), Arrays.asList(loopSummary, exitTerm.getFormula()));
                    ArrayList newAuxVars = new ArrayList(exitTerm.getAuxVars());
                    loop.addVar(newAuxVars);
                    loopSummary = loop.updateVars(loopSummary, exitTerm.getInVars(), exitTerm.getOutVars());
                }
                Map<IProgramVar, TermVariable> oldOutVars = loop.getOutVars();
                for (Map.Entry<IProgramVar, TermVariable> outVarNested : nestedLoop.getOutVars().entrySet()) {
                    if (oldOutVars.containsKey(outVarNested.getKey())) continue;
                    oldOutVars.put(outVarNested.getKey(), outVarNested.getValue());
                }
            }
        }
        loop.setCondition(loopSummary);
        loop.setIteratedSymbolicMemory(iteratedSymbolicMemory);
        int i2 = 0;
        while (i2 < loop.getExitTransitions().size()) {
            IcfgEdge exitTransition = loop.getExitTransitions().get(i2);
            HashSet<TermVariable> aux = new HashSet<TermVariable>(loop.getVars());
            UnmodifiableTransFormula exit = LoopAcceleratorLite.buildFormula(this.mScript, loop.updateVars(exitTransition.getTransformula().getFormula(), exitTransition.getTransformula().getInVars(), exitTransition.getTransformula().getOutVars()), loop.getInVars(), loop.getOutVars(), aux);
            Term exitTerm = SmtUtils.and((Script)this.mScript.getScript(), Arrays.asList(loopSummary, exit.getFormula()));
            HashSet<TermVariable> auxVars = new HashSet<TermVariable>(loop.getVars());
            UnmodifiableTransFormula exitFormula = LoopAcceleratorLite.buildFormula(this.mScript, exitTerm, loop.getInVars(), loop.getOutVars(), auxVars);
            loop.addExitCondition(exitFormula);
            ++i2;
        }
        this.dealWithErrorPaths(loop, loopSummary);
        this.mLogger.debug((Object)("LOOP SUMMARY: " + loop.getExitConditions() + System.lineSeparator()));
        return loop;
    }

    private void calculateSymbolicMemory(Backbone backbone, Loop loop) {
        SimultaneousUpdate update;
        try {
            update = SimultaneousUpdate.fromTransFormula((IUltimateServiceProvider)this.mServices, (TransFormula)backbone.getFormula(), (ManagedScript)this.mScript);
        }
        catch (SimultaneousUpdate.SimultaneousUpdateException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        if (!update.getHavocedVars().isEmpty() || !loop.getNestedLoops().isEmpty()) {
            this.mOverApproximation.put(loop.getLoophead(), true);
        }
        HashSet<TermVariable> aux = new HashSet<TermVariable>(loop.getVars());
        UnmodifiableTransFormula tf = LoopAcceleratorLite.buildFormula(this.mScript, loop.updateVars(backbone.getFormula().getFormula(), backbone.getFormula().getInVars(), backbone.getFormula().getOutVars()), loop.getInVars(), loop.getOutVars(), aux);
        backbone.setFormula((TransFormula)tf);
        SymbolicMemory symbolicMemory = new SymbolicMemory(this.mScript, this.mServices, (TransFormula)tf, this.mOldSymbolTable);
        symbolicMemory.updateVars(update.getDeterministicAssignment());
        UnmodifiableTransFormula condition = symbolicMemory.updateCondition(TransFormulaUtils.computeGuard((UnmodifiableTransFormula)tf, (ManagedScript)this.mScript, (IUltimateServiceProvider)this.mServices));
        TermVariable backbonePathCounter = this.mScript.constructFreshTermVariable("kappa", this.mScript.getScript().sort("Int", new Sort[0]));
        this.mPathCounter.add(backbonePathCounter);
        backbone.setPathCounter(backbonePathCounter);
        backbone.setCondition(condition);
        if (backbone.isNested().booleanValue()) {
            for (IcfgLocation nestedLoopHead : backbone.getNestedLoops()) {
                Loop nestedLoop = this.mLoopBodies.get(nestedLoopHead);
                if (nestedLoop.getPath().isEmpty() || nestedLoop.getExitConditions().isEmpty()) continue;
                symbolicMemory.updateVars(nestedLoop.getIteratedMemory().getIteratedMemory());
                loop.addVar(nestedLoop.getVars());
                Map<IProgramVar, TermVariable> oldInvars = loop.getInVars();
                oldInvars.putAll(nestedLoop.getInVars());
                loop.setInVars(oldInvars);
            }
        }
        backbone.setSymbolicMemory(symbolicMemory);
    }

    private void dealWithErrorPaths(Loop loop, Term loopSummary) {
        for (Map.Entry<IcfgLocation, Backbone> errorPath : loop.getErrorPaths().entrySet()) {
            UnmodifiableTransFormula tf;
            Backbone errorPathBack = errorPath.getValue();
            HashSet<TermVariable> aux = new HashSet<TermVariable>(loop.getVars());
            UnmodifiableTransFormula errorFormula = tf = LoopAcceleratorLite.buildFormula(this.mScript, loop.updateVars(errorPathBack.getFormula().getFormula(), errorPathBack.getFormula().getInVars(), errorPathBack.getFormula().getOutVars()), loop.getInVars(), loop.getOutVars(), aux);
            Term errorTerm = SmtUtils.or((Script)this.mScript.getScript(), Arrays.asList(loopSummary, errorFormula.getFormula()));
            HashSet<TermVariable> errorVars = new HashSet<TermVariable>(loop.getVars());
            UnmodifiableTransFormula errorFormulaDone = LoopAcceleratorLite.buildFormula(this.mScript, errorTerm, loop.getInVars(), loop.getOutVars(), errorVars);
            errorPath.getValue().setFormula((TransFormula)errorFormulaDone);
        }
    }

    private void preprocessIcfg(Set<INLOC> init) {
        ArrayDeque<INLOC> open = new ArrayDeque<INLOC>(init);
        HashSet<IcfgLocation> closed = new HashSet<IcfgLocation>();
        while (!open.isEmpty()) {
            IcfgLocation node = (IcfgLocation)open.removeFirst();
            TermClassifier classifier = new TermClassifier();
            if (!closed.add(node)) continue;
            for (IcfgEdge edge : node.getOutgoingEdges()) {
                classifier.checkTerm(edge.getTransformula().getClosedFormula());
                if (classifier.hasArrays() && this.mDealingWithArrays.equals((Object)DealingWithArraysTypes.EXCEPTION)) {
                    throw new IllegalArgumentException("Cannot deal with Arrays");
                }
                if (!classifier.hasArrays() || !this.mDealingWithArrays.equals((Object)DealingWithArraysTypes.SKIP_LOOP)) continue;
                this.mLoopHeads = Collections.emptySet();
            }
            for (IcfgLocation location : node.getOutgoingNodes()) {
                open.addLast(location);
            }
        }
    }

    private void processLocations(Set<INLOC> init, TransformedIcfgBuilder<INLOC, OUTLOC> lst) {
        ArrayDeque<INLOC> open = new ArrayDeque<INLOC>(init);
        HashSet<IcfgLocation> closed = new HashSet<IcfgLocation>();
        HashSet<Triple> otherPossibleReturns = new HashSet<Triple>();
        while (!open.isEmpty()) {
            IcfgLocation newTarget;
            IcfgLocation oldSource = (IcfgLocation)open.removeFirst();
            if (!closed.add(oldSource)) continue;
            IcfgLocation newSource = lst.createNewLocation(oldSource);
            HashSet<Triple> returnTransitions = new HashSet<Triple>();
            if (this.mLoopBodies.containsKey(oldSource) && this.mLoopBodies.get(oldSource).getIteratedMemory() != null) {
                Loop loop = this.mLoopBodies.get(oldSource);
                if (!loop.getErrorPaths().isEmpty()) {
                    this.mLogger.debug((Object)"LOOP WITH ERRORPATH");
                    for (Map.Entry entry : loop.getErrorPaths().entrySet()) {
                        newTarget = lst.createNewLocation((IcfgLocation)entry.getKey());
                        lst.createNewInternalTransition(newSource, newTarget, (UnmodifiableTransFormula)((Backbone)entry.getValue()).getFormula(), true);
                    }
                }
                for (IcfgEdge icfgEdge : oldSource.getOutgoingEdges()) {
                    IcfgLocation oldTarget;
                    if (loop.getLoopExit().equals((Object)icfgEdge.getTarget())) {
                        oldTarget = (IcfgLocation)icfgEdge.getTarget();
                        open.add(oldTarget);
                        continue;
                    }
                    if (loop.getPath().contains(icfgEdge)) {
                        IcfgLocation loopExit = lst.createNewLocation(loop.getLoopExit());
                        for (UnmodifiableTransFormula exitTransition : loop.getExitConditions()) {
                            IcfgInternalTransition newTransition = lst.createNewInternalTransition(newSource, loopExit, exitTransition, this.mOverApproximation.get(newSource));
                            this.mBackTranslationTracker.mapEdges((IIcfgTransition<IcfgLocation>)newTransition, (IIcfgTransition<IcfgLocation>)icfgEdge);
                        }
                        continue;
                    }
                    oldTarget = (IcfgLocation)icfgEdge.getTarget();
                    open.add(oldTarget);
                    IcfgLocation newTarget2 = lst.createNewLocation(oldTarget);
                    lst.createNewTransition(newSource, newTarget2, icfgEdge);
                }
            } else {
                for (IcfgEdge oldTransition : oldSource.getOutgoingEdges()) {
                    IcfgLocation oldTarget = (IcfgLocation)oldTransition.getTarget();
                    open.add(oldTarget);
                    newTarget = lst.createNewLocation(oldTarget);
                    if (oldTransition instanceof IIcfgReturnTransition) {
                        returnTransitions.add(new Triple((Object)newSource, (Object)newTarget, (Object)((IIcfgReturnTransition)oldTransition)));
                        continue;
                    }
                    lst.createNewTransition(newSource, newTarget, oldTransition);
                }
            }
            for (Triple t : returnTransitions) {
                if (!lst.isCorrespondingCallContained((IIcfgReturnTransition)t.getThird())) {
                    otherPossibleReturns.add(t);
                    continue;
                }
                lst.createNewTransition((IcfgLocation)t.getFirst(), (IcfgLocation)t.getSecond(), (IcfgEdge)t.getThird());
            }
        }
        otherPossibleReturns.stream().filter(a -> lst.isCorrespondingCallContained((IIcfgReturnTransition)a.getThird())).forEach(a -> {
            IcfgEdge icfgEdge = lst.createNewTransition((IcfgLocation)a.getFirst(), (IcfgLocation)a.getSecond(), (IcfgEdge)a.getThird());
        });
    }

    public IIcfg<OUTLOC> getResult() {
        return this.mResult;
    }

    public static enum DealingWithArraysTypes {
        EXCEPTION,
        SKIP_LOOP;

    }
}

