/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.woelfing;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import java.util.ArrayList;
import java.util.List;

public class Backbone {
    private final List<IcfgEdge> mTransitions;

    public Backbone(IcfgEdge transition) {
        this.mTransitions = new ArrayList<IcfgEdge>();
        this.mTransitions.add(transition);
    }

    public Backbone(Backbone other) {
        this.mTransitions = new ArrayList<IcfgEdge>(other.mTransitions);
    }

    public void addTransition(IcfgEdge transition) {
        this.mTransitions.add(transition);
    }

    public boolean containsLocation(IcfgLocation location) {
        for (IcfgEdge transition : this.mTransitions) {
            if (!((IcfgLocation)transition.getSource()).equals((Object)location)) continue;
            return true;
        }
        return this.getLastLocation().equals((Object)location);
    }

    public boolean endsInLoop() {
        IcfgLocation lastLocation = this.getLastLocation();
        for (IcfgEdge edge : this.mTransitions) {
            if (!((IcfgLocation)edge.getSource()).equals((Object)lastLocation)) continue;
            return true;
        }
        return false;
    }

    public IcfgLocation getLastLocation() {
        return (IcfgLocation)this.mTransitions.get(this.mTransitions.size() - 1).getTarget();
    }

    public IcfgEdge getLoopEntryTransition() {
        IcfgLocation loopEntry = this.getLastLocation();
        for (IcfgEdge edge : this.mTransitions) {
            if (!((IcfgLocation)edge.getSource()).equals((Object)loopEntry)) continue;
            return edge;
        }
        return null;
    }

    public List<IcfgEdge> getTransitions() {
        return this.mTransitions;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        for (IcfgEdge edge : this.mTransitions) {
            builder.append(edge.getSource());
            builder.append(", ");
        }
        builder.append(this.getLastLocation());
        builder.append("]");
        return builder.toString();
    }
}

