/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.woelfing;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.woelfing.SymbolicMemory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IteratedSymbolicMemory
extends SymbolicMemory {
    private final List<TermVariable> mLoopCounters;
    private final Map<TermVariable, TermVariable> mRenamedVars = new HashMap<TermVariable, TermVariable>();
    private final List<SymbolicMemory> mSymbolicMemories;

    public IteratedSymbolicMemory(ManagedScript script, List<SymbolicMemory> symbolicMemories) {
        super(script);
        this.mSymbolicMemories = symbolicMemories;
        int numLoops = this.mSymbolicMemories.size();
        this.mLoopCounters = new ArrayList<TermVariable>(numLoops);
        Sort sort = SmtSortUtils.getIntSort((ManagedScript)this.mScript);
        int i = 0;
        while (i < numLoops) {
            this.mLoopCounters.add(this.mScript.constructFreshTermVariable("loopCounter", sort));
            ++i;
        }
        for (SymbolicMemory symbolicMemory : this.mSymbolicMemories) {
            TermVariable newTermVar;
            TermVariable termVar;
            this.mOverapproximation |= symbolicMemory.isOverapproximation();
            for (IProgramVar var : symbolicMemory.mInVars.keySet()) {
                termVar = symbolicMemory.mInVars.get(var);
                if (this.mInVars.containsKey(var)) {
                    assert (!((TermVariable)this.mInVars.get(var)).equals(termVar));
                    this.mRenamedVars.put(termVar, (TermVariable)this.mInVars.get(var));
                    continue;
                }
                if (this.mRenamedVars.containsKey(termVar)) {
                    this.mInVars.put(var, this.mRenamedVars.get(termVar));
                    continue;
                }
                newTermVar = this.mScript.constructFreshCopy(termVar);
                this.mRenamedVars.put(termVar, newTermVar);
                this.mInVars.put(var, newTermVar);
            }
            for (IProgramVar var : symbolicMemory.mOutVars.keySet()) {
                termVar = symbolicMemory.mOutVars.get(var);
                if (this.mOutVars.containsKey(var)) {
                    assert (!((TermVariable)this.mOutVars.get(var)).equals(termVar));
                    this.mRenamedVars.put(termVar, (TermVariable)this.mOutVars.get(var));
                    continue;
                }
                if (this.mRenamedVars.containsKey(termVar)) {
                    this.mOutVars.put(var, this.mRenamedVars.get(termVar));
                    continue;
                }
                newTermVar = this.mScript.constructFreshCopy(termVar);
                this.mRenamedVars.put(termVar, newTermVar);
                this.mOutVars.put(var, newTermVar);
            }
        }
        ArrayDeque deque = new ArrayDeque(this.mOutVars.keySet());
        while (!deque.isEmpty()) {
            IProgramVar var = (IProgramVar)deque.pop();
            Term iteratedTerm = this.getIteratedTerm(var);
            if (iteratedTerm != null) {
                this.mVariableTerms.put((TermVariable)this.mOutVars.get(var), iteratedTerm);
                continue;
            }
            this.mOverapproximation = true;
        }
    }

    private Term getIteratedTerm(IProgramVar var) {
        Term[] terms = new Term[this.mSymbolicMemories.size()];
        int i = 0;
        while (i < terms.length) {
            terms[i] = this.mSymbolicMemories.get(i).getVariableTerm(var);
            ++i;
        }
        Term result = (Term)this.mInVars.get(var);
        ConstantTerm constantTerm = null;
        ArrayList<TermVariable> constantLoopCounters = new ArrayList<TermVariable>();
        int i2 = 0;
        while (i2 < terms.length) {
            Term term = this.simplifyTerm(this.mSymbolicMemories.get(i2), terms[i2]);
            if (term == null) {
                return null;
            }
            if (term instanceof ApplicationTerm) {
                ApplicationTerm appTerm = (ApplicationTerm)term;
                assert ("+".equals(appTerm.getFunction().getName()));
                Term[] params = appTerm.getParameters();
                if (params[0] != this.mInVars.get(var)) {
                    return null;
                }
                Term[] newParams = new Term[params.length];
                newParams[0] = result;
                int j = 1;
                while (j < params.length) {
                    if (!(params[j] instanceof ConstantTerm)) {
                        return null;
                    }
                    newParams[j] = this.mScript.getScript().term("*", new Term[]{(Term)this.mLoopCounters.get(i2), params[j]});
                    ++j;
                }
                result = this.mScript.getScript().term("+", IteratedSymbolicMemory.mergeSums(newParams));
            } else if (term instanceof TermVariable) {
                if (term != this.mInVars.get(var)) {
                    return null;
                }
            } else if (term instanceof ConstantTerm) {
                if (constantTerm != null && constantTerm != term) {
                    return null;
                }
                constantTerm = (ConstantTerm)term;
                constantLoopCounters.add(this.mLoopCounters.get(i2));
            } else {
                throw new AssertionError((Object)"Unexpected term type.");
            }
            ++i2;
        }
        if (constantTerm != null) {
            if (result != this.mInVars.get(var)) {
                return null;
            }
            Term zeroTerm = Rational.ZERO.toTerm(SmtSortUtils.getIntSort((ManagedScript)this.mScript));
            Term condition = this.mScript.getScript().term("false", new Term[0]);
            for (TermVariable loopCounter : constantLoopCounters) {
                Term term = this.mScript.getScript().term(">", new Term[]{loopCounter, zeroTerm});
                condition = SmtUtils.or((Script)this.mScript.getScript(), (Term[])new Term[]{condition, term});
            }
            if (result == null) {
                TermVariable newTermVar = this.mScript.constructFreshCopy(var.getTermVariable());
                this.mInVars.put(var, newTermVar);
                result = newTermVar;
            }
            return this.mScript.getScript().term("ite", new Term[]{condition, constantTerm, result});
        }
        return result;
    }

    private static Term[] mergeSums(Term[] params) {
        ArrayList<Term> newParams = new ArrayList<Term>(Arrays.asList(params));
        int i = 0;
        while (i < newParams.size()) {
            if (newParams.get(i) instanceof ApplicationTerm && "+".equals(((ApplicationTerm)newParams.get(i)).getFunction().getName())) {
                ApplicationTerm appTerm = (ApplicationTerm)newParams.get(i);
                newParams.remove(i);
                newParams.addAll(i, Arrays.asList(appTerm.getParameters()));
            }
            ++i;
        }
        return newParams.toArray(new Term[0]);
    }

    private Term simplifyTerm(SymbolicMemory symbolicMemory, Term term) {
        if (term instanceof TermVariable) {
            if (this.mRenamedVars.containsKey(term)) {
                return this.simplifyTerm(symbolicMemory, (Term)this.mRenamedVars.get(term));
            }
            if (this.mInVars.containsValue(term)) {
                return term;
            }
            Term t = symbolicMemory.getVariableTerm((TermVariable)term);
            return this.simplifyTerm(symbolicMemory, t);
        }
        if (term instanceof ApplicationTerm) {
            ApplicationTerm appTerm = (ApplicationTerm)term;
            if ("+".equals(appTerm.getFunction().getName())) {
                Term[] params = (Term[])appTerm.getParameters().clone();
                int i = 0;
                while (i < params.length) {
                    params[i] = this.simplifyTerm(symbolicMemory, params[i]);
                    if (params[i] == null) {
                        return null;
                    }
                    ++i;
                }
                params = IteratedSymbolicMemory.mergeSums(params);
                assert (this.mInVars.containsValue(params[0]));
                return this.mScript.getScript().term("+", params);
            }
        } else if (term instanceof ConstantTerm) {
            return term;
        }
        return null;
    }

    @Override
    public Term replaceTermVars(Term term, Map<IProgramVar, TermVariable> termInVars) {
        if (this.mRenamedVars.containsKey(term) && (termInVars == null || !termInVars.containsValue(term))) {
            if (this.mOutVars.containsValue(this.mRenamedVars.get(term))) {
                return this.replaceTermVars((Term)this.mRenamedVars.get(term), termInVars);
            }
            assert (false);
        }
        if (this.mRenamedVars.containsKey(term) && termInVars != null && termInVars.containsValue(term)) {
            for (Map.Entry<IProgramVar, TermVariable> entry : termInVars.entrySet()) {
                if (!entry.getValue().equals(term) || this.mOutVars.containsKey(entry.getKey())) continue;
                return (Term)this.mRenamedVars.get(term);
            }
        }
        return super.replaceTermVars(term, termInVars);
    }

    public List<TermVariable> getLoopCounters() {
        return this.mLoopCounters;
    }

    public SymbolicMemory getSymbolicMemory(int index) {
        return this.mSymbolicMemories.get(index);
    }
}

