/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.woelfing;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.IIcfgTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.ILocationFactory;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.IcfgTransformationBacktranslator;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.TransformedIcfgBuilder;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.woelfing.Backbone;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.woelfing.IteratedSymbolicMemory;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.woelfing.SymbolicMemory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.BasicIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgInternalTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgReturnTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgInternalTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.TermClassifier;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Util;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class LoopAccelerationIcfgTransformer<INLOC extends IcfgLocation, OUTLOC extends IcfgLocation>
implements IIcfgTransformer<OUTLOC> {
    private final ILogger mLogger;
    private final IIcfg<OUTLOC> mResultIcfg;
    private final Set<IcfgEdge> mLoopEntryTransitions;
    private final Map<INLOC, List<Backbone>> mBackbones;
    private final Set<Backbone> mExitBackbones;
    private final Map<Backbone, TransFormula> mBackboneTransformulas;
    private final ManagedScript mScript;
    private final IUltimateServiceProvider mServices;

    public LoopAccelerationIcfgTransformer(ILogger logger, IIcfg<INLOC> originalIcfg, ILocationFactory<INLOC, OUTLOC> funLocFac, IcfgTransformationBacktranslator backtranslationTracker, Class<OUTLOC> outLocationClass, String newIcfgIdentifier, IUltimateServiceProvider services) {
        IIcfg<INLOC> origIcfg = Objects.requireNonNull(originalIcfg);
        this.mLogger = Objects.requireNonNull(logger);
        this.mLoopEntryTransitions = new HashSet<IcfgEdge>();
        this.mBackbones = new HashMap<INLOC, List<Backbone>>();
        this.mExitBackbones = new HashSet<Backbone>();
        this.mBackboneTransformulas = new HashMap<Backbone, TransFormula>();
        this.mScript = origIcfg.getCfgSmtToolkit().getManagedScript();
        this.mServices = services;
        BasicIcfg resultIcfg = new BasicIcfg(newIcfgIdentifier, originalIcfg.getCfgSmtToolkit(), outLocationClass);
        TransformedIcfgBuilder<INLOC, OUTLOC> lst = new TransformedIcfgBuilder<INLOC, OUTLOC>(this.mLogger, funLocFac, backtranslationTracker, origIcfg, resultIcfg);
        this.mResultIcfg = this.transform(origIcfg, resultIcfg, lst, backtranslationTracker);
        lst.finish();
    }

    private IIcfg<OUTLOC> transform(IIcfg<INLOC> origIcfg, BasicIcfg<OUTLOC> resultIcfg, TransformedIcfgBuilder<INLOC, OUTLOC> lst, IcfgTransformationBacktranslator backtranslationTracker) {
        this.findAllBackbones(origIcfg.getInitialNodes());
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)"Found the following backbones:");
            this.mLogger.debug(this.mBackbones);
            this.mLogger.debug(this.mExitBackbones);
        }
        Set init = origIcfg.getInitialNodes();
        ArrayDeque<IcfgLocation> open = new ArrayDeque<IcfgLocation>(init);
        HashSet<IcfgLocation> closed = new HashSet<IcfgLocation>();
        while (!open.isEmpty()) {
            IcfgLocation oldSource = (IcfgLocation)open.removeFirst();
            if (!closed.add(oldSource)) continue;
            OUTLOC newSource = lst.createNewLocation(oldSource);
            HashSet<Triple> returnTransitions = new HashSet<Triple>();
            for (IcfgEdge oldTransition : oldSource.getOutgoingEdges()) {
                if (this.mLoopEntryTransitions.contains(oldTransition)) continue;
                IcfgLocation oldTarget = (IcfgLocation)oldTransition.getTarget();
                open.add(oldTarget);
                OUTLOC newTarget = lst.createNewLocation(oldTarget);
                if (this.mBackbones.containsKey(oldSource)) {
                    IcfgEdge newTransition = this.addAcceleratedTransition(oldTransition, newSource, newTarget, lst);
                    backtranslationTracker.mapEdges((IIcfgTransition<IcfgLocation>)newTransition, (IIcfgTransition<IcfgLocation>)oldTransition);
                    continue;
                }
                if (oldTransition instanceof IIcfgReturnTransition) {
                    returnTransitions.add(new Triple(newSource, newTarget, (Object)((IIcfgReturnTransition)oldTransition)));
                    continue;
                }
                lst.createNewTransition(newSource, newTarget, oldTransition);
            }
            returnTransitions.stream().filter(a -> lst.isCorrespondingCallContained((IIcfgReturnTransition)a.getThird())).forEach(a -> {
                IcfgEdge icfgEdge = lst.createNewTransition((IcfgLocation)a.getFirst(), (IcfgLocation)a.getSecond(), (IcfgEdge)a.getThird());
            });
        }
        HashSet<IcfgEdge> transformedEdges = new HashSet<IcfgEdge>();
        block2: for (Backbone backbone : this.mExitBackbones) {
            List<IcfgEdge> transitions = backbone.getTransitions();
            int i = 0;
            while (i < transitions.size()) {
                IcfgEdge edge = transitions.get(i);
                IcfgLocation oldSource = (IcfgLocation)edge.getSource();
                if (i > 0 && closed.contains(oldSource)) continue block2;
                if (!transformedEdges.contains(edge)) {
                    IcfgLocation oldTarget = (IcfgLocation)edge.getTarget();
                    OUTLOC newSource = lst.createNewLocation(oldSource);
                    OUTLOC newTarget = lst.createNewLocation(oldTarget);
                    if (i == 0) {
                        IcfgEdge newTransition = this.addAcceleratedTransition(edge, newSource, newTarget, lst);
                        backtranslationTracker.mapEdges((IIcfgTransition<IcfgLocation>)newTransition, (IIcfgTransition<IcfgLocation>)edge);
                    } else {
                        lst.createNewTransition(newSource, newTarget, edge);
                    }
                    transformedEdges.add(edge);
                }
                ++i;
            }
        }
        return resultIcfg;
    }

    private IcfgEdge addAcceleratedTransition(IcfgEdge oldTransition, OUTLOC newSource, OUTLOC newTarget, TransformedIcfgBuilder<INLOC, OUTLOC> lst) {
        IcfgLocation oldSource = (IcfgLocation)oldTransition.getSource();
        IteratedSymbolicMemory iteratedSymbolicMemory = this.getIteratedSymbolicMemoryForLoop(oldSource);
        UnmodifiableTransFormula loopTf = this.getLoopTransFormula(iteratedSymbolicMemory, this.mBackbones.get(oldSource));
        UnmodifiableTransFormula tf = TransFormulaUtils.sequentialComposition((ILogger)this.mLogger, (IUltimateServiceProvider)this.mServices, (ManagedScript)this.mScript, (boolean)true, (boolean)true, (boolean)false, (SmtUtils.XnfConversionTechnique)SmtUtils.XnfConversionTechnique.BOTTOM_UP_WITH_LOCAL_SIMPLIFICATION, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA, Arrays.asList(loopTf, oldTransition.getTransformula()));
        assert (oldTransition instanceof IIcfgInternalTransition);
        boolean isOverapprox = iteratedSymbolicMemory.isOverapproximation() || iteratedSymbolicMemory.getLoopCounters().size() > 1;
        IcfgInternalTransition newTransition = lst.createNewInternalTransition(newSource, newTarget, tf, isOverapprox);
        return newTransition;
    }

    private void findAllBackbones(Set<INLOC> initialNodes) {
        ArrayList<Backbone> incompleteBackbones = new ArrayList<Backbone>();
        for (IcfgLocation location : initialNodes) {
            for (IcfgEdge edge : location.getOutgoingEdges()) {
                LoopAccelerationIcfgTransformer.checkTransition(edge);
                incompleteBackbones.add(new Backbone(edge));
            }
            this.mBackbones.put(location, new ArrayList());
        }
        while (!incompleteBackbones.isEmpty()) {
            int i = incompleteBackbones.size() - 1;
            while (i >= 0) {
                IcfgLocation entryLocation;
                Backbone backbone = (Backbone)incompleteBackbones.get(i);
                IcfgLocation lastLocation = backbone.getLastLocation();
                if (!lastLocation.equals((Object)(entryLocation = (IcfgLocation)backbone.getTransitions().get(0).getSource())) && backbone.endsInLoop()) {
                    incompleteBackbones.remove(i);
                    IcfgEdge loopEntryTransition = backbone.getLoopEntryTransition();
                    if (!this.mLoopEntryTransitions.contains(loopEntryTransition)) {
                        this.mLoopEntryTransitions.add(loopEntryTransition);
                        incompleteBackbones.add(new Backbone(loopEntryTransition));
                        this.mBackbones.putIfAbsent((IcfgLocation)loopEntryTransition.getSource(), new ArrayList());
                    }
                } else if (lastLocation.equals((Object)entryLocation)) {
                    assert (backbone.endsInLoop());
                    incompleteBackbones.remove(i);
                    this.mBackbones.get(entryLocation).add(backbone);
                } else if (lastLocation.getOutgoingEdges().isEmpty()) {
                    assert (!backbone.endsInLoop());
                    incompleteBackbones.remove(i);
                    if (!initialNodes.contains(entryLocation)) {
                        this.mExitBackbones.add(backbone);
                    }
                }
                --i;
            }
            int backboneSize = incompleteBackbones.size();
            int i2 = 0;
            while (i2 < backboneSize) {
                Backbone backbone = (Backbone)incompleteBackbones.get(i2);
                IcfgLocation location = backbone.getLastLocation();
                List outgoingEdges = location.getOutgoingEdges();
                int j = 0;
                while (j < outgoingEdges.size()) {
                    IcfgEdge edge = (IcfgEdge)outgoingEdges.get(j);
                    LoopAccelerationIcfgTransformer.checkTransition(edge);
                    if (j == outgoingEdges.size() - 1) {
                        backbone.addTransition(edge);
                    } else {
                        Backbone newBackbone = new Backbone(backbone);
                        newBackbone.addTransition(edge);
                        incompleteBackbones.add(newBackbone);
                    }
                    ++j;
                }
                ++i2;
            }
        }
        for (IcfgLocation location : initialNodes) {
            if (!this.mBackbones.get(location).isEmpty()) continue;
            this.mBackbones.remove(location);
        }
        this.validateBackbones();
    }

    private void validateBackbones() {
        ArrayList<Backbone> backbones = new ArrayList<Backbone>();
        for (List<Backbone> value : this.mBackbones.values()) {
            backbones.addAll(value);
        }
        HashSet<IcfgLocation> invalidLoopEntryLocations = new HashSet<IcfgLocation>();
        for (Backbone backbone1 : backbones) {
            for (Backbone backbone2 : backbones) {
                if (backbone1.getLastLocation().equals((Object)backbone2.getLastLocation()) || !backbone1.containsLocation(backbone2.getLastLocation()) || !backbone2.containsLocation(backbone1.getLastLocation())) continue;
                invalidLoopEntryLocations.add(backbone1.getLastLocation());
                invalidLoopEntryLocations.add(backbone2.getLastLocation());
            }
        }
        ArrayList<Backbone> invalidExitBackbones = new ArrayList<Backbone>();
        for (Backbone backbone : this.mExitBackbones) {
            if (!invalidLoopEntryLocations.contains(backbone.getTransitions().get(0).getSource())) continue;
            invalidExitBackbones.add(backbone);
        }
        this.mExitBackbones.removeAll(invalidExitBackbones);
        for (IcfgLocation location : invalidLoopEntryLocations) {
            for (Backbone backbone : this.mBackbones.get(location)) {
                this.mLoopEntryTransitions.remove(backbone.getLoopEntryTransition());
            }
            this.mBackbones.remove(location);
        }
    }

    private static void checkTransition(IcfgEdge transition) {
        TermClassifier tclassifier = new TermClassifier();
        tclassifier.checkTerm(transition.getTransformula().getFormula());
        if (tclassifier.hasArrays()) {
            throw new UnsupportedOperationException("Cannot handle arrays");
        }
    }

    private IteratedSymbolicMemory getIteratedSymbolicMemoryForLoop(INLOC loopEntry) {
        List<Backbone> backbones = this.mBackbones.get(loopEntry);
        ArrayList<SymbolicMemory> symbolicMemories = new ArrayList<SymbolicMemory>();
        for (Backbone backbone : backbones) {
            boolean overapproximation = false;
            ArrayList<UnmodifiableTransFormula> transFormulas = new ArrayList<UnmodifiableTransFormula>();
            for (IcfgEdge edge : backbone.getTransitions()) {
                UnmodifiableTransFormula tf = edge.getTransformula();
                transFormulas.add(tf);
                IcfgLocation target = (IcfgLocation)edge.getTarget();
                if (target.equals((Object)backbone.getLastLocation()) || !this.mBackbones.containsKey(target)) continue;
                IteratedSymbolicMemory iteratedSymbolicMemory = this.getIteratedSymbolicMemoryForLoop(target);
                overapproximation |= iteratedSymbolicMemory.isOverapproximation() || iteratedSymbolicMemory.getLoopCounters().size() > 1;
                UnmodifiableTransFormula loopTf = this.getLoopTransFormula(iteratedSymbolicMemory, this.mBackbones.get(target));
                transFormulas.add(loopTf);
            }
            UnmodifiableTransFormula tf = TransFormulaUtils.sequentialComposition((ILogger)this.mLogger, (IUltimateServiceProvider)this.mServices, (ManagedScript)this.mScript, (boolean)true, (boolean)true, (boolean)false, (SmtUtils.XnfConversionTechnique)SmtUtils.XnfConversionTechnique.BOTTOM_UP_WITH_LOCAL_SIMPLIFICATION, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA, transFormulas);
            this.mBackboneTransformulas.put(backbone, (TransFormula)tf);
            SymbolicMemory symbolicMemory = new SymbolicMemory(this.mScript, (TransFormula)tf, overapproximation);
            symbolicMemories.add(symbolicMemory);
        }
        return new IteratedSymbolicMemory(this.mScript, symbolicMemories);
    }

    private UnmodifiableTransFormula getLoopTransFormula(IteratedSymbolicMemory iteratedSymbolicMemory, List<Backbone> backbones) {
        int numLoops = backbones.size();
        List<TermVariable> loopCounters = iteratedSymbolicMemory.getLoopCounters();
        assert (loopCounters.size() == numLoops);
        HashSet<TermVariable> auxVars = new HashSet<TermVariable>(loopCounters);
        ArrayList<TermVariable> loopIterators = new ArrayList<TermVariable>(numLoops);
        HashMap<Term, TermVariable> substitutionMapping = new HashMap<Term, TermVariable>();
        Sort sort = SmtSortUtils.getIntSort((ManagedScript)this.mScript);
        int i = 0;
        while (i < numLoops) {
            TermVariable loopIterator = this.mScript.constructFreshTermVariable("loopIterator", sort);
            loopIterators.add(loopIterator);
            substitutionMapping.put((Term)loopCounters.get(i), loopIterator);
            ++i;
        }
        Term[] terms = new Term[numLoops];
        Term zeroTerm = Rational.ZERO.toTerm(sort);
        int i2 = 0;
        while (i2 < numLoops) {
            TransFormula tf = this.mBackboneTransformulas.get(backbones.get(i2));
            auxVars.addAll(tf.getAuxVars());
            Term term = tf.getFormula();
            term = iteratedSymbolicMemory.getSymbolicMemory(i2).replaceTermVars(term, null);
            term = iteratedSymbolicMemory.replaceTermVars(term, tf.getInVars());
            term = Substitution.apply((ManagedScript)this.mScript, substitutionMapping, (Term)term);
            ArrayList<TermVariable> quantifiers = new ArrayList<TermVariable>();
            int j = 0;
            while (j < numLoops) {
                if (i2 != j) {
                    quantifiers.add((TermVariable)loopIterators.get(j));
                    Term iteratorCondition = SmtUtils.and((Script)this.mScript.getScript(), (Term[])new Term[]{this.mScript.getScript().term("<=", new Term[]{zeroTerm, (Term)loopIterators.get(j)}), this.mScript.getScript().term("<=", new Term[]{(Term)loopIterators.get(j), (Term)loopCounters.get(j)})});
                    term = SmtUtils.and((Script)this.mScript.getScript(), (Term[])new Term[]{iteratorCondition, term});
                }
                ++j;
            }
            if (!quantifiers.isEmpty()) {
                term = this.mScript.getScript().quantifier(0, quantifiers.toArray(new TermVariable[0]), term, (Term[][])new Term[0][]);
            }
            Term iteratorCondition = SmtUtils.and((Script)this.mScript.getScript(), (Term[])new Term[]{this.mScript.getScript().term("<=", new Term[]{zeroTerm, (Term)loopIterators.get(i2)}), this.mScript.getScript().term("<", new Term[]{(Term)loopIterators.get(i2), (Term)loopCounters.get(i2)})});
            term = Util.implies((Script)this.mScript.getScript(), (Term[])new Term[]{iteratorCondition, term});
            Term term1 = term = this.mScript.getScript().quantifier(1, new TermVariable[]{(TermVariable)loopIterators.get(i2)}, term, (Term[][])new Term[0][]);
            terms[i2] = term = PartialQuantifierElimination.eliminateCompat((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mScript, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA, (Term)term1);
            ++i2;
        }
        Term resultTerm = SmtUtils.and((Script)this.mScript.getScript(), (Term[])terms);
        int i3 = 0;
        while (i3 < numLoops) {
            resultTerm = SmtUtils.and((Script)this.mScript.getScript(), (Term[])new Term[]{resultTerm, this.mScript.getScript().term(">=", new Term[]{(Term)loopCounters.get(i3), zeroTerm})});
            ++i3;
        }
        Term term = resultTerm = SmtUtils.and((Script)this.mScript.getScript(), (Term[])new Term[]{resultTerm, iteratedSymbolicMemory.toTerm()});
        resultTerm = PartialQuantifierElimination.eliminateCompat((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mScript, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA, (Term)term);
        TransFormulaBuilder builder = new TransFormulaBuilder(iteratedSymbolicMemory.getInVars(), iteratedSymbolicMemory.getOutVars(), true, null, true, null, false);
        builder.setFormula(resultTerm);
        builder.addAuxVarsButRenameToFreshCopies(auxVars, this.mScript);
        builder.setInfeasibility(UnmodifiableTransFormula.Infeasibility.NOT_DETERMINED);
        return builder.finishConstruction(this.mScript);
    }

    @Override
    public IIcfg<OUTLOC> getResult() {
        return this.mResultIcfg;
    }
}

