/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.woelfing;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.HashMap;
import java.util.Map;

public class SymbolicMemory {
    protected final ManagedScript mScript;
    protected final Map<IProgramVar, TermVariable> mInVars;
    protected final Map<IProgramVar, TermVariable> mOutVars;
    protected final Map<TermVariable, Term> mVariableTerms;
    protected boolean mOverapproximation;

    protected SymbolicMemory(ManagedScript script) {
        this.mScript = script;
        this.mInVars = new HashMap<IProgramVar, TermVariable>();
        this.mOutVars = new HashMap<IProgramVar, TermVariable>();
        this.mVariableTerms = new HashMap<TermVariable, Term>();
    }

    public SymbolicMemory(ManagedScript script, TransFormula tf, boolean overapproximation) {
        this.mScript = script;
        this.mInVars = tf.getInVars();
        this.mOutVars = tf.getOutVars();
        this.mVariableTerms = new HashMap<TermVariable, Term>();
        this.mOverapproximation = overapproximation;
        Term term = tf.getFormula();
        if (!(term instanceof ApplicationTerm)) {
            return;
        }
        ApplicationTerm appTerm = (ApplicationTerm)term;
        if ("and".equals(appTerm.getFunction().getName())) {
            Term[] termArray = appTerm.getParameters();
            int n = termArray.length;
            int n2 = 0;
            while (n2 < n) {
                Term[] params;
                Term innerTerm = termArray[n2];
                if (innerTerm instanceof ApplicationTerm && "=".equals(((ApplicationTerm)innerTerm).getFunction().getName()) && (params = ((ApplicationTerm)innerTerm).getParameters())[0] instanceof TermVariable && !this.mInVars.containsValue(params[0]) && !this.mVariableTerms.containsKey(params[0])) {
                    this.mVariableTerms.put((TermVariable)params[0], params[1]);
                }
                ++n2;
            }
        }
    }

    public Term replaceTermVars(Term term, Map<IProgramVar, TermVariable> termInVars) {
        if (this.mVariableTerms.containsKey(term)) {
            Term newTerm = this.mVariableTerms.get(term);
            return newTerm == null ? term : this.replaceTermVars(newTerm, termInVars);
        }
        if (termInVars != null && termInVars.values().contains(term)) {
            for (Map.Entry<IProgramVar, TermVariable> entry : termInVars.entrySet()) {
                if (entry.getValue() != term || !this.mOutVars.containsKey(entry.getKey())) continue;
                return this.replaceTermVars((Term)this.mOutVars.get(entry.getKey()), termInVars);
            }
        }
        if (term instanceof ApplicationTerm) {
            ApplicationTerm appTerm = (ApplicationTerm)term;
            Term[] params = (Term[])appTerm.getParameters().clone();
            int i = 0;
            while (i < params.length) {
                params[i] = this.replaceTermVars(params[i], termInVars);
                ++i;
            }
            if ("=".equals(appTerm.getFunction().getName()) && params.length == 2 && params[0].equals(params[1])) {
                return this.mScript.getScript().term("true", new Term[0]);
            }
            return this.mScript.getScript().term(appTerm.getFunction().getName(), params);
        }
        return term;
    }

    public Term toTerm() {
        Term term = this.mScript.getScript().term("true", new Term[0]);
        for (Map.Entry<TermVariable, Term> entry : this.mVariableTerms.entrySet()) {
            term = SmtUtils.and((Script)this.mScript.getScript(), (Term[])new Term[]{term, this.mScript.getScript().term("=", new Term[]{(Term)entry.getKey(), entry.getValue()})});
        }
        return term;
    }

    public Map<IProgramVar, TermVariable> getInVars() {
        return this.mInVars;
    }

    public Map<IProgramVar, TermVariable> getOutVars() {
        return this.mOutVars;
    }

    public Map<TermVariable, Term> getVariableTerms() {
        return this.mVariableTerms;
    }

    public Term getVariableTerm(IProgramVar var) {
        if (!this.mOutVars.containsKey(var)) {
            return null;
        }
        return this.getVariableTerm(this.mOutVars.get(var));
    }

    public Term getVariableTerm(TermVariable termVar) {
        return this.mVariableTerms.get(termVar);
    }

    public boolean isOverapproximation() {
        return this.mOverapproximation;
    }

    public String toString() {
        return this.mVariableTerms.toString();
    }
}

