/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.mapelim.monniaux;

import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelUtils;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.IIcfgTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.ILocationFactory;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.IcfgTransformationBacktranslator;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.TransformedIcfgBuilder;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.IdentityTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.mapelim.monniaux.StoreSelectEqualityCollector;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.FormulaToEqDisjunctiveConstraintConverter;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.BasicIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgInternalTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdgeIterator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgInternalTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramVarUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class MonniauxMapEliminator
implements IIcfgTransformer<IcfgLocation> {
    private final IUltimateServiceProvider mServices;
    private final ManagedScript mMgdScript;
    private final IIcfg<IcfgLocation> mIcfg;
    private final IIcfg<IcfgLocation> mResultIcfg;
    private final ILogger mLogger;
    private final IcfgTransformationBacktranslator mBacktranslationTracker;
    private final int mCells;

    public MonniauxMapEliminator(IUltimateServiceProvider services, ILogger logger, IIcfg<IcfgLocation> icfg, IcfgTransformationBacktranslator backtranslationTracker, int cells) {
        this.mServices = services;
        this.mIcfg = Objects.requireNonNull(icfg);
        this.mMgdScript = Objects.requireNonNull(this.mIcfg.getCfgSmtToolkit().getManagedScript());
        this.mLogger = logger;
        this.mBacktranslationTracker = backtranslationTracker;
        this.mCells = cells;
        this.mResultIcfg = this.eliminateMaps();
    }

    @Override
    public IIcfg<IcfgLocation> getResult() {
        return this.mResultIcfg;
    }

    private IIcfg<IcfgLocation> eliminateMaps() {
        BasicIcfg resultIcfg = new BasicIcfg(String.valueOf(this.mIcfg.getIdentifier()) + "ME", this.mIcfg.getCfgSmtToolkit(), IcfgLocation.class);
        ILocationFactory<IcfgLocation, IcfgLocation> funLocFac = (oldLocation, debugIdentifier, procedure) -> {
            IcfgLocation rtr = new IcfgLocation(debugIdentifier, procedure);
            ModelUtils.copyAnnotations((IElement)oldLocation, (IElement)rtr);
            return rtr;
        };
        TransformedIcfgBuilder<IcfgLocation, IcfgLocation> lst = new TransformedIcfgBuilder<IcfgLocation, IcfgLocation>(this.mLogger, funLocFac, this.mBacktranslationTracker, new IdentityTransformer(this.mIcfg.getCfgSmtToolkit()), this.mIcfg, resultIcfg);
        this.mMgdScript.lock((Object)this);
        this.iterate(lst);
        lst.finish();
        this.mMgdScript.unlock((Object)this);
        return resultIcfg;
    }

    private void iterate(TransformedIcfgBuilder<IcfgLocation, IcfgLocation> lst) {
        Script script = this.mMgdScript.getScript();
        IIcfgSymbolTable symboltable = this.mIcfg.getCfgSmtToolkit().getSymbolTable();
        Set globals = symboltable.getGlobals();
        HashSet locals = new HashSet();
        for (Map.Entry entry : this.mIcfg.getProcedureEntryNodes().entrySet()) {
            String proc = (String)entry.getKey();
            Set someLocals = symboltable.getLocals(proc);
            locals.addAll(someLocals);
        }
        HashSet programArrayVars = new HashSet(globals.size() + locals.size());
        globals.stream().filter(a -> a.getSort().isArraySort()).forEach(programArrayVars::add);
        locals.stream().filter(a -> a.getSort().isArraySort()).forEach(programArrayVars::add);
        LinkedHashMap idxVars = new LinkedHashMap();
        LinkedHashMap<IProgramVar, List<IProgramVar>> valVars = new LinkedHashMap<IProgramVar, List<IProgramVar>>();
        LinkedHashSet<ProgramNonOldVar> allPrgValVars = new LinkedHashSet<ProgramNonOldVar>();
        for (IProgramVar var : programArrayVars) {
            assert (var.getSort().isArraySort());
            assert (var.getSort().getArguments().length == 2) : "Array sort with != 2 arguments";
            Sort indexSort = var.getSort().getArguments()[0];
            Sort valueSort = var.getSort().getArguments()[1];
            LinkedHashSet<ProgramNonOldVar> idx = new LinkedHashSet<ProgramNonOldVar>();
            ArrayList<ProgramNonOldVar> val = new ArrayList<ProgramNonOldVar>();
            int i = 0;
            while (i < this.mCells) {
                String idxName = String.valueOf(var.toString()) + "_idx_" + Integer.toString(i);
                String valName = String.valueOf(var.toString()) + "_val_" + Integer.toString(i);
                ProgramNonOldVar varIdx = ProgramVarUtils.constructGlobalProgramVarPair((String)SmtUtils.removeSmtQuoteCharacters((String)idxName), (Sort)indexSort, (ManagedScript)this.mMgdScript, (Object)this);
                ProgramNonOldVar varVal = ProgramVarUtils.constructGlobalProgramVarPair((String)SmtUtils.removeSmtQuoteCharacters((String)valName), (Sort)valueSort, (ManagedScript)this.mMgdScript, (Object)this);
                idx.add(varIdx);
                val.add(varVal);
                allPrgValVars.add(varVal);
                ++i;
            }
            idxVars.put(var, idx);
            valVars.put(var, val);
        }
        LinkedHashMap<IProgramVar, Pair> bools = new LinkedHashMap<IProgramVar, Pair>();
        LinkedHashMap<IProgramVar, Set<Term>> idxAssignments = new LinkedHashMap<IProgramVar, Set<Term>>();
        IcfgEdgeIterator iter = new IcfgEdgeIterator(this.mIcfg);
        while (iter.hasNext()) {
            IcfgEdge transition = iter.next();
            if (transition instanceof IIcfgInternalTransition) {
                Term newTfTerm;
                Term substTerm;
                IIcfgInternalTransition internalTransition = (IIcfgInternalTransition)transition;
                UnmodifiableTransFormula tf = internalTransition.getTransformula();
                Term tfTerm = tf.getFormula();
                FormulaToEqDisjunctiveConstraintConverter.StoreChainSquisher scs = new FormulaToEqDisjunctiveConstraintConverter.StoreChainSquisher(this.mMgdScript);
                Term atMostOneStore = SmtUtils.toDnf((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mMgdScript, (Term)scs.transform(tfTerm), (SmtUtils.XnfConversionTechnique)SmtUtils.XnfConversionTechnique.BOTTOM_UP_WITH_LOCAL_SIMPLIFICATION);
                Collection arrayEqualities = scs.getReplacementEquations();
                Collection newAuxVars = scs.getReplacementTermVariables();
                StoreSelectEqualityCollector ssec = new StoreSelectEqualityCollector();
                ssec.transform(atMostOneStore);
                Boolean iterate = ssec.hasMultDim();
                if (ssec.isEmpty()) {
                    IcfgLocation oldSource = internalTransition.getSource();
                    IcfgLocation newSource = lst.createNewLocation(oldSource);
                    IcfgLocation oldTarget = internalTransition.getTarget();
                    IcfgLocation newTarget = lst.createNewLocation(oldTarget);
                    lst.createNewTransition(newSource, newTarget, (IcfgEdge)internalTransition);
                    continue;
                }
                HashMap<Term, Term> subst = new HashMap<Term, Term>();
                HashSet<TermVariable> auxVars = new HashSet<TermVariable>(tf.getAuxVars());
                for (Term var : newAuxVars) {
                    auxVars.add((TermVariable)var);
                }
                LinkedHashMap<Term, Set<Term>> idxAuxVars = new LinkedHashMap<Term, Set<Term>>();
                LinkedHashMap<Term, List<Term>> valAuxVars = new LinkedHashMap<Term, List<Term>>();
                LinkedHashSet<TermVariable> tempAux = new LinkedHashSet<TermVariable>();
                for (TermVariable termVariable : auxVars) {
                    assert (termVariable.getSort().isArraySort());
                    assert (termVariable.getSort().getArguments().length == 2) : "Array sort with != 2 arguments";
                    if (!termVariable.getSort().isArraySort()) continue;
                    Sort indexSort = termVariable.getSort().getArguments()[0];
                    Sort valueSort = termVariable.getSort().getArguments()[1];
                    LinkedHashSet<TermVariable> idx = new LinkedHashSet<TermVariable>();
                    ArrayList<TermVariable> val = new ArrayList<TermVariable>();
                    int i = 0;
                    while (i < this.mCells) {
                        String idxName = String.valueOf(termVariable.toString()) + "_idx_" + Integer.toString(i);
                        String valName = String.valueOf(termVariable.toString()) + "_val_" + Integer.toString(i);
                        TermVariable varIdx = this.mMgdScript.constructFreshTermVariable(SmtUtils.removeSmtQuoteCharacters((String)idxName), indexSort);
                        TermVariable varVal = this.mMgdScript.constructFreshTermVariable(SmtUtils.removeSmtQuoteCharacters((String)valName), valueSort);
                        idx.add(varIdx);
                        val.add(varVal);
                        tempAux.add(varIdx);
                        tempAux.add(varVal);
                        ++i;
                    }
                    idxAuxVars.put((Term)termVariable, (Set<Term>)idx);
                    valAuxVars.put((Term)termVariable, (List<Term>)val);
                }
                for (Term term : tempAux) {
                    auxVars.add((TermVariable)term);
                }
                HashMap<IProgramVar, TermVariable> hashMap = new HashMap<IProgramVar, TermVariable>(tf.getInVars());
                HashMap<IProgramVar, TermVariable> newOutVars = new HashMap<IProgramVar, TermVariable>(tf.getOutVars());
                LinkedHashMap<Term, List<Term>> hierarchy = new LinkedHashMap<Term, List<Term>>();
                LinkedHashMap<Term, Set<Term>> idxTerms = new LinkedHashMap<Term, Set<Term>>();
                LinkedHashMap<Term, IProgramVar> oldTermToProgramVar = new LinkedHashMap<Term, IProgramVar>();
                LinkedHashMap<Term, IProgramVar> idxTermToIdxProgramVar = new LinkedHashMap<Term, IProgramVar>();
                LinkedHashSet<IProgramVar> oldProgramVars = new LinkedHashSet<IProgramVar>();
                for (IProgramVar var : hashMap.keySet()) {
                    oldProgramVars.add(var);
                }
                for (IProgramVar var : newOutVars.keySet()) {
                    oldProgramVars.add(var);
                }
                LinkedHashMap oldProgramVarsToOutVars = new LinkedHashMap();
                LinkedHashMap oldProgramVarsToInVars = new LinkedHashMap();
                for (IProgramVar arrayVar : programArrayVars) {
                    Term[] params;
                    Term store;
                    Term[] storeParams;
                    Term storeVar;
                    TermVariable valTermVar;
                    ArrayList<TermVariable> valTermVars2;
                    ArrayList<TermVariable> valTermVars;
                    TermVariable arrayInTermVar = (TermVariable)hashMap.remove(arrayVar);
                    TermVariable arrayOutTermVar = (TermVariable)newOutVars.remove(arrayVar);
                    LinkedHashSet<TermVariable> idxTermVarSet = new LinkedHashSet<TermVariable>();
                    for (IProgramVar idxVar : (Set)idxVars.get(arrayVar)) {
                        TermVariable idxTermVar = this.mMgdScript.constructFreshTermVariable(SmtUtils.removeSmtQuoteCharacters((String)(String.valueOf(idxVar.toString()) + "_term")), idxVar.getSort());
                        if (!bools.containsKey(idxVar)) {
                            TermVariable idxBool = this.mMgdScript.constructFreshTermVariable(SmtUtils.removeSmtQuoteCharacters((String)(String.valueOf(idxVar.toString()) + "_term" + "_assigned")), SmtSortUtils.getBoolSort((Script)script));
                            ProgramNonOldVar boolPrg = ProgramVarUtils.constructGlobalProgramVarPair((String)SmtUtils.removeSmtQuoteCharacters((String)(String.valueOf(idxVar.toString()) + "_bool")), (Sort)SmtSortUtils.getBoolSort((Script)script), (ManagedScript)this.mMgdScript, (Object)this);
                            bools.put(idxVar, new Pair((Object)idxBool, (Object)boolPrg));
                        }
                        hashMap.put(idxVar, idxTermVar);
                        newOutVars.put(idxVar, idxTermVar);
                        idxTermToIdxProgramVar.put((Term)idxTermVar, idxVar);
                        idxTermVarSet.add(idxTermVar);
                    }
                    if (arrayInTermVar != null) {
                        idxTerms.put((Term)arrayInTermVar, (Set<Term>)idxTermVarSet);
                    }
                    if (arrayOutTermVar != null) {
                        idxTerms.put((Term)arrayOutTermVar, (Set<Term>)idxTermVarSet);
                    }
                    for (IProgramVar idx : bools.keySet()) {
                        IProgramVar boolPrg = (IProgramVar)((Pair)bools.get(idx)).getSecond();
                        Term boolTerm = (Term)((Pair)bools.get(idx)).getFirst();
                        hashMap.put(boolPrg, (TermVariable)boolTerm);
                        newOutVars.put(boolPrg, (TermVariable)boolTerm);
                    }
                    if (arrayInTermVar != null) {
                        valTermVars = new ArrayList();
                        valTermVars2 = new ArrayList<TermVariable>();
                        for (IProgramVar valVar : (List)valVars.get(arrayVar)) {
                            valTermVar = this.mMgdScript.constructFreshTermVariable(SmtUtils.removeSmtQuoteCharacters((String)(String.valueOf(valVar.toString()) + "_in")), valVar.getSort());
                            hashMap.put(valVar, valTermVar);
                            valTermVars.add(valTermVar);
                            valTermVars2.add(valTermVar);
                        }
                        hierarchy.put((Term)arrayInTermVar, valTermVars);
                        oldProgramVarsToInVars.put(arrayVar, valTermVars2);
                        for (Term aterm : arrayEqualities) {
                            if (!(aterm instanceof ApplicationTerm) || (storeVar = (storeParams = ((ApplicationTerm)(store = (params = ((ApplicationTerm)aterm).getParameters())[0] instanceof ApplicationTerm ? params[0] : params[1])).getParameters())[0]) != arrayInTermVar) continue;
                            hierarchy.put(params[1], valTermVars);
                            idxTerms.put(params[1], (Set)idxTerms.get(arrayInTermVar));
                        }
                    }
                    if (arrayOutTermVar == null) continue;
                    valTermVars = new ArrayList<TermVariable>();
                    valTermVars2 = new ArrayList();
                    for (IProgramVar valVar : (List)valVars.get(arrayVar)) {
                        valTermVar = ssec.hasNoStoEqu() ? (TermVariable)hashMap.get(valVar) : this.mMgdScript.constructFreshTermVariable(SmtUtils.removeSmtQuoteCharacters((String)(String.valueOf(valVar.toString()) + "_out")), valVar.getSort());
                        newOutVars.put(valVar, valTermVar);
                        valTermVars.add(valTermVar);
                        valTermVars2.add(valTermVar);
                        oldTermToProgramVar.put((Term)valTermVar, valVar);
                    }
                    hierarchy.put((Term)arrayOutTermVar, valTermVars);
                    oldProgramVarsToOutVars.put(arrayVar, valTermVars2);
                    for (Term aterm : arrayEqualities) {
                        if (!(aterm instanceof ApplicationTerm) || (storeVar = (storeParams = (store = (params = ((ApplicationTerm)aterm).getParameters())[0] instanceof ApplicationTerm ? (ApplicationTerm)params[0] : (ApplicationTerm)params[1]).getParameters())[0]) != arrayInTermVar) continue;
                        hierarchy.put(params[1], valTermVars);
                        idxTerms.put(params[1], (Set)idxTerms.get(arrayOutTermVar));
                    }
                }
                LinkedHashMap<Term, Term> iterImp = new LinkedHashMap<Term, Term>();
                LinkedHashSet<Term> addendum = new LinkedHashSet<Term>();
                LinkedHashMap<IProgramVar, Pair<List<Term>, Integer>> chain = new LinkedHashMap<IProgramVar, Pair<List<Term>, Integer>>();
                LinkedHashMap<Term, Term> lowValues = new LinkedHashMap<Term, Term>();
                for (Term selectTerm : ssec.getSelectTerms()) {
                    ApplicationTerm aSelectTerm = (ApplicationTerm)selectTerm;
                    substTerm = MonniauxMapEliminator.eliminateSelects(this.mMgdScript, idxTerms, aSelectTerm, hierarchy, auxVars, subst, idxTermToIdxProgramVar, idxAssignments, hashMap, chain, oldProgramVars, this.mCells, valVars, lowValues, idxAuxVars, valAuxVars, iterImp);
                    subst.put(selectTerm, (Term)substTerm.getFirst());
                    addendum.add((Term)substTerm.getSecond());
                }
                for (Term storeTerm : ssec.getStoreTerms()) {
                    ApplicationTerm aStoreTerm = (ApplicationTerm)storeTerm;
                    substTerm = MonniauxMapEliminator.eliminateStores(this.mMgdScript, idxTerms, aStoreTerm, hierarchy, hashMap, oldTermToProgramVar, subst, newAuxVars, idxTermToIdxProgramVar, idxAssignments, chain, this.mCells, valVars, lowValues, oldProgramVars, idxAuxVars, valAuxVars);
                    subst.put(storeTerm, substTerm);
                }
                for (Term equalityTerm : ssec.getEqualityTerms()) {
                    ApplicationTerm aEqualityTerm = (ApplicationTerm)equalityTerm;
                    substTerm = MonniauxMapEliminator.eliminateEqualities(this.mMgdScript, idxTerms, aEqualityTerm, hierarchy, subst);
                    subst.put(equalityTerm, substTerm);
                }
                for (IProgramVar key : hashMap.keySet()) {
                    if (!allPrgValVars.contains(key)) continue;
                    addendum.add(SmtUtils.binaryEquality((Script)script, (Term)((Term)hashMap.get(key)), (Term)((Term)newOutVars.get(key))));
                }
                HashMap disAssgn = new HashMap();
                HashMap<Term, Term> newSubst = new HashMap<Term, Term>();
                Term[] disjuncts = SmtUtils.getDisjuncts((Term)atMostOneStore);
                int i = 0;
                while (i < disjuncts.length) {
                    Object idxs;
                    HashSet wholeSet;
                    Term term = disjuncts[i];
                    StoreSelectEqualityCollector newSsec = new StoreSelectEqualityCollector();
                    newSsec.transform(term);
                    HashSet<Term> ors = new HashSet<Term>();
                    HashSet<Term> storeTerms = new HashSet<Term>(newSsec.getStoreTerms());
                    for (Term storeTerm : storeTerms) {
                        ApplicationTerm aStoreTerm = (ApplicationTerm)storeTerm;
                        Term[] paramsTerm = aStoreTerm.getParameters();
                        Term x = paramsTerm[0];
                        Term y = paramsTerm[0];
                        int j = 0;
                        while (j < paramsTerm.length) {
                            Term param = paramsTerm[j];
                            if (param instanceof ApplicationTerm) {
                                Term[] paramsStore = ((ApplicationTerm)param).getParameters();
                                x = paramsStore[0];
                                y = paramsStore[1];
                            }
                            ++j;
                        }
                        Set idxs2 = (Set)idxTerms.get(x);
                        if (idxs2 == null) {
                            idxs2 = (Set)idxAuxVars.get(x);
                        }
                        for (Term idx : idxs2) {
                            wholeSet = disAssgn.get(i) != null ? new HashSet((Collection)disAssgn.get(i)) : null;
                            if (wholeSet != null) {
                                for (Pair pairAssgn : wholeSet) {
                                    HashSet assgn = new HashSet((Collection)pairAssgn.getSecond());
                                    assgn.add(y);
                                    HashSet<Pair> tempSet = new HashSet<Pair>(wholeSet);
                                    tempSet.add(new Pair((Object)idx, (Object)assgn));
                                    disAssgn.put(i, tempSet);
                                    if (auxVars.contains(idx)) continue;
                                    ors.add((Term)((Pair)bools.get(idxTermToIdxProgramVar.get(idx))).getFirst());
                                }
                                continue;
                            }
                            HashSet<Term> assgn = new HashSet<Term>();
                            assgn.add(y);
                            HashSet<Pair> tempSet = new HashSet<Pair>();
                            tempSet.add(new Pair((Object)idx, assgn));
                            disAssgn.put(i, tempSet);
                            if (auxVars.contains(idx)) continue;
                            ors.add((Term)((Pair)bools.get(idxTermToIdxProgramVar.get(idx))).getFirst());
                        }
                    }
                    HashSet<Term> selectTerms = new HashSet<Term>(newSsec.getSelectTerms());
                    for (Term selectTerm : selectTerms) {
                        ApplicationTerm aSelectTerm = (ApplicationTerm)selectTerm;
                        Term[] paramsTerm = aSelectTerm.getParameters();
                        Term x = paramsTerm[0];
                        Term y = paramsTerm[1];
                        idxs = (Set)idxTerms.get(x);
                        if (idxs == null) {
                            idxs = (Set)idxAuxVars.get(x);
                        }
                        wholeSet = idxs.iterator();
                        while (wholeSet.hasNext()) {
                            Set wholeSet2;
                            Term idx = (Term)wholeSet.next();
                            if (disAssgn.get(i) != null) {
                                HashSet wholeSet3 = new HashSet((Collection)disAssgn.get(i));
                            } else {
                                wholeSet2 = null;
                            }
                            if (wholeSet2 != null) {
                                for (Pair pairAssgn : wholeSet2) {
                                    Set assgn = (Set)pairAssgn.getSecond();
                                    assgn.add(y);
                                    HashSet<Pair> tempSet = new HashSet<Pair>(wholeSet2);
                                    tempSet.add(new Pair((Object)idx, (Object)assgn));
                                    disAssgn.put(i, tempSet);
                                    if (auxVars.contains(idx)) continue;
                                    ors.add((Term)((Pair)bools.get(idxTermToIdxProgramVar.get(idx))).getFirst());
                                }
                                continue;
                            }
                            HashSet<Term> assgn = new HashSet<Term>();
                            assgn.add(y);
                            HashSet<Pair> tempSet = new HashSet<Pair>();
                            tempSet.add(new Pair((Object)idx, assgn));
                            disAssgn.put(i, tempSet);
                            if (auxVars.contains(idx)) continue;
                            ors.add((Term)((Pair)bools.get(idxTermToIdxProgramVar.get(idx))).getFirst());
                        }
                    }
                    if (disAssgn.get(i) != null) {
                        for (Pair pair : (Set)disAssgn.get(i)) {
                            Set assignments = (Set)pair.getSecond();
                            Term idx = (Term)pair.getFirst();
                            HashSet<Term> equalities = new HashSet<Term>();
                            idxs = assignments.iterator();
                            while (idxs.hasNext()) {
                                Term assgn = (Term)idxs.next();
                                equalities.add(SmtUtils.binaryEquality((Script)script, (Term)idx, (Term)assgn));
                            }
                            IProgramVar idxPrgVar = (IProgramVar)idxTermToIdxProgramVar.get(idx);
                            if (idxPrgVar == null) continue;
                            ors.add(SmtUtils.implies((Script)script, (Term)((Term)((Pair)bools.get(idxTermToIdxProgramVar.get(idx))).getFirst()), (Term)SmtUtils.or((Script)script, equalities)));
                        }
                    }
                    ors.add(term);
                    newSubst.put(term, SmtUtils.and((Script)script, ors));
                    ++i;
                }
                Term tempTfTerm = Substitution.apply((ManagedScript)this.mMgdScript, newSubst, (Term)atMostOneStore);
                addendum.add(tempTfTerm);
                Term finalTfTerm = newTfTerm = Substitution.apply((ManagedScript)this.mMgdScript, subst, (Term)SmtUtils.and((Script)script, addendum));
                while (iterate.booleanValue()) {
                    Term iterDnf = SmtUtils.toDnf((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mMgdScript, (Term)scs.transform(newTfTerm), (SmtUtils.XnfConversionTechnique)SmtUtils.XnfConversionTechnique.BOTTOM_UP_WITH_LOCAL_SIMPLIFICATION);
                    StoreSelectEqualityCollector iterSsec = new StoreSelectEqualityCollector();
                    iterSsec.transform(iterDnf);
                    HashMap<Term, Term> iterSubst = new HashMap<Term, Term>();
                    LinkedHashSet<Term> iterAdd = new LinkedHashSet<Term>();
                    for (Term selectTerm : iterSsec.getSelectTerms()) {
                        ApplicationTerm aSelectTerm = (ApplicationTerm)selectTerm;
                        Pair<TermVariable, Term> substTerm2 = MonniauxMapEliminator.eliminateSelects(this.mMgdScript, idxTerms, aSelectTerm, hierarchy, auxVars, subst, idxTermToIdxProgramVar, idxAssignments, hashMap, chain, oldProgramVars, this.mCells, valVars, lowValues, idxAuxVars, valAuxVars, iterImp);
                        iterSubst.put(selectTerm, (Term)substTerm2.getFirst());
                        iterAdd.add((Term)substTerm2.getSecond());
                    }
                    for (IProgramVar key : hashMap.keySet()) {
                        if (!allPrgValVars.contains(key)) continue;
                        iterAdd.add(SmtUtils.binaryEquality((Script)script, (Term)((Term)hashMap.get(key)), (Term)((Term)newOutVars.get(key))));
                    }
                    HashMap disAssgn2 = new HashMap();
                    HashMap<Term, Term> newSubst2 = new HashMap<Term, Term>();
                    Term[] disjuncts2 = SmtUtils.getDisjuncts((Term)iterDnf);
                    int i2 = 0;
                    while (i2 < disjuncts2.length) {
                        Term term = disjuncts2[i2];
                        StoreSelectEqualityCollector newSsec = new StoreSelectEqualityCollector();
                        newSsec.transform(term);
                        HashSet<Term> ors = new HashSet<Term>();
                        HashSet<Term> selectTerms = new HashSet<Term>(newSsec.getSelectTerms());
                        for (Term selectTerm : selectTerms) {
                            ApplicationTerm aSelectTerm = (ApplicationTerm)selectTerm;
                            Term[] paramsTerm = aSelectTerm.getParameters();
                            Term x = paramsTerm[0];
                            Term y = paramsTerm[1];
                            Set idxs = (Set)idxTerms.get(x);
                            if (idxs == null) {
                                idxs = (Set)idxAuxVars.get(x);
                            }
                            for (Term idx : idxs) {
                                HashSet wholeSet = disAssgn2.get(i2) != null ? new HashSet((Collection)disAssgn2.get(i2)) : null;
                                if (wholeSet != null) {
                                    for (Pair pairAssgn : wholeSet) {
                                        Set assgn = (Set)pairAssgn.getSecond();
                                        assgn.add(y);
                                        HashSet<Pair> tempSet = new HashSet<Pair>(wholeSet);
                                        tempSet.add(new Pair((Object)idx, (Object)assgn));
                                        disAssgn2.put(i2, tempSet);
                                        if (auxVars.contains(idx)) continue;
                                        ors.add((Term)((Pair)bools.get(idxTermToIdxProgramVar.get(idx))).getFirst());
                                    }
                                    continue;
                                }
                                HashSet<Term> assgn = new HashSet<Term>();
                                assgn.add(y);
                                HashSet<Pair> tempSet = new HashSet<Pair>();
                                tempSet.add(new Pair((Object)idx, assgn));
                                disAssgn2.put(i2, tempSet);
                                if (auxVars.contains(idx)) continue;
                                ors.add((Term)((Pair)bools.get(idxTermToIdxProgramVar.get(idx))).getFirst());
                            }
                        }
                        if (disAssgn2.get(i2) != null) {
                            for (Pair pair : (Set)disAssgn2.get(i2)) {
                                Set assignments = (Set)pair.getSecond();
                                Term idx = (Term)pair.getFirst();
                                HashSet<Term> equalities = new HashSet<Term>();
                                for (Term assgn : assignments) {
                                    equalities.add(SmtUtils.binaryEquality((Script)script, (Term)idx, (Term)assgn));
                                }
                                IProgramVar idxPrgVar = (IProgramVar)idxTermToIdxProgramVar.get(idx);
                                if (idxPrgVar != null) {
                                    ors.add(SmtUtils.implies((Script)script, (Term)((Term)((Pair)bools.get(idxTermToIdxProgramVar.get(idx))).getFirst()), (Term)SmtUtils.or((Script)script, equalities)));
                                    continue;
                                }
                                ors.add(SmtUtils.or((Script)script, equalities));
                            }
                        }
                        ors.add(term);
                        newSubst2.put(term, SmtUtils.and((Script)script, ors));
                        ++i2;
                    }
                    Term tempTfTerm2 = Substitution.apply((ManagedScript)this.mMgdScript, newSubst2, (Term)iterDnf);
                    iterAdd.add(tempTfTerm2);
                    finalTfTerm = Substitution.apply((ManagedScript)this.mMgdScript, iterSubst, (Term)SmtUtils.and((Script)script, iterAdd));
                    iterate = iterSsec.hasMultDim();
                }
                UnmodifiableTransFormula newTf = this.buildTransitionFormula(tf, finalTfTerm, hashMap, newOutVars, auxVars);
                IcfgLocation oldSource = internalTransition.getSource();
                IcfgLocation newSource = lst.createNewLocation(oldSource);
                IcfgLocation oldTarget = internalTransition.getTarget();
                IcfgLocation newTarget = lst.createNewLocation(oldTarget);
                IcfgInternalTransition newTransition = lst.createNewInternalTransition(newSource, newTarget, newTf, true);
                this.mLogger.info((Object)newSource);
                this.mLogger.info((Object)("In  " + tf.toStringDirect()));
                this.mLogger.info((Object)("Out " + newTf.toStringDirect()));
                this.mLogger.info((Object)newTarget);
                for (IProgramVar dsa : programArrayVars) {
                    for (IProgramVar idxVar : (Set)idxVars.get(dsa)) {
                        if (!idxAssignments.containsKey(idxVar)) continue;
                        idxAssignments.remove(idxVar);
                        HashSet<Term> newCons = new HashSet<Term>();
                        newCons.add((Term)newOutVars.get(idxVar));
                        idxAssignments.put(idxVar, newCons);
                    }
                }
                this.mBacktranslationTracker.mapEdges((IIcfgTransition<IcfgLocation>)newTransition, (IIcfgTransition<IcfgLocation>)internalTransition);
                continue;
            }
            throw new UnsupportedOperationException("Not yet implemented");
        }
    }

    private UnmodifiableTransFormula buildTransitionFormula(UnmodifiableTransFormula oldFormula, Term newTfFormula, Map<IProgramVar, TermVariable> inVars, Map<IProgramVar, TermVariable> outVars, Collection<TermVariable> auxVars) {
        Set nonTheoryConsts = oldFormula.getNonTheoryConsts();
        boolean emptyAuxVars = auxVars.isEmpty();
        Set branchEncoders = oldFormula.getBranchEncoders();
        boolean emptyBranchEncoders = branchEncoders.isEmpty();
        boolean emptyNonTheoryConsts = nonTheoryConsts.isEmpty();
        TransFormulaBuilder tfb = new TransFormulaBuilder(inVars, outVars, emptyNonTheoryConsts, nonTheoryConsts, emptyBranchEncoders, (Collection)branchEncoders, emptyAuxVars);
        tfb.setFormula(newTfFormula);
        tfb.setInfeasibility(UnmodifiableTransFormula.Infeasibility.NOT_DETERMINED);
        auxVars.stream().forEach(arg_0 -> ((TransFormulaBuilder)tfb).addAuxVar(arg_0));
        this.mMgdScript.unlock((Object)this);
        UnmodifiableTransFormula utf = tfb.finishConstruction(this.mMgdScript);
        this.mMgdScript.lock((Object)this);
        return utf;
    }

    private static Pair<TermVariable, Term> eliminateSelects(ManagedScript mMgdScript, Map<Term, Set<Term>> idxTerms, ApplicationTerm selectTerm, Map<Term, List<Term>> hierarchy, Set<TermVariable> auxVars, Map<Term, Term> subst, Map<Term, IProgramVar> idxTermToIdxProgramVar, Map<IProgramVar, Set<Term>> idxAssignments, Map<IProgramVar, TermVariable> newInVars, Map<IProgramVar, Pair<List<Term>, Integer>> chain, Set<IProgramVar> oldProgramVars, int mCells, Map<IProgramVar, List<IProgramVar>> valVars, Map<Term, Term> lowValues, Map<Term, Set<Term>> idxAuxVars, Map<Term, List<Term>> valAuxVars, Map<Term, Term> iterImp) {
        Term substTerm;
        HashSet<Term> tempAssignments;
        HashSet<Term> implications;
        TermVariable placeholder;
        Term[] params = selectTerm.getParameters();
        Term x = subst.containsKey(params[0]) ? subst.get(params[0]) : params[0];
        Term y = subst.containsKey(params[1]) ? subst.get(params[1]) : params[1];
        ArrayList<Object> vals = new ArrayList<Object>();
        ArrayList<Object> idxs = new ArrayList<Object>();
        IProgramVar old = null;
        for (IProgramVar var : oldProgramVars) {
            if (!x.toString().contains(var.toString())) continue;
            old = var;
        }
        if (hierarchy.containsKey(x)) {
            for (Term val : hierarchy.get(x)) {
                vals.add(val);
            }
            for (Term idx : idxTerms.get(x)) {
                idxs.add(idx);
            }
        }
        if (!(hierarchy.containsKey(x) || chain.containsKey(old) || auxVars.contains(x))) {
            int i = 0;
            while (i < mCells) {
                String valName = String.valueOf(old.toString()) + "_val_" + Integer.toString(i) + Integer.toString(0);
                TermVariable varVal = mMgdScript.constructFreshTermVariable(SmtUtils.removeSmtQuoteCharacters((String)valName), valVars.get(old).iterator().next().getSort());
                vals.add(varVal);
                ++i;
            }
            chain.put(old, (Pair<List<Term>, Integer>)new Pair(vals, (Object)0));
            for (Term idx : idxTerms.get(newInVars.get(old))) {
                idxs.add(idx);
            }
        }
        if (chain.containsKey(old)) {
            int length = (Integer)chain.get(old).getValue() + 1;
            int i = 0;
            while (i < mCells) {
                String valName = String.valueOf(old.toString()) + "_val_" + Integer.toString(i) + Integer.toString(length);
                TermVariable varVal = mMgdScript.constructFreshTermVariable(SmtUtils.removeSmtQuoteCharacters((String)valName), valVars.get(old).iterator().next().getSort());
                vals.add(varVal);
                lowValues.put((Term)varVal, (Term)((List)chain.get(old).getFirst()).get(length - 1));
                ++i;
            }
            chain.remove(old);
            chain.put(old, (Pair<List<Term>, Integer>)new Pair(vals, (Object)length));
            for (Term idx : idxTerms.get(newInVars.get(old))) {
                idxs.add(idx);
            }
        }
        if (valAuxVars.containsKey(x)) {
            for (Term val : valAuxVars.get(x)) {
                vals.add(val);
            }
            for (Term idx : idxAuxVars.get(x)) {
                idxs.add(idx);
            }
        }
        Script script = mMgdScript.getScript();
        if (vals.isEmpty() && idxs.isEmpty()) {
            LinkedHashSet<TermVariable> idx2 = new LinkedHashSet<TermVariable>();
            ArrayList<TermVariable> val2 = new ArrayList<TermVariable>();
            int i = 0;
            while (i < mCells) {
                assert (x.getSort().isArraySort());
                assert (x.getSort().getArguments().length == 2) : "Array sort with != 2 arguments";
                if (x.getSort().isArraySort()) {
                    Sort indexSort = y.getSort();
                    Sort sort = x.getSort();
                    String idxName = String.valueOf(x.toString()) + "_iterIdx" + Integer.toString(i);
                    String string = String.valueOf(x.toString()) + "_iterVal" + Integer.toString(i);
                    TermVariable varIdx = mMgdScript.constructFreshTermVariable(SmtUtils.removeSmtQuoteCharacters((String)idxName), indexSort);
                    TermVariable varVal = mMgdScript.constructFreshTermVariable(SmtUtils.removeSmtQuoteCharacters((String)string), sort);
                    idx2.add(varIdx);
                    val2.add(varVal);
                    idxs.add(varIdx);
                    vals.add(varVal);
                    auxVars.add(varVal);
                    auxVars.add(varIdx);
                }
                ++i;
            }
            idxAuxVars.put(x, idx2);
            valAuxVars.put(x, val2);
        }
        if (iterImp.containsKey(x)) {
            Sort sort = x.getSort().getArguments()[1];
            placeholder = mMgdScript.constructFreshTermVariable(SmtUtils.removeSmtQuoteCharacters((String)(String.valueOf(x.toString()) + "_aux")), sort);
            auxVars.add(placeholder);
            implications = new HashSet<Term>();
            for (Term term : vals) {
                for (Term term2 : idxs) {
                    tempAssignments = new HashSet<Term>();
                    if (idxAssignments.containsKey(idxTermToIdxProgramVar.get(term2))) {
                        for (Term asgn : idxAssignments.get(idxTermToIdxProgramVar.get(term2))) {
                            tempAssignments.add(asgn);
                        }
                    }
                    tempAssignments.add(y);
                    idxAssignments.put(idxTermToIdxProgramVar.get(term2), tempAssignments);
                    implications.add(SmtUtils.implies((Script)script, (Term)SmtUtils.and((Script)script, (Term[])new Term[]{SmtUtils.binaryEquality((Script)script, (Term)y, (Term)term2), iterImp.get(x)}), (Term)SmtUtils.binaryEquality((Script)script, (Term)term, (Term)x)));
                    iterImp.put(term, SmtUtils.binaryEquality((Script)script, (Term)y, (Term)term2));
                }
            }
            substTerm = SmtUtils.and((Script)script, implications);
            Pair pair = new Pair((Object)placeholder, (Object)substTerm);
            return pair;
        }
        Sort sort = x.getSort().getArguments()[1];
        placeholder = mMgdScript.constructFreshTermVariable(SmtUtils.removeSmtQuoteCharacters((String)(String.valueOf(x.toString()) + "_aux")), sort);
        auxVars.add(placeholder);
        implications = new HashSet();
        for (Term term : vals) {
            for (Term term3 : idxs) {
                tempAssignments = new HashSet();
                if (idxAssignments.containsKey(idxTermToIdxProgramVar.get(term3))) {
                    for (Term asgn : idxAssignments.get(idxTermToIdxProgramVar.get(term3))) {
                        tempAssignments.add(asgn);
                    }
                }
                tempAssignments.add(y);
                idxAssignments.put(idxTermToIdxProgramVar.get(term3), tempAssignments);
                implications.add(SmtUtils.implies((Script)script, (Term)SmtUtils.binaryEquality((Script)script, (Term)y, (Term)term3), (Term)SmtUtils.binaryEquality((Script)script, (Term)term, (Term)placeholder)));
                iterImp.put((Term)placeholder, SmtUtils.binaryEquality((Script)script, (Term)y, (Term)term3));
            }
        }
        substTerm = SmtUtils.and((Script)script, implications);
        Pair pair = new Pair((Object)placeholder, (Object)substTerm);
        return pair;
    }

    private static Term eliminateStores(ManagedScript mMgdScript, Map<Term, Set<Term>> idxTerms, ApplicationTerm storeTerm, Map<Term, List<Term>> hierarchy, Map<IProgramVar, TermVariable> newInVars, Map<Term, IProgramVar> oldTermToProgramVar, Map<Term, Term> subst, Collection<Term> newAuxVars, Map<Term, IProgramVar> idxTermToIdxProgramVar, Map<IProgramVar, Set<Term>> idxAssignments, Map<IProgramVar, Pair<List<Term>, Integer>> chain, int mCells, Map<IProgramVar, List<IProgramVar>> valVars, Map<Term, Term> lowValues, Set<IProgramVar> oldProgramVars, Map<Term, Set<Term>> idxAuxVars, Map<Term, List<Term>> valAuxVars) {
        Term[] paramsTerm = storeTerm.getParameters();
        Term x = paramsTerm[0];
        Term y = paramsTerm[0];
        Term z = paramsTerm[0];
        int i = 0;
        while (i < paramsTerm.length) {
            Term param = paramsTerm[i];
            if (param instanceof ApplicationTerm) {
                Term[] paramsStore = ((ApplicationTerm)param).getParameters();
                x = paramsStore[0];
                y = paramsStore[1];
                z = paramsStore[2];
            }
            ++i;
        }
        ArrayList<Object> vals = new ArrayList<Object>();
        ArrayList<Term> idxs = new ArrayList<Term>();
        IProgramVar old = null;
        for (IProgramVar var : oldProgramVars) {
            if (!x.toString().contains(var.toString())) continue;
            old = var;
        }
        if (hierarchy.containsKey(x)) {
            for (Term val : hierarchy.get(x)) {
                vals.add(val);
            }
            for (Term idx : idxTerms.get(x)) {
                idxs.add(idx);
            }
        }
        if (!(hierarchy.containsKey(x) || chain.containsKey(old) || valAuxVars.containsKey(x))) {
            int i2 = 0;
            while (i2 < mCells) {
                String valName = String.valueOf(old.toString()) + "_val_" + Integer.toString(i2) + Integer.toString(0);
                TermVariable termVariable = mMgdScript.constructFreshTermVariable(SmtUtils.removeSmtQuoteCharacters((String)valName), valVars.get(old).iterator().next().getSort());
                vals.add(termVariable);
                ++i2;
            }
            chain.put(old, (Pair<List<Term>, Integer>)new Pair(vals, (Object)0));
            for (Term idx : idxTerms.get(newInVars.get(old))) {
                idxs.add(idx);
            }
        }
        if (chain.containsKey(old)) {
            int length = (Integer)chain.get(old).getValue() + 1;
            int i3 = 0;
            while (i3 < mCells) {
                String string = String.valueOf(old.toString()) + "_val_" + Integer.toString(i3) + Integer.toString(length);
                TermVariable varVal = mMgdScript.constructFreshTermVariable(SmtUtils.removeSmtQuoteCharacters((String)string), valVars.get(old).iterator().next().getSort());
                vals.add(varVal);
                lowValues.put((Term)varVal, (Term)((List)chain.get(old).getFirst()).get(length - 1));
                ++i3;
            }
            chain.remove(old);
            chain.put(old, (Pair<List<Term>, Integer>)new Pair(vals, (Object)length));
            for (Term idx : idxTerms.get(newInVars.get(old))) {
                idxs.add(idx);
            }
        }
        if (valAuxVars.containsKey(x)) {
            for (Term val : valAuxVars.get(x)) {
                vals.add(val);
            }
            for (Term idx : idxAuxVars.get(x)) {
                idxs.add(idx);
            }
        }
        Script script = mMgdScript.getScript();
        LinkedHashSet<Term> rtr = new LinkedHashSet<Term>();
        for (Term term : vals) {
            Term valLow = newInVars.containsValue(term) || newAuxVars.contains(x) ? term : (chain.containsKey(old) ? lowValues.get(term) : (Term)newInVars.get(oldTermToProgramVar.get(x)));
            for (Term idx : idxs) {
                HashSet<Term> tempAssignments = new HashSet<Term>();
                if (idxAssignments.containsKey(idxTermToIdxProgramVar.get(idx))) {
                    for (Term asgn : idxAssignments.get(idxTermToIdxProgramVar.get(idx))) {
                        tempAssignments.add(asgn);
                    }
                }
                tempAssignments.add(y);
                idxAssignments.put(idxTermToIdxProgramVar.get(idx), tempAssignments);
                rtr.add(SmtUtils.implies((Script)script, (Term)SmtUtils.binaryEquality((Script)script, (Term)y, (Term)idx), (Term)SmtUtils.binaryEquality((Script)script, (Term)term, (Term)z)));
                rtr.add(SmtUtils.implies((Script)script, (Term)SmtUtils.distinct((Script)script, (Term)idx, (Term)y), (Term)SmtUtils.binaryEquality((Script)script, (Term)term, (Term)valLow)));
            }
        }
        return SmtUtils.and((Script)script, rtr);
    }

    private static Term eliminateEqualities(ManagedScript mMgdScript, Map<Term, Set<Term>> idxTerms, ApplicationTerm equalityTerm, Map<Term, List<Term>> hierarchy, Map<Term, Term> subst) {
        Term[] params = equalityTerm.getParameters();
        if (!(params[0] instanceof TermVariable)) {
            return equalityTerm;
        }
        if (!(params[1] instanceof TermVariable)) {
            return equalityTerm;
        }
        if (subst.containsKey(params[0])) {
            subst.get(params[0]);
        } else {
            Term cfr_ignored_0 = params[0];
        }
        if (subst.containsKey(params[1])) {
            subst.get(params[1]);
        } else {
            Term cfr_ignored_1 = params[1];
        }
        Script script = mMgdScript.getScript();
        LinkedHashSet<Term> rtr = new LinkedHashSet<Term>();
        List<Term> xvals = hierarchy.get(params[0]);
        for (Term xval : xvals) {
            Set<Term> xidxs = idxTerms.get(params[0]);
            for (Term xidx : xidxs) {
                for (Term yval : hierarchy.get(params[1])) {
                    for (Term yidx : idxTerms.get(params[1])) {
                        rtr.add(SmtUtils.implies((Script)script, (Term)SmtUtils.binaryEquality((Script)script, (Term)xidx, (Term)yidx), (Term)SmtUtils.binaryEquality((Script)script, (Term)xval, (Term)yval)));
                    }
                }
            }
        }
        return SmtUtils.and((Script)script, rtr);
    }
}

