/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.mapelim.monniaux;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import java.util.HashSet;
import java.util.Set;

public final class StoreSelectEqualityCollector
extends TermTransformer {
    private final Set<Term> mStoreTerms = new HashSet<Term>();
    private final Set<Term> mSelectTerms = new HashSet<Term>();
    private final Set<Term> mEqualityTerms = new HashSet<Term>();
    private boolean mMultDim = false;

    protected void convert(Term term) {
        if (term instanceof ApplicationTerm) {
            ApplicationTerm aterm = (ApplicationTerm)term;
            String funName = aterm.getFunction().getName();
            if (funName.equals("=")) {
                if (!this.checkAndAddIfParamIsStoreTerm(aterm) && aterm.getParameters()[0].getSort().isArraySort() && aterm.getParameters()[1].getSort().isArraySort()) {
                    this.mEqualityTerms.add(term);
                }
            } else if (funName.equals("select")) {
                boolean localMult = false;
                Term[] params = aterm.getParameters();
                int i = 0;
                while (i < params.length) {
                    if (params[i] instanceof ApplicationTerm) {
                        this.mMultDim = true;
                        localMult = true;
                    }
                    ++i;
                }
                if (!localMult) {
                    this.mSelectTerms.add((Term)aterm);
                }
            } else {
                this.checkAndAddIfParamIsStoreTerm(aterm);
            }
        }
        super.convert(term);
    }

    private boolean checkAndAddIfParamIsStoreTerm(ApplicationTerm aterm) {
        Term[] params = aterm.getParameters();
        int i = 0;
        while (i < params.length) {
            ApplicationTerm appParam;
            Term param = params[i];
            if (param instanceof ApplicationTerm && StoreSelectEqualityCollector.isStore(appParam = (ApplicationTerm)param)) {
                this.mStoreTerms.add((Term)aterm);
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isStore(ApplicationTerm param) {
        return "store".equals(param.getFunction().getName());
    }

    protected boolean isEmpty() {
        return this.mSelectTerms.isEmpty() && this.mStoreTerms.isEmpty() && this.mEqualityTerms.isEmpty();
    }

    protected boolean hasNoStoEqu() {
        return this.mStoreTerms.isEmpty() && this.mEqualityTerms.isEmpty();
    }

    public boolean hasMultDim() {
        return this.mMultDim;
    }

    public String toString() {
        return "Store " + this.mStoreTerms + " Select " + this.mSelectTerms + " Equals " + this.mEqualityTerms;
    }

    public Set<Term> getStoreTerms() {
        return this.mStoreTerms;
    }

    public Set<Term> getSelectTerms() {
        return this.mSelectTerms;
    }

    public Set<Term> getEqualityTerms() {
        return this.mEqualityTerms;
    }
}

