/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TermException;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TransitionPreprocessor;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.SmtFunctionsAndAxioms;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.ReplacementVarFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class AddSymbols
extends TransitionPreprocessor {
    public static final String DESCRIPTION = "Add axioms to the transition";
    private final Term[] mAxioms;
    private final Set<ApplicationTerm> mConstants = new HashSet<ApplicationTerm>();
    private final ReplacementVarFactory mReplacementVarFactory;

    public AddSymbols(ReplacementVarFactory replacementVarFactory, SmtFunctionsAndAxioms smtSymbols) {
        this.mReplacementVarFactory = replacementVarFactory;
        Term axioms = smtSymbols.getAxioms().getFormula();
        Term[] termArray = this.mAxioms = SmtUtils.getConjuncts((Term)axioms);
        int n = this.mAxioms.length;
        int n2 = 0;
        while (n2 < n) {
            Term axiom = termArray[n2];
            this.mConstants.addAll(SmtUtils.extractConstants((Term)axiom, (boolean)false));
            ++n2;
        }
    }

    @Override
    public ModifiableTransFormula process(ManagedScript script, ModifiableTransFormula tf) throws TermException {
        HashMap<ApplicationTerm, TermVariable> substitutionMapping = new HashMap<ApplicationTerm, TermVariable>();
        for (ApplicationTerm constVar : this.mConstants) {
            IProgramVar repVar = (IProgramVar)this.mReplacementVarFactory.getOrConstuctReplacementVar((Term)constVar, true);
            tf.addInVar(repVar, repVar.getTermVariable());
            tf.addOutVar(repVar, repVar.getTermVariable());
            substitutionMapping.put(constVar, repVar.getTermVariable());
        }
        Term axioms = Substitution.apply((ManagedScript)script, substitutionMapping, (Term)SmtUtils.and((Script)script.getScript(), (Term[])this.mAxioms));
        Term formula = tf.getFormula();
        formula = SmtUtils.and((Script)script.getScript(), (Term[])new Term[]{formula, axioms});
        tf.setFormula(formula);
        return tf;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }
}

