/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TermException;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TransitionPreprocessor;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.IReplacementVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.ReplacementVarFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.bvinttranslation.TranslationConstrainer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.bvinttranslation.TranslationManager;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Set;

public class BvToIntTransformation
extends TransitionPreprocessor {
    public static final String DESCRIPTION = "Translate Bitvectors to Integer Formulas";
    private final IUltimateServiceProvider mServices;
    private final ReplacementVarFactory mFac;
    final LinkedHashMap<Term, Term> mBacktranslationMap = new LinkedHashMap();

    public BvToIntTransformation(IUltimateServiceProvider services, ReplacementVarFactory fac, ManagedScript mgdScript) {
        this.mFac = fac;
        this.mServices = services;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public ModifiableTransFormula process(ManagedScript mgdScript, ModifiableTransFormula tf) throws TermException {
        if (!tf.getNonTheoryConsts().isEmpty()) {
            throw new UnsupportedOperationException("Non-theory constants: " + tf.getNonTheoryConsts());
        }
        ModifiableTransFormula newIntTF = new ModifiableTransFormula(tf);
        LinkedHashMap<Object, TermVariable> varMap = new LinkedHashMap<Object, TermVariable>();
        for (IProgramVar progVar : ModifiableTransFormula.collectAllProgramVars((TransFormula)tf)) {
            TermVariable intOutVar;
            TermVariable intInVar;
            IReplacementVarOrConst repVar = this.mFac.getOrConstuctReplacementVar((Term)progVar.getTermVariable(), true, BvToIntTransformation.bvToIntSort(mgdScript, progVar.getTerm().getSort()));
            this.mBacktranslationMap.put((Term)((IProgramVar)repVar).getTermVariable(), (Term)progVar.getTermVariable());
            if (tf.getInVars().get(progVar) != null && tf.getOutVars().get(progVar) != null) {
                if (((TermVariable)tf.getInVars().get(progVar)).equals(tf.getOutVars().get(progVar))) {
                    TermVariable intInAndOutVar;
                    intInVar = intInAndOutVar = mgdScript.constructFreshTermVariable("intInAndOutVar", BvToIntTransformation.bvToIntSort(mgdScript, ((TermVariable)tf.getInVars().get(progVar)).getSort()));
                    intOutVar = intInAndOutVar;
                } else {
                    intInVar = mgdScript.constructFreshTermVariable("intInVar", BvToIntTransformation.bvToIntSort(mgdScript, ((TermVariable)tf.getInVars().get(progVar)).getSort()));
                    intOutVar = mgdScript.constructFreshTermVariable("intOutVar", BvToIntTransformation.bvToIntSort(mgdScript, ((TermVariable)tf.getOutVars().get(progVar)).getSort()));
                }
                varMap.put((Term)tf.getInVars().get(progVar), intInVar);
                newIntTF.addInVar((IProgramVar)repVar, intInVar);
                varMap.put((Term)tf.getOutVars().get(progVar), intOutVar);
                newIntTF.addOutVar((IProgramVar)repVar, intOutVar);
                continue;
            }
            if (tf.getInVars().get(progVar) != null) {
                intInVar = mgdScript.constructFreshTermVariable("intInVar", BvToIntTransformation.bvToIntSort(mgdScript, ((TermVariable)tf.getInVars().get(progVar)).getSort()));
                newIntTF.addInVar((IProgramVar)repVar, intInVar);
                varMap.put((Term)tf.getInVars().get(progVar), intInVar);
            }
            if (tf.getOutVars().get(progVar) == null) continue;
            intOutVar = mgdScript.constructFreshTermVariable("intOutVar", BvToIntTransformation.bvToIntSort(mgdScript, ((TermVariable)tf.getOutVars().get(progVar)).getSort()));
            newIntTF.addOutVar((IProgramVar)repVar, intOutVar);
            varMap.put((Term)tf.getOutVars().get(progVar), intOutVar);
        }
        for (TermVariable auxVar : tf.getAuxVars()) {
            TermVariable newAuxVar = mgdScript.constructFreshTermVariable(auxVar.getName(), BvToIntTransformation.bvToIntSort(mgdScript, auxVar.getSort()));
            varMap.put(auxVar, newAuxVar);
            newIntTF.addAuxVars(Collections.singleton(newAuxVar));
        }
        TranslationManager mTranslationManager = new TranslationManager(mgdScript, TranslationConstrainer.ConstraintsForBitwiseOperations.SUM);
        mTranslationManager.setReplacementVarMaps(varMap);
        Triple translated = mTranslationManager.translateBvtoInt(tf.getFormula());
        if (!((Set)translated.getSecond()).isEmpty() || ((Boolean)translated.getThird()).booleanValue()) {
            throw new UnsupportedOperationException();
        }
        newIntTF.setFormula((Term)translated.getFirst());
        return newIntTF;
    }

    public static Sort bvToIntSort(ManagedScript mgdScript, Sort sort) {
        if (SmtSortUtils.isBitvecSort((Sort)sort)) {
            return SmtSortUtils.getIntSort((ManagedScript)mgdScript);
        }
        if (SmtSortUtils.isArraySort((Sort)sort)) {
            Sort[] newArgs = new Sort[sort.getArguments().length];
            int i = 0;
            while (i < sort.getArguments().length) {
                newArgs[i] = BvToIntTransformation.bvToIntSort(mgdScript, sort.getArguments()[i]);
                ++i;
            }
            assert (newArgs.length == 2);
            Sort domainSort = newArgs[0];
            Sort rangeSort = newArgs[1];
            return SmtSortUtils.getArraySort((Script)mgdScript.getScript(), (Sort)domainSort, (Sort)rangeSort);
        }
        if (SmtSortUtils.isBoolSort((Sort)sort)) {
            return sort;
        }
        return sort;
    }

    @Override
    public boolean checkSoundness(Script script, ModifiableTransFormula oldTF, ModifiableTransFormula newTF) {
        return true;
    }

    public LinkedHashMap<Term, Term> getBacktranslationOfVariables() {
        return this.mBacktranslationMap;
    }
}

