/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TermException;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TransitionPreprocessor;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.CommuhashNormalForm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import java.math.BigDecimal;
import java.math.BigInteger;

public class CommuHashPreprocessor
extends TransitionPreprocessor {
    private final IUltimateServiceProvider mServices;
    public static final String DESCRIPTION = "Simplify formula using CommuhashNormalForm";

    public CommuHashPreprocessor(IUltimateServiceProvider services) {
        this.mServices = services;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public boolean checkSoundness(Script script, ModifiableTransFormula oldTF, ModifiableTransFormula newTF) {
        return true;
    }

    @Override
    public ModifiableTransFormula process(ManagedScript script, ModifiableTransFormula tf) throws TermException {
        Term normalized1 = new ConstantTermNormalizer2().transform(tf.getFormula());
        Term normalized2 = new CommuhashNormalForm(this.mServices, script.getScript()).transform(normalized1);
        tf.setFormula(normalized2);
        return tf;
    }

    public static class ConstantTermNormalizer2
    extends TermTransformer {
        protected void convert(Term term) {
            if (term instanceof ConstantTerm) {
                ConstantTerm ct = (ConstantTerm)term;
                if (ct.getValue() instanceof BigInteger) {
                    Rational rat = Rational.valueOf((BigInteger)((BigInteger)ct.getValue()), (BigInteger)BigInteger.ONE);
                    this.setResult(rat.toTerm(term.getSort()));
                } else if (ct.getValue() instanceof BigDecimal) {
                    Rational rat;
                    BigDecimal decimal = (BigDecimal)ct.getValue();
                    if (decimal.scale() <= 0) {
                        BigInteger num = decimal.toBigInteger();
                        rat = Rational.valueOf((BigInteger)num, (BigInteger)BigInteger.ONE);
                    } else {
                        BigInteger num = decimal.unscaledValue();
                        BigInteger denom = BigInteger.TEN.pow(decimal.scale());
                        rat = Rational.valueOf((BigInteger)num, (BigInteger)denom);
                    }
                    this.setResult(rat.toTerm(term.getSort()));
                } else if (ct.getValue() instanceof Rational) {
                    this.setResult((Term)ct);
                } else {
                    this.setResult(term);
                }
            } else {
                super.convert(term);
            }
        }
    }
}

