/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TermException;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TransitionPreprocessor;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.Map;

public class MatchInOutVars
extends TransitionPreprocessor {
    public static final String DESCRIPTION = "Add a corresponding inVars and outVars";

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public ModifiableTransFormula process(ManagedScript script, ModifiableTransFormula tf) throws TermException {
        this.addMissingInVars(script, tf);
        this.addMissingOutVars(script, tf);
        return tf;
    }

    private void addMissingInVars(ManagedScript script, ModifiableTransFormula tf) {
        for (Map.Entry entry : tf.getOutVars().entrySet()) {
            if (tf.getInVars().containsKey(entry.getKey())) continue;
            String id = SmtUtils.removeSmtQuoteCharacters((String)((IProgramVar)entry.getKey()).getGloballyUniqueId());
            TermVariable inVar = script.constructFreshTermVariable(id, ((TermVariable)entry.getValue()).getSort());
            tf.addInVar((IProgramVar)entry.getKey(), inVar);
        }
    }

    private void addMissingOutVars(ManagedScript script, ModifiableTransFormula tf) {
        for (Map.Entry entry : tf.getInVars().entrySet()) {
            if (tf.getOutVars().containsKey(entry.getKey())) continue;
            String id = SmtUtils.removeSmtQuoteCharacters((String)((IProgramVar)entry.getKey()).getGloballyUniqueId());
            TermVariable inVar = script.constructFreshTermVariable(id, ((TermVariable)entry.getValue()).getSort());
            tf.addOutVar((IProgramVar)entry.getKey(), inVar);
        }
    }

    private static boolean eachInVarHasOutVar(ModifiableTransFormula tf) {
        for (Map.Entry entry : tf.getInVars().entrySet()) {
            if (tf.getOutVars().containsKey(entry.getKey())) continue;
            assert (false) : "no outVar for inVar " + entry.getKey();
            return false;
        }
        return true;
    }
}

