/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers;

import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TermException;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TransitionPreprocessor;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ApplicationTermFinder;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.DagSizePrinter;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Util;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class ModuloNeighborTransformation
extends TransitionPreprocessor {
    public static final String DESCRIPTION = "Replace modulo operation by disjunction if divisor is a literal";
    private static final boolean CHECK_RESULT = true;
    private static final String MODULO_REPLACEMENT = "mod2";
    private final IUltimateServiceProvider mServices;
    private static final boolean APPLY_ONLY_TO_TYPICAL_WRAPAROUD_CONSTANTS = true;
    private static final BigInteger BITLENGTH8_VALUE = BigInteger.valueOf(256L);
    private static final BigInteger BITLENGTH16_VALUE = BigInteger.valueOf(65536L);
    private static final BigInteger BITLENGTH32_VALUE = BigInteger.valueOf(0x100000000L);
    private static final BigInteger BITLENGTH64_VALUE = new BigInteger("9223372036854775808");
    private static final BigInteger BITLENGTH128_VALUE = new BigInteger("340282366920938463463374607431768211456");

    public ModuloNeighborTransformation(IUltimateServiceProvider services, boolean useNeighbors) {
        this.mServices = services;
        if (!useNeighbors) {
            throw new UnsupportedOperationException("not yet implemented");
        }
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public ModifiableTransFormula process(ManagedScript mgdScript, ModifiableTransFormula tf) throws TermException {
        Term newFormula = this.constructTerm(mgdScript, tf.getFormula());
        ModifiableTransFormula result = new ModifiableTransFormula(tf);
        result.setFormula(newFormula);
        return result;
    }

    @Override
    public boolean checkSoundness(Script script, ModifiableTransFormula oldTF, ModifiableTransFormula newTF) {
        return !this.isIncorrect(script, oldTF.getFormula(), newTF.getFormula());
    }

    private boolean isIncorrect(Script script, Term input, Term result) {
        return Script.LBool.SAT == Util.checkSat((Script)script, (Term)script.term("distinct", new Term[]{input, result}));
    }

    private Term constructInRangeBounds(Script script, Term dividend, Term divisor) {
        Term geqZero = script.term("<=", new Term[]{SmtUtils.constructIntValue((Script)script, (BigInteger)BigInteger.ZERO), dividend});
        Term ltDivisor = script.term("<", new Term[]{dividend, divisor});
        return script.term("and", new Term[]{geqZero, ltDivisor});
    }

    private Term constructInRangeResult(Term dividend) {
        return dividend;
    }

    private Term constructLeftIntervalBounds(Script script, Term dividend, Term divisor) {
        Term geqLeftBound = script.term("<=", new Term[]{script.term("-", new Term[]{divisor}), dividend});
        Term ltZero = script.term("<", new Term[]{dividend, SmtUtils.constructIntValue((Script)script, (BigInteger)BigInteger.ZERO)});
        return script.term("and", new Term[]{geqLeftBound, ltZero});
    }

    private Term constructLeftIntervalResult(Script script, Term dividend, Term divisor) {
        return script.term("+", new Term[]{dividend, divisor});
    }

    private Term constructRightIntervalBounds(Script script, Term dividend, Term divisor) {
        Term geqLeftBound = script.term("<=", new Term[]{divisor, dividend});
        Term lgtRightBound = script.term("<", new Term[]{dividend, script.term("+", new Term[]{divisor, divisor})});
        return script.term("and", new Term[]{geqLeftBound, lgtRightBound});
    }

    private Term constructRightIntervalResult(Script script, Term dividend, Term divisor) {
        return script.term("-", new Term[]{dividend, divisor});
    }

    private Term constructNoNeighborIntervalBounds(Script script, Term dividend, Term divisor) {
        Term lgtleftBoundofLeftInterval = script.term("<", new Term[]{dividend, script.term("-", new Term[]{divisor})});
        Term gtRightBoundofRightInterval = script.term("<=", new Term[]{script.term("+", new Term[]{divisor, divisor}), dividend});
        return script.term("or", new Term[]{lgtleftBoundofLeftInterval, gtRightBoundofRightInterval});
    }

    private Term constructNoNeighborIntervalResult(Script script, Term dividend, Term divisor) {
        return script.term(MODULO_REPLACEMENT, new Term[]{dividend, divisor});
    }

    private Term constructTerm(ManagedScript mgdScript, Term term) {
        Set auxModTerms;
        Term divisor;
        Term dividend;
        Set modTerms;
        mgdScript.lock((Object)this);
        mgdScript.push((Object)this, 1);
        Sort intSort = SmtSortUtils.getIntSort((ManagedScript)mgdScript);
        mgdScript.declareFun((Object)this, MODULO_REPLACEMENT, new Sort[]{intSort, intSort}, intSort);
        while (!(modTerms = new ApplicationTermFinder(Collections.singleton("mod"), false).findMatchingSubterms(term)).isEmpty()) {
            if (!this.mServices.getProgressMonitorService().continueProcessing()) {
                throw new ToolchainCanceledException(this.getClass(), "removing " + modTerms.size() + " modulo operations from term of size " + new DagSizePrinter(term).toString());
            }
            ApplicationTerm someModuloTermWithConstantDivisor = null;
            dividend = null;
            divisor = null;
            for (ApplicationTerm modTerm : modTerms) {
                assert (modTerm.getParameters().length == 2);
                dividend = modTerm.getParameters()[0];
                divisor = modTerm.getParameters()[1];
                if (divisor instanceof ConstantTerm && this.isWraparoundConstant((ConstantTerm)divisor)) {
                    someModuloTermWithConstantDivisor = modTerm;
                    break;
                }
                dividend = null;
                divisor = null;
            }
            if (someModuloTermWithConstantDivisor == null) break;
            Script script = mgdScript.getScript();
            ArrayList<Term> cases = new ArrayList<Term>();
            Map<Object, Term> substitutionMapping = Collections.singletonMap(someModuloTermWithConstantDivisor, this.constructInRangeResult(dividend));
            Term case1 = SmtUtils.and((Script)script, (Term[])new Term[]{this.constructInRangeBounds(script, dividend, divisor), Substitution.apply((ManagedScript)mgdScript, substitutionMapping, (Term)term)});
            cases.add(case1);
            substitutionMapping = Collections.singletonMap(someModuloTermWithConstantDivisor, this.constructLeftIntervalResult(script, dividend, divisor));
            Term case2 = SmtUtils.and((Script)script, (Term[])new Term[]{this.constructLeftIntervalBounds(script, dividend, divisor), Substitution.apply((ManagedScript)mgdScript, substitutionMapping, (Term)term)});
            cases.add(case2);
            substitutionMapping = Collections.singletonMap(someModuloTermWithConstantDivisor, this.constructRightIntervalResult(script, dividend, divisor));
            Term case3 = SmtUtils.and((Script)script, (Term[])new Term[]{this.constructRightIntervalBounds(script, dividend, divisor), Substitution.apply((ManagedScript)mgdScript, substitutionMapping, (Term)term)});
            cases.add(case3);
            substitutionMapping = Collections.singletonMap(someModuloTermWithConstantDivisor, this.constructNoNeighborIntervalResult(script, dividend, divisor));
            Term case4 = SmtUtils.and((Script)script, (Term[])new Term[]{this.constructNoNeighborIntervalBounds(script, dividend, divisor), Substitution.apply((ManagedScript)mgdScript, substitutionMapping, (Term)term)});
            cases.add(case4);
            term = SmtUtils.or((Script)script, cases);
        }
        term = SmtUtils.simplify((ManagedScript)mgdScript, (Term)term, (IUltimateServiceProvider)this.mServices, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA);
        while (!(auxModTerms = new ApplicationTermFinder(Collections.singleton(MODULO_REPLACEMENT), false).findMatchingSubterms(term)).isEmpty()) {
            ApplicationTerm modTerm;
            ApplicationTerm auxModTerm = (ApplicationTerm)auxModTerms.iterator().next();
            assert (auxModTerm.getFunction().getName().equals(MODULO_REPLACEMENT)) : "wrong function";
            assert (auxModTerm.getParameters().length == 2);
            dividend = auxModTerm.getParameters()[0];
            divisor = auxModTerm.getParameters()[1];
            modTerm = mgdScript.getScript().term("mod", new Term[]{dividend, divisor});
            Map<ApplicationTerm, ApplicationTerm> substitutionMapping = Collections.singletonMap(auxModTerm, modTerm);
            term = Substitution.apply((ManagedScript)mgdScript, substitutionMapping, (Term)term);
        }
        mgdScript.pop((Object)this, 1);
        mgdScript.unlock((Object)this);
        return term;
    }

    private boolean isWraparoundConstant(ConstantTerm constant) {
        Object value = constant.getValue();
        if (value instanceof Rational) {
            return this.isWraparoudBigInteger(((Rational)value).numerator());
        }
        if (value instanceof BigInteger) {
            return this.isWraparoudBigInteger((BigInteger)value);
        }
        throw new UnsupportedOperationException("value has type " + value.getClass().getSimpleName());
    }

    private boolean isWraparoudBigInteger(BigInteger bigInt) {
        return bigInt.equals(BITLENGTH8_VALUE) || bigInt.equals(BITLENGTH16_VALUE) || bigInt.equals(BITLENGTH32_VALUE) || bigInt.equals(BITLENGTH64_VALUE) || bigInt.equals(BITLENGTH128_VALUE);
    }
}

