/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TransformerPreprocessor;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.Util;

public class RemoveNegation
extends TransformerPreprocessor {
    public static final String DESCRIPTION = "Remove negation before atoms";

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public boolean checkSoundness(Script script, ModifiableTransFormula oldTF, ModifiableTransFormula newTF) {
        Term oldTerm = oldTF.getFormula();
        Term newTerm = newTF.getFormula();
        return Script.LBool.SAT != Util.checkSat((Script)script, (Term)script.term("distinct", new Term[]{oldTerm, newTerm}));
    }

    @Override
    protected TermTransformer getTransformer(ManagedScript script) {
        return new RemoveNegationTransformer(script.getScript());
    }

    private static final class RemoveNegationTransformer
    extends TermTransformer {
        private final Script mScript;

        RemoveNegationTransformer(Script script) {
            assert (script != null);
            this.mScript = script;
        }

        protected void convert(Term term) {
            if (!(term instanceof ApplicationTerm)) {
                super.convert(term);
                return;
            }
            ApplicationTerm appt = (ApplicationTerm)term;
            if (!"not".equals(appt.getFunction().getName())) {
                super.convert(term);
                return;
            }
            assert (appt.getParameters().length == 1);
            Term param = appt.getParameters()[0];
            if (!(param instanceof ApplicationTerm)) {
                super.convert(term);
                return;
            }
            ApplicationTerm appt2 = (ApplicationTerm)param;
            String funName = appt2.getFunction().getName();
            if ("<=".equals(funName)) {
                this.setResult(this.mScript.term(">", appt2.getParameters()));
            } else if ("<".equals(funName)) {
                this.setResult(this.mScript.term(">=", appt2.getParameters()));
            } else if (">=".equals(funName)) {
                this.setResult(this.mScript.term("<", appt2.getParameters()));
            } else if (">".equals(funName)) {
                this.setResult(this.mScript.term("<=", appt2.getParameters()));
            } else {
                this.setResult(term);
            }
        }
    }
}

