/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.RewriteTermVariables;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.ReplacementVarFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.ReplacementVarUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.math.BigInteger;

public class RewriteBooleans
extends RewriteTermVariables {
    public static final String DESCRIPTION = "Replace boolean variables by integer variables";
    private static final String TERM_VARIABLE_SUFFIX = "bool";
    private static final String REP_VAR_SORT_NAME = "Int";

    @Override
    protected String getTermVariableSuffix() {
        return TERM_VARIABLE_SUFFIX;
    }

    @Override
    protected String getRepVarSortName() {
        return REP_VAR_SORT_NAME;
    }

    public RewriteBooleans(ReplacementVarFactory varFactory, ManagedScript script) {
        super(varFactory, script);
    }

    @Override
    protected boolean hasToBeReplaced(Term term) {
        return RewriteBooleans.isBool(term);
    }

    private static final boolean isBool(Term term) {
        return SmtSortUtils.isBoolSort((Sort)term.getSort());
    }

    @Override
    protected Term constructReplacementTerm(TermVariable tv) {
        Term one = SmtUtils.constructIntValue((Script)this.mScript.getScript(), (BigInteger)BigInteger.ONE);
        Term repTerm = this.mScript.getScript().term(">=", new Term[]{tv, one});
        return repTerm;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    protected Term constructNewDefinitionForRankVar(IProgramVar oldRankVar) {
        Term booleanTerm = ReplacementVarUtils.getDefinition((IProgramVar)oldRankVar);
        assert (RewriteBooleans.isBool(booleanTerm));
        Term one = SmtUtils.constructIntValue((Script)this.mScript.getScript(), (BigInteger)BigInteger.ONE);
        Term zero = SmtUtils.constructIntValue((Script)this.mScript.getScript(), (BigInteger)BigInteger.ZERO);
        return this.mScript.getScript().term("ite", new Term[]{booleanTerm, one, zero});
    }
}

