/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TransformerPreprocessor;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.Util;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class RewriteDisequality
extends TransformerPreprocessor {
    public static final String DESCRIPTION = "Replaces a != b with (a > b \\/ a < b)";

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public boolean checkSoundness(Script script, ModifiableTransFormula oldTF, ModifiableTransFormula newTF) {
        Term oldTerm = oldTF.getFormula();
        Term newTerm = newTF.getFormula();
        return Script.LBool.SAT != Util.checkSat((Script)script, (Term)script.term("distinct", new Term[]{oldTerm, newTerm}));
    }

    @Override
    protected TermTransformer getTransformer(ManagedScript script) {
        return new RewriteDisequalityTransformer(script.getScript());
    }

    private static final class RewriteDisequalityTransformer
    extends TermTransformer {
        private static final Set<String> SUPPORTED_SORTS = new HashSet<String>(Arrays.asList("Int", "Real"));
        private final Script mScript;

        RewriteDisequalityTransformer(Script script) {
            assert (script != null);
            this.mScript = script;
        }

        protected void convert(Term term) {
            if (!(term instanceof ApplicationTerm)) {
                super.convert(term);
                return;
            }
            ApplicationTerm appt = (ApplicationTerm)term;
            String funName = appt.getFunction().getName();
            Term[] params = null;
            if ("not".equals(funName)) {
                ApplicationTerm subApp;
                Term sub = appt.getParameters()[0];
                assert (appt.getParameters().length == 1) : "not with more than one parameter not supported";
                if (sub instanceof ApplicationTerm && "=".equals((subApp = (ApplicationTerm)sub).getFunction().getName())) {
                    params = subApp.getParameters();
                }
            } else if ("distinct".equals(funName)) {
                params = appt.getParameters();
            }
            if (params == null) {
                super.convert(term);
                return;
            }
            String paramSortName = params[0].getSort().getName();
            if (!SUPPORTED_SORTS.contains(paramSortName)) {
                this.setResult(term);
                return;
            }
            assert (params.length == 2) : "distinct / equals with more than two parameters not yet supported";
            Term param1 = this.mScript.term("<", params);
            Term param2 = this.mScript.term(">", params);
            this.setResult(this.mScript.term("or", new Term[]{param1, param2}));
        }
    }
}

