/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TermException;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TransformerPreprocessor;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.ReplacementVarFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Util;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class RewriteDivision
extends TransformerPreprocessor {
    public static final String DESCRIPTION = "Replace integer division by equivalent linear constraints";
    private static final String DIV_AUX_PREFIX = "div_aux";
    private static final String MOD_AUX_PREFIX = "mod_aux";
    private static final boolean CHECK_RESULT = true;
    private static final boolean CHECK_RESULT_WITH_QUAMTIFIERS = false;
    private final Map<TermVariable, Term> mAuxVars;
    private final ReplacementVarFactory mVarFactory;
    private final Collection<Term> mAuxTerms;

    public RewriteDivision(ReplacementVarFactory varFactory) {
        this.mVarFactory = varFactory;
        this.mAuxVars = new LinkedHashMap<TermVariable, Term>();
        this.mAuxTerms = new ArrayList<Term>();
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public ModifiableTransFormula process(ManagedScript script, ModifiableTransFormula tf) throws TermException {
        this.mAuxVars.clear();
        this.mAuxTerms.clear();
        ModifiableTransFormula new_tf = super.process(script, tf);
        Term formula = new_tf.getFormula();
        Term auxTerms = SmtUtils.and((Script)script.getScript(), (Term[])this.mAuxTerms.toArray(new Term[this.mAuxTerms.size()]));
        new_tf.setFormula(SmtUtils.and((Script)script.getScript(), (Term[])new Term[]{formula, auxTerms}));
        new_tf.addAuxVars(this.mAuxVars.keySet());
        return new_tf;
    }

    @Override
    public boolean checkSoundness(Script script, ModifiableTransFormula oldTF, ModifiableTransFormula newTF) {
        Term new_term;
        Term old_term = oldTF.getFormula();
        Term old_termwith_def = SmtUtils.and((Script)script, (Term[])new Term[]{old_term, SmtUtils.and((Script)script, (Term[])this.mAuxTerms.toArray(new Term[this.mAuxTerms.size()]))});
        boolean fail1 = this.isIncorrect(script, old_termwith_def, new_term = newTF.getFormula());
        boolean fail2 = false;
        return !fail1 && !fail2;
    }

    private boolean isIncorrect(Script script, Term input, Term result) {
        return Script.LBool.SAT == Util.checkSat((Script)script, (Term)script.term("distinct", new Term[]{input, result}));
    }

    private boolean isIncorrectWithQuantifiers(Script script, Term input, Term result) {
        Term quantified = !this.mAuxVars.isEmpty() ? script.quantifier(0, this.mAuxVars.keySet().toArray(new TermVariable[this.mAuxVars.size()]), result, (Term[][])new Term[0][]) : script.term("true", new Term[0]);
        return Util.checkSat((Script)script, (Term)script.term("distinct", new Term[]{input, quantified})) == Script.LBool.SAT;
    }

    @Override
    protected TermTransformer getTransformer(ManagedScript script) {
        return new RewriteDivisionTransformer(script.getScript());
    }

    private class RewriteDivisionTransformer
    extends TermTransformer {
        private final Script mScript;

        RewriteDivisionTransformer(Script script) {
            assert (script != null);
            this.mScript = script;
        }

        public void convertApplicationTerm(ApplicationTerm appTerm, Term[] newArgs) {
            String func = appTerm.getFunction().getName();
            if (func.equals("div")) {
                assert (appTerm.getParameters().length == 2);
                Term dividend = newArgs[0];
                Term divisor = newArgs[1];
                TermVariable quotientAuxVar = RewriteDivision.this.mVarFactory.getOrConstructAuxVar(RewriteDivision.DIV_AUX_PREFIX + dividend.toString() + divisor.toString(), appTerm.getSort());
                RewriteDivision.this.mAuxVars.put(quotientAuxVar, (Term)appTerm);
                Term divAuxTerm = this.computeDivAuxTerms(dividend, divisor, quotientAuxVar);
                RewriteDivision.this.mAuxTerms.add(divAuxTerm);
                this.setResult((Term)quotientAuxVar);
                return;
            }
            if (func.equals("mod")) {
                assert (appTerm.getParameters().length == 2);
                Term dividend = newArgs[0];
                Term divisor = newArgs[1];
                TermVariable quotientAuxVar = RewriteDivision.this.mVarFactory.getOrConstructAuxVar(RewriteDivision.DIV_AUX_PREFIX + dividend.toString() + divisor.toString(), appTerm.getSort());
                RewriteDivision.this.mAuxVars.put(quotientAuxVar, this.mScript.term("div", new Term[]{dividend, divisor}));
                TermVariable remainderAuxVar = RewriteDivision.this.mVarFactory.getOrConstructAuxVar(RewriteDivision.MOD_AUX_PREFIX + dividend.toString() + divisor.toString(), appTerm.getSort());
                RewriteDivision.this.mAuxVars.put(remainderAuxVar, (Term)appTerm);
                Term modAuxTerms = this.computeModAuxTerms(dividend, divisor, quotientAuxVar, remainderAuxVar);
                RewriteDivision.this.mAuxTerms.add(modAuxTerms);
                this.setResult((Term)remainderAuxVar);
                return;
            }
            super.convertApplicationTerm(appTerm, newArgs);
        }

        private Term computeDivAuxTerms(Term dividend, Term divisor, TermVariable quotientAuxVar) {
            Term[] disjuncts = new Term[2];
            Term one = SmtUtils.constructIntValue((Script)this.mScript, (BigInteger)BigInteger.ONE);
            Term minusOne = this.mScript.term("-", new Term[]{one});
            Term divisorIsNegative = this.mScript.term("<=", new Term[]{divisor, minusOne});
            Term divisorIsPositive = this.mScript.term(">=", new Term[]{divisor, one});
            Term quotientMulDivisor = this.mScript.term("*", new Term[]{quotientAuxVar, divisor});
            Term isLowerBound = this.mScript.term("<=", new Term[]{quotientMulDivisor, dividend});
            Term strictUpperBoundPosDivisor = this.mScript.term("*", new Term[]{this.mScript.term("+", new Term[]{quotientAuxVar, one}), divisor});
            Term upperBoundPosDivisor = this.mScript.term("-", new Term[]{strictUpperBoundPosDivisor, one});
            Term strictUpperBoundNegDivisor = this.mScript.term("*", new Term[]{this.mScript.term("-", new Term[]{quotientAuxVar, one}), divisor});
            Term upperBoundNegDivisor = this.mScript.term("-", new Term[]{strictUpperBoundNegDivisor, one});
            Term isUpperBoundPosDivisor = this.mScript.term("<=", new Term[]{dividend, upperBoundPosDivisor});
            Term isUpperBoundNegDivisor = this.mScript.term("<=", new Term[]{dividend, upperBoundNegDivisor});
            disjuncts[0] = SmtUtils.and((Script)this.mScript, (Term[])new Term[]{divisorIsPositive, isLowerBound, isUpperBoundPosDivisor});
            disjuncts[1] = SmtUtils.and((Script)this.mScript, (Term[])new Term[]{divisorIsNegative, isLowerBound, isUpperBoundNegDivisor});
            return SmtUtils.or((Script)this.mScript, (Term[])disjuncts);
        }

        private Term computeModAuxTerms(Term dividend, Term divisor, TermVariable quotientAuxVar, TermVariable remainderAuxVar) {
            Term[] disjuncts = new Term[2];
            Term one = SmtUtils.constructIntValue((Script)this.mScript, (BigInteger)BigInteger.ONE);
            Term minusOne = this.mScript.term("-", new Term[]{one});
            Term divisorIsNegative = this.mScript.term("<=", new Term[]{divisor, minusOne});
            Term divisorIsPositive = this.mScript.term(">=", new Term[]{divisor, one});
            Term zero = SmtUtils.constructIntValue((Script)this.mScript, (BigInteger)BigInteger.ZERO);
            Term isLowerBound = this.mScript.term("<=", new Term[]{zero, remainderAuxVar});
            Term upperBoundPosDivisor = this.mScript.term("-", new Term[]{divisor, one});
            Term isUpperBoundPosDivisor = this.mScript.term("<=", new Term[]{remainderAuxVar, upperBoundPosDivisor});
            Term upperBoundNegDivisor = this.mScript.term("-", new Term[]{this.mScript.term("-", new Term[]{divisor}), one});
            Term isUpperBoundNegDivisor = this.mScript.term("<=", new Term[]{remainderAuxVar, upperBoundNegDivisor});
            Term equality = this.mScript.term("=", new Term[]{dividend, this.mScript.term("+", new Term[]{this.mScript.term("*", new Term[]{quotientAuxVar, divisor}), remainderAuxVar})});
            disjuncts[0] = SmtUtils.and((Script)this.mScript, (Term[])new Term[]{divisorIsPositive, isLowerBound, isUpperBoundPosDivisor, equality});
            disjuncts[1] = SmtUtils.and((Script)this.mScript, (Term[])new Term[]{divisorIsNegative, isLowerBound, isUpperBoundNegDivisor, equality});
            return SmtUtils.or((Script)this.mScript, (Term[])disjuncts);
        }
    }
}

