/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TransformerPreprocessor;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.Util;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class RewriteEquality
extends TransformerPreprocessor {
    public static final String DESCRIPTION = "Replaces a = b with (a <= b /\\ a >= b) and a != b with (a > b \\/ a < b)";

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public boolean checkSoundness(Script script, ModifiableTransFormula oldTF, ModifiableTransFormula newTF) {
        Term oldTerm = oldTF.getFormula();
        Term newTerm = newTF.getFormula();
        return Script.LBool.SAT != Util.checkSat((Script)script, (Term)script.term("distinct", new Term[]{oldTerm, newTerm}));
    }

    @Override
    protected TermTransformer getTransformer(ManagedScript script) {
        return new RewriteEqualityTransformer(script.getScript());
    }

    private static final class RewriteEqualityTransformer
    extends TermTransformer {
        private static final Set<String> SUPPORTED_SORTS = new HashSet<String>(Arrays.asList("Int", "Real"));
        private final Script mScript;

        RewriteEqualityTransformer(Script script) {
            assert (script != null);
            this.mScript = script;
        }

        protected void convert(Term term) {
            if (!(term instanceof ApplicationTerm)) {
                super.convert(term);
                return;
            }
            ApplicationTerm appt = (ApplicationTerm)term;
            String funName = appt.getFunction().getName();
            if (!"=".equals(funName) && !"distinct".equals(funName)) {
                super.convert(term);
                return;
            }
            String paramSortName = appt.getParameters()[0].getSort().getName();
            if (!SUPPORTED_SORTS.contains(paramSortName)) {
                this.setResult(term);
                return;
            }
            if ("=".equals(funName)) {
                assert (appt.getParameters().length == 2) : "equality with more than two parameters not yet supported";
                Term param1 = this.mScript.term("<=", appt.getParameters());
                Term param2 = this.mScript.term(">=", appt.getParameters());
                this.setResult(this.mScript.term("and", new Term[]{param1, param2}));
                return;
            }
            if ("distinct".equals(funName)) {
                assert (appt.getParameters().length == 2) : "distinct with more than two parameters not yet supported";
                Term param1 = this.mScript.term("<", appt.getParameters());
                Term param2 = this.mScript.term(">", appt.getParameters());
                this.setResult(this.mScript.term("or", new Term[]{param1, param2}));
                return;
            }
        }
    }
}

