/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TransformerPreprocessor;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.Util;
import java.math.BigInteger;

public class RewriteStrictInequalities
extends TransformerPreprocessor {
    public static final String DESCRIPTION = "Replace strict inequalities by non-strict inequalities";

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public boolean checkSoundness(Script script, ModifiableTransFormula oldTF, ModifiableTransFormula newTF) {
        Term oldTerm = oldTF.getFormula();
        Term newTerm = newTF.getFormula();
        return Script.LBool.SAT != Util.checkSat((Script)script, (Term)script.term("distinct", new Term[]{oldTerm, newTerm}));
    }

    @Override
    protected TermTransformer getTransformer(ManagedScript script) {
        return new RewriteStrictInequalitiesTransformer(script.getScript());
    }

    private static final class RewriteStrictInequalitiesTransformer
    extends TermTransformer {
        private final Script mScript;

        RewriteStrictInequalitiesTransformer(Script script) {
            assert (script != null);
            this.mScript = script;
        }

        protected void convert(Term term) {
            if (term instanceof ApplicationTerm) {
                ApplicationTerm appTerm = (ApplicationTerm)term;
                String functionSymbolName = appTerm.getFunction().getName();
                Term result = null;
                if (functionSymbolName.equals("<")) {
                    result = this.computeCorrespondingInequality(appTerm);
                } else if (functionSymbolName.equals(">")) {
                    result = this.computeCorrespondingInequality(appTerm);
                }
                if (result != null) {
                    this.setResult(result);
                    return;
                }
            }
            super.convert(term);
        }

        private Term computeCorrespondingInequality(ApplicationTerm appTerm) {
            Term result;
            String functionSymbolName = appTerm.getFunction().getName();
            if (appTerm.getParameters().length != 2) {
                throw new AssertionError((Object)"expected binary terms");
            }
            if (!SmtSortUtils.isIntSort((Sort)appTerm.getParameters()[0].getSort())) {
                return null;
            }
            Term one = SmtUtils.constructIntValue((Script)this.mScript, (BigInteger)BigInteger.ONE);
            if (functionSymbolName.equals("<")) {
                result = this.mScript.term("<=", new Term[]{this.mScript.term("+", new Term[]{appTerm.getParameters()[0], one}), appTerm.getParameters()[1]});
            } else if (functionSymbolName.equals(">")) {
                result = this.mScript.term(">=", new Term[]{appTerm.getParameters()[0], this.mScript.term("+", new Term[]{appTerm.getParameters()[1], one})});
            } else {
                throw new AssertionError();
            }
            return result;
        }
    }
}

