/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TermException;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TransitionPreprocessor;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.IReplacementVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.IReplacementVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.ReplacementConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.ReplacementVarFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class RewriteTermVariables
extends TransitionPreprocessor {
    private final Map<Term, Term> mSubstitutionMapping;
    private final ReplacementVarFactory mVarFactory;
    protected final ManagedScript mScript;
    private final Sort mRepVarSort;

    public RewriteTermVariables(ReplacementVarFactory varFactory, ManagedScript script) {
        this.mVarFactory = varFactory;
        this.mScript = script;
        this.mRepVarSort = this.mScript.getScript().sort(this.getRepVarSortName(), new Sort[0]);
        this.mSubstitutionMapping = new LinkedHashMap<Term, Term>();
    }

    protected abstract Term constructNewDefinitionForRankVar(IProgramVar var1);

    protected abstract Term constructReplacementTerm(TermVariable var1);

    protected abstract boolean hasToBeReplaced(Term var1);

    protected abstract String getRepVarSortName();

    protected abstract String getTermVariableSuffix();

    private final IReplacementVarOrConst getOrConstructReplacementVar(IProgramVar rankVar) {
        Term definition = this.constructNewDefinitionForRankVar(rankVar);
        IReplacementVar repVar = (IReplacementVar)this.mVarFactory.getOrConstuctReplacementVar(definition, false);
        return repVar;
    }

    private final void generateRepAndAuxVars(ModifiableTransFormula tf) {
        Term replacementTerm;
        IReplacementVar repVar;
        IReplacementVarOrConst varOrConst;
        ArrayList<IProgramVar> rankVarsWithDistinctInVar = new ArrayList<IProgramVar>();
        ArrayList<IProgramVar> rankVarsWithDistinctOutVar = new ArrayList<IProgramVar>();
        ArrayList<IProgramVar> rankVarsWithCommonInVarOutVar = new ArrayList<IProgramVar>();
        for (Map.Entry entry : tf.getInVars().entrySet()) {
            if (!this.hasToBeReplaced((Term)entry.getValue())) continue;
            if (ModifiableTransFormulaUtils.inVarAndOutVarCoincide((IProgramVar)((IProgramVar)entry.getKey()), (ModifiableTransFormula)tf)) {
                rankVarsWithCommonInVarOutVar.add((IProgramVar)entry.getKey());
                continue;
            }
            rankVarsWithDistinctInVar.add((IProgramVar)entry.getKey());
        }
        for (Map.Entry entry : tf.getOutVars().entrySet()) {
            if (!this.hasToBeReplaced((Term)entry.getValue()) || ModifiableTransFormulaUtils.inVarAndOutVarCoincide((IProgramVar)((IProgramVar)entry.getKey()), (ModifiableTransFormula)tf)) continue;
            rankVarsWithDistinctOutVar.add((IProgramVar)entry.getKey());
        }
        for (IProgramVar rv : rankVarsWithCommonInVarOutVar) {
            varOrConst = this.getOrConstructReplacementVar(rv);
            if (varOrConst instanceof ReplacementConst) {
                throw new UnsupportedOperationException("not yet implemented");
            }
            repVar = (IReplacementVar)varOrConst;
            TermVariable newInOutVar = this.mVarFactory.getOrConstructAuxVar(this.computeTermVariableName(repVar.getGloballyUniqueId(), true, true), this.mRepVarSort);
            replacementTerm = this.constructReplacementTerm(newInOutVar);
            this.mSubstitutionMapping.put((Term)tf.getInVars().get(rv), replacementTerm);
            tf.removeInVar(rv);
            tf.addInVar((IProgramVar)repVar, newInOutVar);
            tf.removeOutVar(rv);
            tf.addOutVar((IProgramVar)repVar, newInOutVar);
        }
        for (IProgramVar rv : rankVarsWithDistinctInVar) {
            varOrConst = this.getOrConstructReplacementVar(rv);
            if (varOrConst instanceof ReplacementConst) {
                throw new UnsupportedOperationException("not yet implemented");
            }
            repVar = (IReplacementVar)varOrConst;
            TermVariable newInVar = this.mVarFactory.getOrConstructAuxVar(this.computeTermVariableName(repVar.getGloballyUniqueId(), true, false), this.mRepVarSort);
            replacementTerm = this.constructReplacementTerm(newInVar);
            this.mSubstitutionMapping.put((Term)tf.getInVars().get(rv), replacementTerm);
            tf.removeInVar(rv);
            tf.addInVar((IProgramVar)repVar, newInVar);
        }
        for (IProgramVar rv : rankVarsWithDistinctOutVar) {
            varOrConst = this.getOrConstructReplacementVar(rv);
            if (varOrConst instanceof ReplacementConst) {
                throw new UnsupportedOperationException("not yet implemented");
            }
            repVar = (IReplacementVar)varOrConst;
            TermVariable newOutVar = this.mVarFactory.getOrConstructAuxVar(this.computeTermVariableName(repVar.getGloballyUniqueId(), false, true), this.mRepVarSort);
            replacementTerm = this.constructReplacementTerm(newOutVar);
            this.mSubstitutionMapping.put((Term)tf.getOutVars().get(rv), replacementTerm);
            tf.removeOutVar(rv);
            tf.addOutVar((IProgramVar)repVar, newOutVar);
        }
        ArrayList auxVars = new ArrayList(tf.getAuxVars());
        for (TermVariable tv : auxVars) {
            if (!this.hasToBeReplaced((Term)tv)) continue;
            TermVariable newAuxVar = this.mVarFactory.getOrConstructAuxVar(this.computeTermVariableName(tv.getName(), false, false), this.mRepVarSort);
            tf.removeAuxVar(tv);
            tf.addAuxVars(Collections.singleton(newAuxVar));
            Term replacementTerm2 = this.constructReplacementTerm(newAuxVar);
            this.mSubstitutionMapping.put((Term)tv, replacementTerm2);
        }
    }

    private final String computeTermVariableName(String baseName, boolean isInVar, boolean isOutVar) {
        String result = isInVar ? (isOutVar ? String.valueOf(baseName) + "_inout_" + this.getTermVariableSuffix() : String.valueOf(baseName) + "_in_" + this.getTermVariableSuffix()) : (isOutVar ? String.valueOf(baseName) + "_out_" + this.getTermVariableSuffix() : String.valueOf(baseName) + "_aux_" + this.getTermVariableSuffix());
        return result;
    }

    @Override
    public final ModifiableTransFormula process(ManagedScript script, ModifiableTransFormula tf) throws TermException {
        this.generateRepAndAuxVars(tf);
        ModifiableTransFormula newTf = new ModifiableTransFormula(tf);
        Term newFormula = Substitution.apply((ManagedScript)script, this.mSubstitutionMapping, (Term)tf.getFormula());
        newTf.setFormula(newFormula);
        return newTf;
    }
}

