/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TransformerPreprocessor;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.Util;

public class RewriteTrueFalse
extends TransformerPreprocessor {
    public static final String DESCRIPTION = "Replace 'true' with '0 >= 0' and 'false' with '0 >= 1'";

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public boolean checkSoundness(Script script, ModifiableTransFormula oldTF, ModifiableTransFormula newTF) {
        Term oldTerm = oldTF.getFormula();
        Term newTerm = newTF.getFormula();
        return Script.LBool.SAT != Util.checkSat((Script)script, (Term)script.term("distinct", new Term[]{oldTerm, newTerm}));
    }

    @Override
    protected TermTransformer getTransformer(ManagedScript script) {
        return new RewriteTrueFalseTransformer(script.getScript());
    }

    private static final class RewriteTrueFalseTransformer
    extends TermTransformer {
        private final Script mScript;

        RewriteTrueFalseTransformer(Script script) {
            assert (script != null);
            this.mScript = script;
        }

        protected void convert(Term term) {
            if (term instanceof ApplicationTerm) {
                ApplicationTerm appt = (ApplicationTerm)term;
                if (appt.getFunction().getName().equals("true")) {
                    assert (appt.getParameters().length == 0);
                    this.setResult(this.mScript.term(">=", new Term[]{this.mScript.decimal("0"), this.mScript.decimal("0")}));
                    return;
                }
                if (appt.getFunction().getName().equals("false")) {
                    assert (appt.getParameters().length == 0);
                    this.setResult(this.mScript.term(">=", new Term[]{this.mScript.decimal("0"), this.mScript.decimal("1")}));
                    return;
                }
            }
            super.convert(term);
        }
    }
}

