/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.RewriteTermVariables;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.ReplacementVarFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.ReplacementVarUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;

public class RewriteUserDefinedTypes
extends RewriteTermVariables {
    public static final String DESCRIPTION = "Replace variables that have a used defined type";
    private static final String TERM_VARIABLE_SUFFIX = "udt";
    private static final String REP_VAR_SORT_NAME = "Int";

    public RewriteUserDefinedTypes(ReplacementVarFactory varFactory, ManagedScript script) {
        super(varFactory, script);
    }

    @Override
    protected String getTermVariableSuffix() {
        return TERM_VARIABLE_SUFFIX;
    }

    @Override
    protected String getRepVarSortName() {
        return REP_VAR_SORT_NAME;
    }

    @Override
    protected boolean hasToBeReplaced(Term term) {
        return RewriteUserDefinedTypes.hasNonInternalSort(term);
    }

    private static final boolean hasNonInternalSort(Term term) {
        return !term.getSort().getRealSort().isInternal();
    }

    @Override
    protected Term constructReplacementTerm(TermVariable newTv) {
        return newTv;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    protected Term constructNewDefinitionForRankVar(IProgramVar oldRankVar) {
        Term definition = ReplacementVarUtils.getDefinition((IProgramVar)oldRankVar);
        return definition;
    }
}

