/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TermException;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TransitionPreprocessor;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;

public class SimplifyPreprocessor
extends TransitionPreprocessor {
    public static final String DESCRIPTION = "Simplify formula using some simplification technique";
    private final IUltimateServiceProvider mServices;
    private final SmtUtils.SimplificationTechnique mSimplificationTechnique;

    public SimplifyPreprocessor(IUltimateServiceProvider services, SmtUtils.SimplificationTechnique simplificationTechnique) {
        this.mServices = services;
        this.mSimplificationTechnique = simplificationTechnique;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public boolean checkSoundness(Script script, ModifiableTransFormula oldTF, ModifiableTransFormula newTF) {
        return true;
    }

    @Override
    public ModifiableTransFormula process(ManagedScript script, ModifiableTransFormula tf) throws TermException {
        Term simplified = SmtUtils.simplify((ManagedScript)script, (Term)tf.getFormula(), (IUltimateServiceProvider)this.mServices, (SmtUtils.SimplificationTechnique)this.mSimplificationTechnique);
        tf.setFormula(simplified);
        return tf;
    }
}

