/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.HashUtils;
import java.util.ArrayDeque;

public class ApplicationTerm
extends Term {
    final FunctionSymbol mFunction;
    final Term[] mParameters;

    ApplicationTerm(FunctionSymbol function, Term[] parameters, int hash) {
        super(hash);
        function.typecheck(parameters);
        this.mFunction = function;
        this.mParameters = parameters;
    }

    public FunctionSymbol getFunction() {
        return this.mFunction;
    }

    public Term[] getParameters() {
        return this.mParameters;
    }

    @Override
    public Sort getSort() {
        return this.mFunction.mReturnSort.getRealSort();
    }

    static final int hashApplication(FunctionSymbol func, Term[] parameters) {
        return HashUtils.hashJenkins((int)func.hashCode(), (Object[])parameters);
    }

    @Override
    public void toStringHelper(ArrayDeque<Object> mTodo) {
        String func = this.getFunction().getApplicationString();
        Term[] args = this.getParameters();
        if (args.length == 0) {
            mTodo.add(func);
        } else {
            mTodo.addLast(")");
            int i = args.length - 1;
            while (i >= 0) {
                mTodo.addLast(args[i]);
                mTodo.addLast(" ");
                --i;
            }
            mTodo.add(func);
            mTodo.add("(");
        }
    }
}

