/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.LambdaTerm;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.MatchTerm;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;

public class ComputeFreeVariables
extends NonRecursive {
    static final TermVariable[] NOFREEVARS = new TermVariable[0];

    public void transform(Term term) {
        this.enqueueTerm(term);
        this.run();
    }

    public void enqueueTerm(Term term) {
        this.enqueueWalker(engine -> this.walkTerm(term));
    }

    public void walkTerm(Term term) {
        if (term.mFreeVars != null) {
            return;
        }
        if (term instanceof ConstantTerm) {
            term.mFreeVars = NOFREEVARS;
        } else if (term instanceof TermVariable) {
            term.mFreeVars = new TermVariable[]{(TermVariable)term};
        } else if (term instanceof ApplicationTerm) {
            this.walkApplicationTerm((ApplicationTerm)term);
        } else if (term instanceof LetTerm) {
            this.walkLetTerm((LetTerm)term);
        } else if (term instanceof AnnotatedTerm) {
            this.walkAnnotatedTerm((AnnotatedTerm)term);
        } else if (term instanceof LambdaTerm) {
            this.walkLambdaTerm((LambdaTerm)term);
        } else if (term instanceof QuantifiedFormula) {
            this.walkQuantifiedFormula((QuantifiedFormula)term);
        } else if (term instanceof MatchTerm) {
            this.walkMatchTerm((MatchTerm)term);
        } else {
            throw new AssertionError((Object)"Unknown Term");
        }
    }

    public void walkApplicationTerm(ApplicationTerm appTerm) {
        boolean enqueuedAgain = false;
        Term[] termArray = appTerm.getParameters();
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Term param = termArray[n2];
            if (param.mFreeVars == null) {
                if (!enqueuedAgain) {
                    this.enqueueTerm(appTerm);
                    enqueuedAgain = true;
                }
                this.enqueueTerm(param);
            }
            ++n2;
        }
        if (enqueuedAgain) {
            return;
        }
        Term[] params = appTerm.getParameters();
        if (params.length <= 1) {
            appTerm.mFreeVars = params.length == 1 ? params[0].mFreeVars : NOFREEVARS;
        } else {
            int biggestlen = 0;
            int biggestidx = -1;
            int i = 0;
            while (i < params.length) {
                TermVariable[] free = params[i].mFreeVars;
                if (free.length > biggestlen) {
                    biggestlen = free.length;
                    biggestidx = i;
                }
                ++i;
            }
            if (biggestidx < 0) {
                appTerm.mFreeVars = NOFREEVARS;
            } else {
                ArrayList<TermVariable> result = null;
                List<TermVariable> biggestAsList = Arrays.asList(params[biggestidx].mFreeVars);
                int i2 = 0;
                while (i2 < params.length) {
                    if (i2 != biggestidx) {
                        TermVariable[] free;
                        TermVariable[] termVariableArray = free = params[i2].getFreeVars();
                        int n3 = free.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            TermVariable tv = termVariableArray[n4];
                            if (!biggestAsList.contains(tv)) {
                                if (result == null) {
                                    result = new ArrayList<TermVariable>();
                                    result.addAll(biggestAsList);
                                }
                                if (!result.contains(tv)) {
                                    result.add(tv);
                                }
                            }
                            ++n4;
                        }
                    }
                    ++i2;
                }
                appTerm.mFreeVars = result == null ? params[biggestidx].mFreeVars : result.toArray(new TermVariable[result.size()]);
            }
        }
    }

    public void walkLetTerm(LetTerm letTerm) {
        Term[] vals;
        boolean enqueuedAgain = false;
        Term[] termArray = vals = letTerm.getValues();
        int n = vals.length;
        int n2 = 0;
        while (n2 < n) {
            Term value = termArray[n2];
            if (value.mFreeVars == null) {
                if (!enqueuedAgain) {
                    this.enqueueTerm(letTerm);
                    enqueuedAgain = true;
                }
                this.enqueueTerm(value);
            }
            ++n2;
        }
        Term body = letTerm.getSubTerm();
        if (body.mFreeVars == null) {
            if (!enqueuedAgain) {
                this.enqueueTerm(letTerm);
                enqueuedAgain = true;
            }
            this.enqueueTerm(body);
        }
        if (enqueuedAgain) {
            return;
        }
        TermVariable[] vars = letTerm.getVariables();
        LinkedHashSet<TermVariable> free = new LinkedHashSet<TermVariable>();
        free.addAll(Arrays.asList(body.mFreeVars));
        free.removeAll(Arrays.asList(vars));
        Term[] termArray2 = vals;
        int n3 = vals.length;
        int n4 = 0;
        while (n4 < n3) {
            Term v = termArray2[n4];
            free.addAll(Arrays.asList(v.mFreeVars));
            ++n4;
        }
        letTerm.mFreeVars = free.isEmpty() ? NOFREEVARS : free.toArray(new TermVariable[free.size()]);
    }

    public void walkLambdaTerm(LambdaTerm lambdaTerm) {
        Term body = lambdaTerm.getSubterm();
        if (body.mFreeVars == null) {
            this.enqueueTerm(lambdaTerm);
            this.enqueueTerm(body);
            return;
        }
        LinkedHashSet<TermVariable> free = new LinkedHashSet<TermVariable>();
        free.addAll(Arrays.asList(body.mFreeVars));
        free.removeAll(Arrays.asList(lambdaTerm.getVariables()));
        lambdaTerm.mFreeVars = free.isEmpty() ? NOFREEVARS : free.toArray(new TermVariable[free.size()]);
    }

    public void walkQuantifiedFormula(QuantifiedFormula quant) {
        Term body = quant.getSubformula();
        if (body.mFreeVars == null) {
            this.enqueueTerm(quant);
            this.enqueueTerm(body);
            return;
        }
        LinkedHashSet<TermVariable> free = new LinkedHashSet<TermVariable>();
        free.addAll(Arrays.asList(body.mFreeVars));
        free.removeAll(Arrays.asList(quant.getVariables()));
        quant.mFreeVars = free.isEmpty() ? NOFREEVARS : free.toArray(new TermVariable[free.size()]);
    }

    public void walkAnnotatedTerm(AnnotatedTerm annotTerm) {
        boolean enqueuedAgain = false;
        LinkedHashSet<TermVariable> free = new LinkedHashSet<TermVariable>();
        Term body = annotTerm.getSubterm();
        if (body.mFreeVars == null) {
            if (!enqueuedAgain) {
                this.enqueueTerm(annotTerm);
                enqueuedAgain = true;
            }
            this.enqueueTerm(body);
        } else {
            free.addAll(Arrays.asList(body.mFreeVars));
        }
        ArrayDeque<Object> todo = new ArrayDeque<Object>();
        Annotation[] annotationArray = annotTerm.getAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annot = annotationArray[n2];
            if (annot.getValue() != null) {
                todo.add(annot.getValue());
            }
            ++n2;
        }
        while (!todo.isEmpty()) {
            Object value = todo.removeLast();
            if (value instanceof Term) {
                Term subTerm = (Term)value;
                if (subTerm.mFreeVars == null) {
                    if (!enqueuedAgain) {
                        this.enqueueTerm(annotTerm);
                        enqueuedAgain = true;
                    }
                    this.enqueueTerm(subTerm);
                    continue;
                }
                if (enqueuedAgain) continue;
                free.addAll(Arrays.asList(((Term)value).mFreeVars));
                continue;
            }
            if (!(value instanceof Object[])) continue;
            Object[] objectArray = (Object[])value;
            int n3 = objectArray.length;
            n = 0;
            while (n < n3) {
                Object elem = objectArray[n];
                todo.add(elem);
                ++n;
            }
        }
        if (!enqueuedAgain) {
            annotTerm.mFreeVars = free.isEmpty() ? NOFREEVARS : (free.size() == body.mFreeVars.length ? body.mFreeVars : free.toArray(new TermVariable[free.size()]));
        }
    }

    public void walkMatchTerm(MatchTerm match) {
        Term[] cases;
        boolean enqueuedAgain = false;
        Term[] termArray = cases = match.getCases();
        int n = cases.length;
        int n2 = 0;
        while (n2 < n) {
            Term subCase = termArray[n2];
            if (subCase.mFreeVars == null) {
                if (!enqueuedAgain) {
                    this.enqueueTerm(match);
                    enqueuedAgain = true;
                }
                this.enqueueTerm(subCase);
            }
            ++n2;
        }
        Term dataTerm = match.getDataTerm();
        if (dataTerm.mFreeVars == null) {
            if (!enqueuedAgain) {
                this.enqueueTerm(match);
                enqueuedAgain = true;
            }
            this.enqueueTerm(dataTerm);
        }
        if (enqueuedAgain) {
            return;
        }
        LinkedHashSet free = new LinkedHashSet();
        int i = 0;
        while (i < cases.length) {
            LinkedHashSet<TermVariable> freeCase = new LinkedHashSet<TermVariable>();
            freeCase.addAll(Arrays.asList(cases[i].mFreeVars));
            freeCase.removeAll(Arrays.asList(match.getVariables()[i]));
            free.addAll(freeCase);
            ++i;
        }
        free.addAll(Arrays.asList(dataTerm.mFreeVars));
        match.mFreeVars = free.isEmpty() ? NOFREEVARS : (free.size() == dataTerm.mFreeVars.length ? dataTerm.mFreeVars : free.toArray(new TermVariable[free.size()]));
    }
}

