/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayDeque;

public class ConstantTerm
extends Term {
    private final Object mValue;
    private final Sort mSort;

    ConstantTerm(Object value, Sort sort, int hash) {
        super(hash);
        this.mValue = value;
        this.mSort = sort;
    }

    public Object getValue() {
        return this.mValue;
    }

    @Override
    public Sort getSort() {
        return this.mSort;
    }

    @Override
    public String toString() {
        if (this.mValue instanceof BigInteger) {
            BigInteger value = (BigInteger)this.mValue;
            String result = value.abs().toString();
            if (value.signum() < 0) {
                result = "(- " + result + ")";
            }
            return result;
        }
        if (this.mValue instanceof BigDecimal) {
            BigDecimal decimal = (BigDecimal)this.mValue;
            String result = decimal.abs().toPlainString();
            if (decimal.signum() < 0) {
                result = "(- " + result + ")";
            }
            return result;
        }
        if (this.mValue instanceof Rational) {
            Rational rat = (Rational)this.mValue;
            String result = rat.numerator().abs().toString();
            if (this.getSort().getName() == "Real") {
                result = String.valueOf(result) + ".0";
            }
            if (rat.isNegative()) {
                result = "(- " + result + ")";
            }
            if (!rat.isIntegral()) {
                assert (this.getSort().getName() == "Real");
                result = "(/ " + result + " " + rat.denominator() + ".0)";
            }
            return result;
        }
        return this.mValue.toString();
    }

    @Override
    public String toStringDirect() {
        return this.toString();
    }

    public static final int hashConstant(Object value, Sort sort) {
        return value.hashCode() ^ sort.hashCode();
    }

    @Override
    public void toStringHelper(ArrayDeque<Object> mTodo) {
        mTodo.add(this.toString());
    }
}

