/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.SortSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashSet;
import java.util.NoSuchElementException;

public class DataType
extends SortSymbol {
    Constructor[] mConstructors;
    Sort[] mSortVariables;

    public DataType(Theory theory, String name, int numParams) {
        super(theory, name, numParams, null, 32);
    }

    public void setConstructors(Sort[] sortVars, Constructor[] constrs) {
        assert (this.mConstructors == null);
        this.mSortVariables = sortVars;
        this.mConstructors = constrs;
        if (sortVars != null) {
            Constructor[] constructorArray = constrs;
            int n = constrs.length;
            int n2 = 0;
            while (n2 < n) {
                Constructor cons = constructorArray[n2];
                cons.mNeedsReturnOverload = this.checkReturnOverload(sortVars, cons.mArgumentSorts);
                ++n2;
            }
        }
    }

    public Sort[] getSortVariables() {
        return this.mSortVariables;
    }

    public Constructor findConstructor(String name) {
        int i = 0;
        while (i < this.mConstructors.length) {
            if (this.mConstructors[i].getName().equals(name)) {
                return this.mConstructors[i];
            }
            ++i;
        }
        return null;
    }

    public Constructor getConstructor(String name) {
        Constructor constr = this.findConstructor(name);
        if (constr == null) {
            throw new NoSuchElementException();
        }
        return constr;
    }

    public Constructor[] getConstructors() {
        return this.mConstructors;
    }

    private boolean checkReturnOverload(Sort[] sortParams, Sort[] argumentSorts) {
        BitSet unused = new BitSet();
        unused.set(0, sortParams.length);
        ArrayDeque<Sort> todo = new ArrayDeque<Sort>();
        HashSet<Sort> seen = new HashSet<Sort>();
        todo.addAll(Arrays.asList(argumentSorts));
        block0: while (!todo.isEmpty()) {
            Sort sort = (Sort)todo.removeFirst();
            if (!seen.add(sort)) continue;
            if (sort.isSortVariable()) {
                int i = 0;
                while (i < sortParams.length) {
                    if (sort == sortParams[i]) {
                        unused.clear(i);
                        continue block0;
                    }
                    ++i;
                }
                continue;
            }
            todo.addAll(Arrays.asList(sort.getArguments()));
        }
        return !unused.isEmpty();
    }

    public static class Constructor {
        private final String mName;
        private final Sort[] mArgumentSorts;
        private final String[] mSelectors;
        private boolean mNeedsReturnOverload;

        public Constructor(String name, String[] selectors, Sort[] argumentSorts) {
            this.mName = name;
            this.mSelectors = selectors;
            this.mArgumentSorts = argumentSorts;
        }

        public String getName() {
            return this.mName;
        }

        public Sort[] getArgumentSorts() {
            return this.mArgumentSorts;
        }

        public int getSelectorIndex(String selector) {
            int i = 0;
            while (i < this.mSelectors.length) {
                if (this.mSelectors[i].equals(selector)) {
                    return i;
                }
                ++i;
            }
            throw new NoSuchElementException();
        }

        public String[] getSelectors() {
            return this.mSelectors;
        }

        public boolean needsReturnOverload() {
            return this.mNeedsReturnOverload;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("(");
            sb.append(this.mName);
            if (this.mSelectors.length != 0) {
                int i = 0;
                while (i < this.mSelectors.length) {
                    sb.append(" ");
                    sb.append("(");
                    sb.append(this.mSelectors[i]);
                    sb.append(" ");
                    sb.append(this.mArgumentSorts[i]);
                    sb.append(")");
                    ++i;
                }
            }
            sb.append(")");
            return sb.toString();
        }
    }
}

