/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.PrintTerm;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.util.HashUtils;

public class FunctionSymbol {
    public static final int INTERNAL = 1;
    public static final int LEFTASSOC = 2;
    public static final int RIGHTASSOC = 4;
    public static final int CHAINABLE = 6;
    public static final int PAIRWISE = 8;
    public static final int ASSOCMASK = 14;
    public static final int RETURNOVERLOAD = 16;
    public static final int MODELVALUE = 32;
    public static final int UNINTERPRETEDINTERNAL = 64;
    public static final int CONSTRUCTOR = 128;
    public static final int SELECTOR = 256;
    final String mName;
    final String[] mIndices;
    final Sort[] mParamSort;
    final Sort mReturnSort;
    final int mFlags;
    final TermVariable[] mDefinitionVars;
    final Term mDefinition;
    final int mHash;

    FunctionSymbol(String n, String[] i, Sort[] params, Sort result, TermVariable[] definitionVars, Term definition, int flags) {
        this.mName = n;
        this.mIndices = i;
        this.mParamSort = params;
        this.mReturnSort = result;
        this.mFlags = flags;
        this.mDefinition = definition;
        this.mDefinitionVars = definitionVars;
        if (this.isLeftAssoc() && (params.length != 2 || !params[0].equalsSort(result))) {
            throw new IllegalArgumentException("Wrong sorts for left-associative symbol");
        }
        if (this.isRightAssoc() && (params.length != 2 || !params[1].equalsSort(result))) {
            throw new IllegalArgumentException("Wrong sorts for right-associative symbol");
        }
        if (!(!this.isChainable() && !this.isPairwise() || params.length == 2 && params[0].equalsSort(params[1]) && result.equalsSort(this.getTheory().getBooleanSort()))) {
            throw new IllegalArgumentException("Wrong sorts for chainable symbol");
        }
        int hash = HashUtils.hashJenkins((int)this.mName.hashCode(), (Object[])this.mParamSort);
        if (this.mIndices != null) {
            hash = HashUtils.hashJenkins((int)hash, (Object[])this.mIndices);
        }
        if (this.mReturnSort != null) {
            hash = HashUtils.hashJenkins((int)hash, (Object)this.mReturnSort);
        }
        this.mHash = hash;
    }

    public int hashCode() {
        return this.mHash;
    }

    public String getName() {
        return this.mName;
    }

    public String[] getIndices() {
        return this.mIndices;
    }

    public boolean isIntern() {
        return (this.mFlags & 1) != 0;
    }

    public boolean isModelValue() {
        return (this.mFlags & 0x20) != 0;
    }

    public Theory getTheory() {
        return this.mReturnSort.mSymbol.mTheory;
    }

    @Deprecated
    public int getParameterCount() {
        return this.mParamSort.length;
    }

    @Deprecated
    public Sort getParameterSort(int i) {
        return this.mParamSort[i];
    }

    public TermVariable[] getDefinitionVars() {
        return this.mDefinitionVars;
    }

    public Term getDefinition() {
        return this.mDefinition;
    }

    public Sort getReturnSort() {
        return this.mReturnSort;
    }

    public Sort[] getParameterSorts() {
        return this.mParamSort;
    }

    private final void checkSort(Term arg, Sort sort) {
        Sort argSort = arg.getSort();
        if (!sort.equalsSort(argSort)) {
            if (argSort.toString().equals(sort.toString())) {
                throw new SMTLIBException("Argument " + arg + " comes from wrong theory.");
            }
            throw new SMTLIBException("Argument " + arg + " has type " + argSort + " but function " + this.mName + " expects " + sort);
        }
    }

    public void typecheck(Term[] params) throws SMTLIBException {
        assert (params.getClass() == Term[].class);
        if ((this.mFlags & 0xE) != 0) {
            if (params.length < 2) {
                throw new SMTLIBException("Function " + this.mName + " expects at least two arguments.");
            }
            this.checkSort(params[0], this.mParamSort[0]);
            this.checkSort(params[params.length - 1], this.mParamSort[1]);
            Sort otherSort = this.isLeftAssoc() ? this.mParamSort[1] : this.mParamSort[0];
            int i = 1;
            while (i < params.length - 1) {
                this.checkSort(params[i], otherSort);
                ++i;
            }
        } else {
            if (params.length != this.mParamSort.length) {
                throw new SMTLIBException("Function " + this.mName + " expects " + this.mParamSort.length + " arguments.");
            }
            int i = 0;
            while (i < this.mParamSort.length) {
                this.checkSort(params[i], this.mParamSort[i]);
                ++i;
            }
        }
    }

    public boolean typecheck(Sort[] params) {
        if ((this.mFlags & 0xE) != 0) {
            assert (this.mParamSort.length == 2);
            if (params.length < 2) {
                return false;
            }
            if (!params[0].equalsSort(this.mParamSort[0])) {
                return false;
            }
            if (!params[params.length - 1].equalsSort(this.mParamSort[1])) {
                return false;
            }
            Sort otherSort = this.isLeftAssoc() ? this.mParamSort[1] : this.mParamSort[0];
            int i = 1;
            while (i < params.length - 1) {
                if (!params[i].equalsSort(otherSort)) {
                    return false;
                }
                ++i;
            }
        } else {
            if (params.length != this.mParamSort.length) {
                return false;
            }
            int i = 0;
            while (i < this.mParamSort.length) {
                if (!params[i].equalsSort(this.mParamSort[i])) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public String toString() {
        int n;
        int n2;
        Object[] objectArray;
        StringBuffer sb = new StringBuffer();
        String name = PrintTerm.quoteIdentifier(this.mName);
        sb.append('(');
        if (this.mIndices == null) {
            sb.append(name);
        } else {
            sb.append("(_ ").append(name);
            objectArray = this.mIndices;
            n2 = this.mIndices.length;
            n = 0;
            while (n < n2) {
                Object i = objectArray[n];
                sb.append(' ').append((String)i);
                ++n;
            }
            sb.append(')');
        }
        objectArray = this.mParamSort;
        n2 = this.mParamSort.length;
        n = 0;
        while (n < n2) {
            Object s = objectArray[n];
            sb.append(' ').append(s);
            ++n;
        }
        sb.append(' ').append(this.mReturnSort);
        sb.append(')');
        return sb.toString();
    }

    public final boolean isChainable() {
        return (this.mFlags & 0xE) == 6;
    }

    public final boolean isPairwise() {
        return (this.mFlags & 0xE) == 8;
    }

    public final boolean isLeftAssoc() {
        return (this.mFlags & 0xE) == 2;
    }

    public final boolean isRightAssoc() {
        return (this.mFlags & 0xE) == 4;
    }

    public final boolean isReturnOverload() {
        return (this.mFlags & 0x10) != 0;
    }

    public String getApplicationString() {
        String name = PrintTerm.quoteIdentifier(this.mName);
        if (this.mIndices == null && !this.isReturnOverload()) {
            return name;
        }
        StringBuffer sb = new StringBuffer();
        if (this.isReturnOverload()) {
            sb.append("(as ");
        }
        if (this.mIndices != null) {
            sb.append("(_ ");
        }
        sb.append(name);
        if (this.mIndices != null) {
            String[] stringArray = this.mIndices;
            int n = this.mIndices.length;
            int n2 = 0;
            while (n2 < n) {
                String i = stringArray[n2];
                sb.append(' ').append(i);
                ++n2;
            }
            sb.append(')');
        }
        if (this.isReturnOverload()) {
            sb.append(' ').append(this.getReturnSort()).append(')');
        }
        return sb.toString();
    }

    public boolean isInterpreted() {
        return this.isModelValue() || this.isIntern() && (this.mFlags & 0x40) == 0;
    }

    public boolean isConstructor() {
        return (this.mFlags & 0x80) != 0;
    }

    public boolean isSelector() {
        return (this.mFlags & 0x100) != 0;
    }
}

