/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.util.datastructures.UnifyHash;
import java.util.Arrays;

public abstract class FunctionSymbolFactory {
    String mFuncName;
    UnifyHash<FunctionSymbol> mInstances;

    public FunctionSymbolFactory(String name) {
        this.mFuncName = name;
        this.mInstances = new UnifyHash();
    }

    public abstract Sort getResultSort(String[] var1, Sort[] var2, Sort var3);

    public int getFlags(String[] indices, Sort[] paramSorts, Sort result) {
        return 1;
    }

    private static boolean isReal(Sort[] sorts) {
        Sort[] sortArray = sorts;
        int n = sorts.length;
        int n2 = 0;
        while (n2 < n) {
            Sort s = sortArray[n2];
            if (s.getRealSort() != s) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public Term getDefinition(TermVariable[] tvs, Sort resultSort) {
        return null;
    }

    public FunctionSymbol getFunctionWithResult(Theory theory, String[] indices, Sort[] paramSorts, Sort resultSort) {
        Term definition;
        assert (FunctionSymbolFactory.isReal(paramSorts));
        int flags = this.getFlags(indices, paramSorts, resultSort);
        if ((flags & 0xE) != 0) {
            if (paramSorts.length < 2) {
                return null;
            }
            Sort[] realParams = new Sort[]{paramSorts[0], paramSorts[paramSorts.length - 1]};
            Sort otherSort = (flags & 0xE) == 2 ? realParams[1] : realParams[0];
            int i = 1;
            while (i < paramSorts.length - 1) {
                if (paramSorts[i] != otherSort) {
                    return null;
                }
                ++i;
            }
            paramSorts = realParams;
        }
        if ((flags & 0x10) == 0 != (resultSort == null)) {
            return null;
        }
        int hash = Arrays.hashCode(indices) ^ Arrays.hashCode(paramSorts) ^ (resultSort == null ? 0 : resultSort.hashCode());
        for (FunctionSymbol func : this.mInstances.iterateHashCode(hash)) {
            if (!Arrays.equals(func.mIndices, indices) || !Arrays.equals(func.mParamSort, paramSorts) || resultSort != null && func.mReturnSort != resultSort) continue;
            return func;
        }
        if ((resultSort = this.getResultSort(indices, paramSorts, resultSort)) == null) {
            return null;
        }
        Term[] defVars = new TermVariable[paramSorts.length];
        int i = 0;
        while (i < paramSorts.length) {
            defVars[i] = theory.createTermVariable("x" + i, paramSorts[i]);
            ++i;
        }
        if ((flags & 0x10) != 0 && resultSort != resultSort.getRealSort()) {
            FunctionSymbol realFunc = this.getFunctionWithResult(theory, indices, paramSorts, resultSort.getRealSort());
            definition = theory.term(realFunc, defVars);
        } else {
            definition = this.getDefinition((TermVariable[])defVars, resultSort);
        }
        if (definition == null) {
            defVars = null;
        }
        FunctionSymbol func = new FunctionSymbol(this.mFuncName, indices, paramSorts, resultSort, (TermVariable[])defVars, definition, flags);
        this.mInstances.put(hash, (Object)func);
        return func;
    }

    public String toString() {
        return this.mFuncName;
    }
}

