/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.HashUtils;
import java.util.ArrayDeque;

public class LetTerm
extends Term {
    private final TermVariable[] mVariables;
    private final Term[] mValues;
    private final Term mSubterm;
    private final Sort mSort;

    public TermVariable[] getVariables() {
        return this.mVariables;
    }

    public Term[] getValues() {
        return this.mValues;
    }

    public Term getSubTerm() {
        return this.mSubterm;
    }

    LetTerm(TermVariable[] vars, Term[] vals, Term t, int hash) {
        super(hash);
        this.mVariables = vars;
        this.mValues = vals;
        this.mSubterm = t;
        this.mSort = t.getSort();
    }

    @Override
    public Sort getSort() {
        return this.mSort;
    }

    public static final int hashLet(TermVariable[] vars, Term[] values, Term subform) {
        return HashUtils.hashJenkins((int)HashUtils.hashJenkins((int)subform.hashCode(), (Object[])values), (Object[])vars);
    }

    @Override
    public void toStringHelper(ArrayDeque<Object> mTodo) {
        mTodo.addLast(")");
        mTodo.addLast(this.getSubTerm());
        mTodo.addLast(")) ");
        TermVariable[] vars = this.getVariables();
        Term[] values = this.getValues();
        int i = values.length - 1;
        while (i > 0) {
            mTodo.addLast(values[i]);
            mTodo.addLast(") (" + vars[i].toString() + " ");
            --i;
        }
        mTodo.addLast(values[0]);
        mTodo.addLast("(let ((" + vars[0].toString() + " ");
    }
}

