/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.Assignments;
import de.uni_freiburg.informatik.ultimate.logic.DataType;
import de.uni_freiburg.informatik.ultimate.logic.FormulaLet;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.logic.Model;
import de.uni_freiburg.informatik.ultimate.logic.NoopScript;
import de.uni_freiburg.informatik.ultimate.logic.PrintTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.WrapperScript;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Map;
import java.util.zip.GZIPOutputStream;

public class LoggingScript
extends WrapperScript {
    private final PrintWriter mPw;
    private final PrintTerm mTermPrinter = new PrintTerm();
    private final FormulaLet mLetter;

    public LoggingScript(String file, boolean autoFlush) throws IOException {
        this(new NoopScript(), file, autoFlush);
    }

    public LoggingScript(String file, boolean autoFlush, boolean useCSE) throws IOException {
        this(new NoopScript(), file, autoFlush, useCSE);
    }

    public LoggingScript(Script script, String file, boolean autoFlush) throws IOException {
        this(script, file, autoFlush, false);
    }

    public LoggingScript(Script script, String file, boolean autoFlush, boolean useCSE) throws IOException {
        super(script);
        OutputStream out;
        if (file.equals("<stdout>")) {
            out = System.out;
        } else if (file.equals("<stderr>")) {
            out = System.err;
        } else {
            out = new FileOutputStream(file);
            if (file.endsWith(".gz")) {
                out = new GZIPOutputStream(out);
            }
        }
        this.mPw = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(out)), autoFlush);
        this.mLetter = useCSE ? new FormulaLet() : null;
    }

    private final Term formatTerm(Term input) {
        return this.mLetter == null ? input : new FormulaLet().let(input);
    }

    @Override
    public void setLogic(String logic) throws UnsupportedOperationException, SMTLIBException {
        this.mPw.println("(set-logic " + logic + ")");
        super.setLogic(logic);
    }

    @Override
    public void setLogic(Logics logic) throws UnsupportedOperationException, SMTLIBException {
        this.mPw.println("(set-logic " + logic.name() + ")");
        super.setLogic(logic);
    }

    @Override
    public void setOption(String opt, Object value) throws UnsupportedOperationException, SMTLIBException {
        this.mPw.print("(set-option ");
        this.mPw.print(opt);
        this.mPw.print(' ');
        this.mPw.print(PrintTerm.quoteObjectIfString(value));
        this.mPw.println(")");
        super.setOption(opt, value);
    }

    @Override
    public void setInfo(String info, Object value) {
        this.mPw.print("(set-info ");
        this.mPw.print(info);
        this.mPw.print(' ');
        this.mPw.print(PrintTerm.quoteObjectIfString(value));
        this.mPw.println(")");
        super.setInfo(info, value);
    }

    @Override
    public FunctionSymbol getFunctionSymbol(String constructor) {
        return this.mScript.getFunctionSymbol(constructor);
    }

    @Override
    public void declareSort(String sort, int arity) throws SMTLIBException {
        this.mPw.print("(declare-sort ");
        this.mPw.print(PrintTerm.quoteIdentifier(sort));
        this.mPw.print(' ');
        this.mPw.print(arity);
        this.mPw.println(")");
        super.declareSort(sort, arity);
    }

    @Override
    public void defineSort(String sort, Sort[] sortParams, Sort definition) throws SMTLIBException {
        this.mPw.print("(define-sort ");
        this.mPw.print(PrintTerm.quoteIdentifier(sort));
        this.mPw.print(" (");
        String sep = "";
        Sort[] sortArray = sortParams;
        int n = sortParams.length;
        int n2 = 0;
        while (n2 < n) {
            Sort p = sortArray[n2];
            this.mPw.print(sep);
            this.mTermPrinter.append((Appendable)this.mPw, p);
            sep = " ";
            ++n2;
        }
        this.mPw.print(") ");
        this.mTermPrinter.append((Appendable)this.mPw, definition);
        this.mPw.println(")");
        super.defineSort(sort, sortParams, definition);
    }

    @Override
    public void declareDatatype(DataType datatype, DataType.Constructor[] constrs) throws SMTLIBException {
        assert (datatype.mNumParams == 0);
        this.mPw.print("(declare-datatype ");
        this.mPw.print(PrintTerm.quoteIdentifier(datatype.getName()));
        this.mPw.print(" (");
        int j = 0;
        while (j < constrs.length) {
            this.mPw.print("(");
            this.mPw.print(PrintTerm.quoteIdentifier(constrs[j].getName()));
            int k = 0;
            while (k < constrs[j].getArgumentSorts().length) {
                this.mPw.print(" ");
                this.mPw.print("(");
                this.mPw.print(PrintTerm.quoteIdentifier(constrs[j].getSelectors()[k]));
                this.mPw.print(" ");
                this.mPw.print(constrs[j].getArgumentSorts()[k]);
                this.mPw.print(")");
                ++k;
            }
            this.mPw.print(j != constrs.length - 1 ? ") " : ")");
            ++j;
        }
        this.mPw.println("))");
        super.declareDatatype(datatype, constrs);
    }

    @Override
    public void declareDatatypes(DataType[] datatypes, DataType.Constructor[][] constrs, Sort[][] sortParams) throws SMTLIBException {
        assert (datatypes.length == constrs.length && datatypes.length == sortParams.length);
        this.mPw.print("(declare-datatypes (");
        String sep1 = "";
        DataType[] dataTypeArray = datatypes;
        int n = datatypes.length;
        int n2 = 0;
        while (n2 < n) {
            DataType datatype = dataTypeArray[n2];
            this.mPw.print(sep1);
            sep1 = " ";
            this.mPw.print("(");
            this.mPw.print(PrintTerm.quoteIdentifier(datatype.getName()));
            this.mPw.print(" ");
            this.mPw.print(datatype.mNumParams);
            this.mPw.print(")");
            ++n2;
        }
        this.mPw.print(") (");
        String sep2 = "";
        int i = 0;
        while (i < constrs.length) {
            int n3;
            int n4;
            Object[] objectArray;
            this.mPw.print(sep2);
            sep2 = " ";
            if (sortParams[i] != null) {
                this.mPw.print("(par (");
                String sep3 = "";
                objectArray = sortParams[i];
                n4 = objectArray.length;
                n3 = 0;
                while (n3 < n4) {
                    Object param = objectArray[n3];
                    this.mPw.print(sep3);
                    sep3 = " ";
                    this.mPw.print(param);
                    ++n3;
                }
                this.mPw.print(") ");
            }
            this.mPw.print("(");
            String sep4 = "";
            objectArray = constrs[i];
            n4 = objectArray.length;
            n3 = 0;
            while (n3 < n4) {
                Object constructor = objectArray[n3];
                this.mPw.print(sep4);
                sep4 = " ";
                this.mPw.print("(");
                this.mPw.print(PrintTerm.quoteIdentifier(((DataType.Constructor)constructor).getName()));
                int j = 0;
                while (j < ((DataType.Constructor)constructor).getArgumentSorts().length) {
                    this.mPw.print(" ");
                    this.mPw.print("(");
                    this.mPw.print(PrintTerm.quoteIdentifier(((DataType.Constructor)constructor).getSelectors()[j]));
                    this.mPw.print(" ");
                    this.mPw.print(((DataType.Constructor)constructor).getArgumentSorts()[j]);
                    this.mPw.print(")");
                    ++j;
                }
                this.mPw.print(")");
                ++n3;
            }
            this.mPw.print(")");
            if (sortParams[i] != null) {
                this.mPw.print(")");
            }
            ++i;
        }
        this.mPw.println("))");
        super.declareDatatypes(datatypes, constrs, sortParams);
    }

    @Override
    public void declareFun(String fun, Sort[] paramSorts, Sort resultSort) throws SMTLIBException {
        this.mPw.print("(declare-fun ");
        this.mPw.print(PrintTerm.quoteIdentifier(fun));
        this.mPw.print(" (");
        String sep = "";
        Sort[] sortArray = paramSorts;
        int n = paramSorts.length;
        int n2 = 0;
        while (n2 < n) {
            Sort p = sortArray[n2];
            this.mPw.print(sep);
            this.mTermPrinter.append((Appendable)this.mPw, p);
            sep = " ";
            ++n2;
        }
        this.mPw.print(") ");
        this.mTermPrinter.append((Appendable)this.mPw, resultSort);
        this.mPw.println(")");
        super.declareFun(fun, paramSorts, resultSort);
    }

    @Override
    public void defineFun(String fun, TermVariable[] params, Sort resultSort, Term definition) throws SMTLIBException {
        this.mPw.print("(define-fun ");
        this.mPw.print(PrintTerm.quoteIdentifier(fun));
        this.mPw.print(" (");
        String sep = "(";
        TermVariable[] termVariableArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            TermVariable t = termVariableArray[n2];
            this.mPw.print(sep);
            this.mPw.print(t);
            this.mPw.print(' ');
            this.mTermPrinter.append((Appendable)this.mPw, t.getSort());
            this.mPw.print(')');
            sep = " (";
            ++n2;
        }
        this.mPw.print(") ");
        this.mTermPrinter.append((Appendable)this.mPw, resultSort);
        this.mPw.print(' ');
        this.mTermPrinter.append((Appendable)this.mPw, this.formatTerm(definition));
        this.mPw.println(")");
        super.defineFun(fun, params, resultSort, definition);
    }

    @Override
    public void push(int levels) throws SMTLIBException {
        this.mPw.println("(push " + levels + ")");
        super.push(levels);
    }

    @Override
    public void pop(int levels) throws SMTLIBException {
        this.mPw.println("(pop " + levels + ")");
        super.pop(levels);
    }

    @Override
    public Script.LBool assertTerm(Term term) throws SMTLIBException {
        this.mPw.print("(assert ");
        this.mTermPrinter.append((Appendable)this.mPw, this.formatTerm(term));
        this.mPw.println(")");
        return super.assertTerm(term);
    }

    @Override
    public Script.LBool checkSat() throws SMTLIBException {
        this.mPw.println("(check-sat)");
        return super.checkSat();
    }

    @Override
    public Script.LBool checkSatAssuming(Term ... assumptions) throws SMTLIBException {
        this.mPw.print("(check-sat-assuming (");
        String sep = "";
        Term[] termArray = assumptions;
        int n = assumptions.length;
        int n2 = 0;
        while (n2 < n) {
            Term t = termArray[n2];
            this.mPw.print(sep);
            this.mTermPrinter.append((Appendable)this.mPw, this.formatTerm(t));
            sep = " ";
            ++n2;
        }
        this.mPw.println("))");
        return super.checkSatAssuming(assumptions);
    }

    @Override
    public Term[] getAssertions() throws SMTLIBException {
        this.mPw.println("(get-assertions)");
        return super.getAssertions();
    }

    @Override
    public Term getProof() throws SMTLIBException, UnsupportedOperationException {
        this.mPw.println("(get-proof)");
        return super.getProof();
    }

    @Override
    public Term[] getUnsatCore() throws SMTLIBException, UnsupportedOperationException {
        this.mPw.println("(get-unsat-core)");
        return super.getUnsatCore();
    }

    @Override
    public Map<Term, Term> getValue(Term[] terms) throws SMTLIBException, UnsupportedOperationException {
        this.mPw.print("(get-value (");
        String sep = "";
        Term[] termArray = terms;
        int n = terms.length;
        int n2 = 0;
        while (n2 < n) {
            Term t = termArray[n2];
            this.mPw.print(sep);
            this.mTermPrinter.append((Appendable)this.mPw, this.formatTerm(t));
            sep = " ";
            ++n2;
        }
        this.mPw.println("))");
        return super.getValue(terms);
    }

    @Override
    public Assignments getAssignment() throws SMTLIBException, UnsupportedOperationException {
        this.mPw.println("(get-assignment)");
        return super.getAssignment();
    }

    @Override
    public Object getOption(String opt) throws UnsupportedOperationException {
        this.mPw.println("(get-option " + opt + ")");
        return super.getOption(opt);
    }

    @Override
    public Object getInfo(String info) throws UnsupportedOperationException {
        this.mPw.println("(get-info " + info + ")");
        return super.getInfo(info);
    }

    @Override
    public Term simplify(Term term) throws SMTLIBException {
        this.mPw.print("(simplify ");
        this.mTermPrinter.append((Appendable)this.mPw, term);
        this.mPw.println(")");
        return super.simplify(term);
    }

    @Override
    public void reset() {
        this.mPw.println("(reset)");
        super.reset();
    }

    @Override
    public Term[] getInterpolants(Term[] partition) throws SMTLIBException, UnsupportedOperationException {
        this.mPw.print("(get-interpolants");
        Term[] termArray = partition;
        int n = partition.length;
        int n2 = 0;
        while (n2 < n) {
            Term t = termArray[n2];
            this.mPw.print(' ');
            this.mTermPrinter.append((Appendable)this.mPw, t);
            ++n2;
        }
        this.mPw.println(')');
        return super.getInterpolants(partition);
    }

    private void printInterpolantQuery(Term[] partition, int[] startOfSubtree) {
        this.mTermPrinter.append((Appendable)this.mPw, partition[0]);
        int i = 1;
        while (i < partition.length) {
            int prevStart = startOfSubtree[i - 1];
            while (startOfSubtree[i] < prevStart) {
                this.mPw.print(')');
                prevStart = startOfSubtree[prevStart - 1];
            }
            this.mPw.print(' ');
            if (startOfSubtree[i] == i) {
                this.mPw.print('(');
            }
            this.mTermPrinter.append((Appendable)this.mPw, partition[i]);
            ++i;
        }
    }

    @Override
    public Term[] getInterpolants(Term[] partition, int[] startOfSubtree) throws SMTLIBException, UnsupportedOperationException {
        this.mPw.print("(get-interpolants ");
        this.printInterpolantQuery(partition, startOfSubtree);
        this.mPw.println(')');
        return super.getInterpolants(partition, startOfSubtree);
    }

    @Override
    public Term[] getInterpolants(Term[] partition, int[] startOfSubtree, Term proofTree) throws SMTLIBException, UnsupportedOperationException {
        this.mPw.print("(get-interpolants ");
        this.printInterpolantQuery(partition, startOfSubtree);
        this.mPw.print(" :proof ");
        this.mTermPrinter.append((Appendable)this.mPw, proofTree);
        this.mPw.println(')');
        return super.getInterpolants(partition, startOfSubtree);
    }

    @Override
    public void exit() {
        this.mPw.println("(exit)");
        this.mPw.flush();
        this.mPw.close();
        super.exit();
    }

    @Override
    public Model getModel() throws SMTLIBException, UnsupportedOperationException {
        this.mPw.println("(get-model)");
        return super.getModel();
    }

    @Override
    public Iterable<Term[]> checkAllsat(Term[] predicates) throws SMTLIBException, UnsupportedOperationException {
        PrintTerm pt = new PrintTerm();
        this.mPw.print("(check-allsat (");
        String spacer = "";
        Term[] termArray = predicates;
        int n = predicates.length;
        int n2 = 0;
        while (n2 < n) {
            Term p = termArray[n2];
            this.mPw.print(spacer);
            pt.append((Appendable)this.mPw, p);
            spacer = " ";
            ++n2;
        }
        this.mPw.println("))");
        return super.checkAllsat(predicates);
    }

    @Override
    public Term[] findImpliedEquality(Term[] x, Term[] y) {
        Term p;
        PrintTerm pt = new PrintTerm();
        this.mPw.print("(find-implied-equality (");
        String spacer = "";
        Term[] termArray = x;
        int n = x.length;
        int n2 = 0;
        while (n2 < n) {
            p = termArray[n2];
            this.mPw.print(spacer);
            pt.append((Appendable)this.mPw, p);
            spacer = " ";
            ++n2;
        }
        this.mPw.print(") (");
        spacer = "";
        termArray = x;
        n = x.length;
        n2 = 0;
        while (n2 < n) {
            p = termArray[n2];
            this.mPw.print(spacer);
            pt.append((Appendable)this.mPw, p);
            spacer = " ";
            ++n2;
        }
        this.mPw.println("))");
        return super.findImpliedEquality(x, y);
    }

    @Override
    public QuotedObject echo(QuotedObject msg) {
        this.mPw.print("(echo ");
        this.mPw.print(msg);
        this.mPw.println(')');
        return super.echo(msg);
    }

    public void comment(String comment) {
        this.mPw.print("; ");
        this.mPw.println(comment);
    }

    @Override
    public void resetAssertions() {
        this.mPw.println("(reset-assertions)");
        super.resetAssertions();
    }

    @Override
    public Term[] getUnsatAssumptions() throws SMTLIBException, UnsupportedOperationException {
        this.mPw.println("(get-unsat-assumptions)");
        return super.getUnsatAssumptions();
    }
}

