/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.LambdaTerm;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.MatchTerm;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;

public class OccurrenceCounter
extends NonRecursive {
    public void count(Term t) {
        this.run(new CountWalker(t));
    }

    public void reset(Term t) {
        this.run(new ResetWalker(t));
    }

    private static class CountWalker
    extends NonRecursive.TermWalker {
        public CountWalker(Term term) {
            super(term);
        }

        @Override
        public void walk(NonRecursive walker, ConstantTerm term) {
        }

        @Override
        public void walk(NonRecursive walker, AnnotatedTerm term) {
            walker.enqueueWalker(new CountWalker(term.getSubterm()));
        }

        @Override
        public void walk(NonRecursive walker, ApplicationTerm term) {
            OccurrenceCounter occ = (OccurrenceCounter)walker;
            if (++term.mTmpCtr == 1) {
                Term[] termArray = term.getParameters();
                int n = termArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Term t = termArray[n2];
                    occ.enqueueWalker(new CountWalker(t));
                    ++n2;
                }
            }
        }

        @Override
        public void walk(NonRecursive walker, LetTerm term) {
            throw new InternalError("Term should be unletted before counting");
        }

        @Override
        public void walk(NonRecursive walker, QuantifiedFormula term) {
            OccurrenceCounter occ = (OccurrenceCounter)walker;
            if (++term.mTmpCtr == 1) {
                occ.enqueueWalker(new CountWalker(term.getSubformula()));
            }
        }

        @Override
        public void walk(NonRecursive walker, LambdaTerm term) {
            OccurrenceCounter occ = (OccurrenceCounter)walker;
            if (++term.mTmpCtr == 1) {
                occ.enqueueWalker(new CountWalker(term.getSubterm()));
            }
        }

        @Override
        public void walk(NonRecursive walker, TermVariable term) {
            ++term.mTmpCtr;
        }

        @Override
        public void walk(NonRecursive walker, MatchTerm term) {
            OccurrenceCounter occ = (OccurrenceCounter)walker;
            if (++term.mTmpCtr == 1) {
                occ.enqueueWalker(new CountWalker(term.getDataTerm()));
                Term[] termArray = term.getCases();
                int n = termArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Term t = termArray[n2];
                    occ.enqueueWalker(new CountWalker(t));
                    ++n2;
                }
            }
        }
    }

    private static class ResetWalker
    extends NonRecursive.TermWalker {
        public ResetWalker(Term term) {
            super(term);
        }

        @Override
        public void walk(NonRecursive walker, ConstantTerm term) {
        }

        @Override
        public void walk(NonRecursive walker, AnnotatedTerm term) {
            walker.enqueueWalker(new ResetWalker(term.getSubterm()));
        }

        @Override
        public void walk(NonRecursive walker, ApplicationTerm term) {
            OccurrenceCounter occ = (OccurrenceCounter)walker;
            if (term.mTmpCtr != 0) {
                Term[] termArray = term.getParameters();
                int n = termArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Term t = termArray[n2];
                    occ.enqueueWalker(new ResetWalker(t));
                    ++n2;
                }
                term.mTmpCtr = 0;
            }
        }

        @Override
        public void walk(NonRecursive walker, LetTerm term) {
            throw new InternalError("Term should be unletted before counting");
        }

        @Override
        public void walk(NonRecursive walker, LambdaTerm term) {
            OccurrenceCounter occ = (OccurrenceCounter)walker;
            if (term.mTmpCtr != 0) {
                occ.enqueueWalker(new ResetWalker(term.getSubterm()));
                term.mTmpCtr = 0;
            }
        }

        @Override
        public void walk(NonRecursive walker, QuantifiedFormula term) {
            OccurrenceCounter occ = (OccurrenceCounter)walker;
            if (term.mTmpCtr != 0) {
                occ.enqueueWalker(new ResetWalker(term.getSubformula()));
                term.mTmpCtr = 0;
            }
        }

        @Override
        public void walk(NonRecursive walker, TermVariable term) {
            term.mTmpCtr = 0;
        }

        @Override
        public void walk(NonRecursive walker, MatchTerm term) {
            OccurrenceCounter occ = (OccurrenceCounter)walker;
            if (term.mTmpCtr != 0) {
                occ.enqueueWalker(new ResetWalker(term.getDataTerm()));
                Term[] termArray = term.getCases();
                int n = termArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Term t = termArray[n2];
                    occ.enqueueWalker(new ResetWalker(t));
                    ++n2;
                }
            }
            term.mTmpCtr = 0;
        }
    }
}

