/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.io.IOException;
import java.util.ArrayDeque;

public class PrintTerm {
    protected final ArrayDeque<Object> mTodo = new ArrayDeque();

    public void append(Appendable appender, Term term) {
        try {
            this.mTodo.add(term);
            this.run(appender);
        }
        catch (IOException ex) {
            throw new RuntimeException("Appender throws IOException", ex);
        }
    }

    public void append(Appendable appender, Sort sort) {
        try {
            this.mTodo.add(sort);
            this.run(appender);
        }
        catch (IOException ex) {
            throw new RuntimeException("Appender throws IOException", ex);
        }
    }

    public void append(Appendable appender, Object[] sexpr) {
        try {
            this.mTodo.add(sexpr);
            this.run(appender);
        }
        catch (IOException ex) {
            throw new RuntimeException("Appender throws IOException", ex);
        }
    }

    public static String quoteIdentifier(String id) {
        assert (id.indexOf(124) < 0 && id.indexOf(92) < 0);
        int idx = 0;
        while (idx < id.length()) {
            char c = id.charAt(idx);
            if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' && idx > 0 || "~!@$%^&*_+-=<>.?/".indexOf(c) >= 0)) {
                return "|" + id + "|";
            }
            ++idx;
        }
        return id;
    }

    public static Object quoteObjectIfString(Object value) {
        if (value instanceof String) {
            return PrintTerm.quoteIdentifier((String)value);
        }
        return value;
    }

    protected void walkTerm(Term term) {
        term.toStringHelper(this.mTodo);
    }

    protected void walkSort(Sort sort) {
        sort.toStringHelper(this.mTodo);
    }

    private void run(Appendable appender) throws IOException {
        while (!this.mTodo.isEmpty()) {
            Object next = this.mTodo.removeLast();
            if (next instanceof Term) {
                this.walkTerm((Term)next);
                continue;
            }
            if (next instanceof Sort) {
                this.walkSort((Sort)next);
                continue;
            }
            if (next instanceof Object[]) {
                Object[] arr = (Object[])next;
                this.mTodo.addLast(")");
                int i = arr.length - 1;
                while (i >= 0) {
                    this.mTodo.addLast(arr[i]);
                    if (i > 0) {
                        this.mTodo.addLast(" ");
                    }
                    --i;
                }
                appender.append('(');
                continue;
            }
            appender.append(next.toString());
        }
    }

    public String toString() {
        return "[PrintTerm: " + this.mTodo + "]";
    }
}

