/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.HashUtils;
import java.util.ArrayDeque;

public class QuantifiedFormula
extends Term {
    public static final int EXISTS = 0;
    public static final int FORALL = 1;
    private final int mQuantifier;
    private final TermVariable[] mVariables;
    private final Term mSubFormula;

    QuantifiedFormula(int quant, TermVariable[] vars, Term f, int hash) {
        super(hash);
        this.mQuantifier = quant;
        this.mVariables = vars;
        this.mSubFormula = f;
    }

    public int getQuantifier() {
        return this.mQuantifier;
    }

    public TermVariable[] getVariables() {
        return this.mVariables;
    }

    public Term getSubformula() {
        return this.mSubFormula;
    }

    @Override
    public Sort getSort() {
        return this.mSubFormula.getSort();
    }

    public static final int hashQuantifier(int quant, TermVariable[] vars, Term f) {
        return HashUtils.hashJenkins((int)(f.hashCode() ^ quant), (Object[])vars);
    }

    @Override
    public void toStringHelper(ArrayDeque<Object> mTodo) {
        mTodo.addLast(")");
        mTodo.addLast(this.getSubformula());
        mTodo.addLast(")) ");
        TermVariable[] vars = this.getVariables();
        int i = vars.length - 1;
        while (i > 0) {
            mTodo.addLast(vars[i].getSort());
            mTodo.addLast(") (" + vars[i] + " ");
            --i;
        }
        mTodo.addLast(vars[0].getSort());
        mTodo.addLast("(" + (this.getQuantifier() == 0 ? "exists" : "forall") + " ((" + vars[0] + " ");
    }
}

