/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.MutableRational;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.HashUtils;
import java.math.BigInteger;

public class Rational
implements Comparable<Rational> {
    int mNum;
    int mDenom;
    public static final Rational POSITIVE_INFINITY = new Rational(1, 0);
    public static final Rational NAN = new Rational(0, 0);
    public static final Rational NEGATIVE_INFINITY = new Rational(-1, 0);
    public static final Rational ZERO = new Rational(0, 1);
    public static final Rational ONE = new Rational(1, 1);
    public static final Rational MONE = new Rational(-1, 1);
    public static final Rational TWO = new Rational(2, 1);

    private Rational(int num, int denom) {
        this.mNum = num;
        this.mDenom = denom;
    }

    public static Rational valueOf(BigInteger bignum, BigInteger bigdenom) {
        BigInteger norm;
        int cp = bigdenom.signum();
        if (cp < 0) {
            bignum = bignum.negate();
            bigdenom = bigdenom.negate();
        } else if (cp == 0) {
            return Rational.valueOf(bignum.signum(), 0L);
        }
        if (!bigdenom.equals(BigInteger.ONE) && !(norm = Rational.gcd(bignum, bigdenom).abs()).equals(BigInteger.ONE)) {
            bignum = bignum.divide(norm);
            bigdenom = bigdenom.divide(norm);
        }
        if (bigdenom.bitLength() < 32 && bignum.bitLength() < 32) {
            return Rational.valueOf(bignum.intValue(), bigdenom.intValue());
        }
        return new BigRational(bignum, bigdenom);
    }

    public static Rational valueOf(long newnum, long newdenom) {
        if (newdenom != 1L) {
            long gcd2 = Math.abs(Rational.gcd(newnum, newdenom));
            if (gcd2 == 0L) {
                return NAN;
            }
            if (newdenom < 0L) {
                gcd2 = -gcd2;
            }
            newnum /= gcd2;
            newdenom /= gcd2;
        }
        if (newdenom == 1L) {
            if (newnum == 0L) {
                return ZERO;
            }
            if (newnum == 1L) {
                return ONE;
            }
            if (newnum == -1L) {
                return MONE;
            }
        } else if (newdenom == 0L) {
            if (newnum == 1L) {
                return POSITIVE_INFINITY;
            }
            return NEGATIVE_INFINITY;
        }
        if (Integer.MIN_VALUE <= newnum && newnum <= Integer.MAX_VALUE && newdenom <= Integer.MAX_VALUE) {
            return new Rational((int)newnum, (int)newdenom);
        }
        return new BigRational(BigInteger.valueOf(newnum), BigInteger.valueOf(newdenom));
    }

    public static int gcd(int a, int b) {
        while (b != 0) {
            int t = a % b;
            a = b;
            b = t;
        }
        return a;
    }

    public static long gcd(long a, long b) {
        if (a < 0L) {
            a = -a;
        }
        if (b < 0L) {
            b = -b;
        }
        if (a == 0L || b == 1L) {
            return b;
        }
        if (b == 0L || a == 1L) {
            return a;
        }
        int ashift = Long.numberOfTrailingZeros(a);
        int bshift = Long.numberOfTrailingZeros(b);
        a >>= ashift;
        b >>= bshift;
        while (a != b) {
            long t;
            if (a < b) {
                t = b - a;
                b = a;
            } else {
                if (b == 1L) {
                    a = b;
                    break;
                }
                t = a - b;
            }
            while (((int)(t >>= 1) & 1) == 0) {
            }
            a = t;
        }
        return a << Math.min(ashift, bshift);
    }

    public static BigInteger gcd(BigInteger i1, BigInteger i2) {
        if (i1 == BigInteger.ONE || i2 == BigInteger.ONE) {
            return BigInteger.ONE;
        }
        int l1 = i1.bitLength();
        int l2 = i2.bitLength();
        if (l1 < 31 && l2 < 31) {
            return BigInteger.valueOf(Rational.gcd(i1.intValue(), i2.intValue()));
        }
        if (l1 < 63 && l2 < 63) {
            return BigInteger.valueOf(Rational.gcd(i1.longValue(), i2.longValue()));
        }
        return i1.gcd(i2);
    }

    public Rational add(Rational other) {
        if (other == ZERO) {
            return this;
        }
        if (this == ZERO) {
            return other;
        }
        if (other instanceof BigRational) {
            return other.add(this);
        }
        if (this.mDenom == other.mDenom) {
            if (this.mDenom == 0) {
                return this.mNum == other.mNum ? this : NAN;
            }
            return Rational.valueOf((long)this.mNum + (long)other.mNum, this.mDenom);
        }
        int gcd = Rational.gcd(this.mDenom, other.mDenom);
        long denomgcd = this.mDenom / gcd;
        long otherdenomgcd = other.mDenom / gcd;
        long newdenom = denomgcd * (long)other.mDenom;
        long newnum = otherdenomgcd * (long)this.mNum + denomgcd * (long)other.mNum;
        return Rational.valueOf(newnum, newdenom);
    }

    public Rational addmul(Rational fac1, Rational fac2) {
        return this.add(fac1.mul(fac2));
    }

    public Rational subdiv(Rational s, Rational d) {
        return this.sub(s).div(d);
    }

    public Rational negate() {
        return Rational.valueOf(-((long)this.mNum), this.mDenom);
    }

    public Rational sub(Rational other) {
        return this.add(other.negate());
    }

    public Rational mul(Rational other) {
        if (other == ONE) {
            return this;
        }
        if (this == ONE) {
            return other;
        }
        if (other == MONE) {
            return this.negate();
        }
        if (this == MONE) {
            return other.negate();
        }
        if (other instanceof BigRational) {
            return other.mul(this);
        }
        long newnum = (long)this.mNum * (long)other.mNum;
        long newdenom = (long)this.mDenom * (long)other.mDenom;
        return Rational.valueOf(newnum, newdenom);
    }

    public Rational mul(BigInteger other) {
        if (other.bitLength() < 32) {
            int oint = other.intValue();
            if (oint == 1) {
                return this;
            }
            if (oint == -1) {
                return this.negate();
            }
            long newnum = (long)this.mNum * (long)oint;
            return Rational.valueOf(newnum, this.mDenom);
        }
        if (this == ONE) {
            return Rational.valueOf(other, BigInteger.ONE);
        }
        if (this == MONE) {
            return Rational.valueOf(other.negate(), BigInteger.ONE);
        }
        return Rational.valueOf(this.numerator().multiply(other), this.denominator());
    }

    public Rational div(Rational other) {
        if (other == ONE) {
            return this;
        }
        if (other == MONE) {
            return this.negate();
        }
        if (other instanceof BigRational) {
            return ((BigRational)other).idiv(this);
        }
        long newnum = (long)this.mNum * (long)other.mDenom;
        long newdenom = (long)this.mDenom * (long)other.mNum;
        if (newdenom == 0L && other.mNum < 0) {
            newnum = -newnum;
        }
        return Rational.valueOf(newnum, newdenom);
    }

    public Rational gcd(Rational other) {
        if (this == ZERO) {
            return other;
        }
        if (other == ZERO) {
            return this;
        }
        if (other instanceof BigRational) {
            return other.gcd(this);
        }
        int gcddenom = Rational.gcd(this.mDenom, other.mDenom);
        long denom = (long)(this.mDenom / gcddenom) * (long)other.mDenom;
        long num = Rational.gcd(this.mNum < 0 ? -this.mNum : this.mNum, other.mNum < 0 ? -other.mNum : other.mNum);
        return Rational.valueOf(num, denom);
    }

    public Rational inverse() {
        return Rational.valueOf(this.mDenom, this.mNum);
    }

    public boolean isNegative() {
        return this.mNum < 0;
    }

    public int signum() {
        return this.mNum < 0 ? -1 : (this.mNum == 0 ? 0 : 1);
    }

    @Override
    public int compareTo(Rational o) {
        if (o instanceof BigRational) {
            return -o.compareTo(this);
        }
        if (o.mDenom == this.mDenom) {
            return this.mNum < o.mNum ? -1 : (this.mNum == o.mNum ? 0 : 1);
        }
        long valt = (long)this.mNum * (long)o.mDenom;
        long valo = (long)o.mNum * (long)this.mDenom;
        return valt < valo ? -1 : (valt == valo ? 0 : 1);
    }

    public boolean equals(Object o) {
        if (o instanceof Rational) {
            if (o instanceof BigRational) {
                return false;
            }
            Rational r = (Rational)o;
            return this.mNum == r.mNum && this.mDenom == r.mDenom;
        }
        if (o instanceof MutableRational) {
            return ((MutableRational)o).equals(this);
        }
        return false;
    }

    public BigInteger numerator() {
        return BigInteger.valueOf(this.mNum);
    }

    public BigInteger denominator() {
        return BigInteger.valueOf(this.mDenom);
    }

    public int hashCode() {
        return HashUtils.hashJenkins((int)this.mNum, (Object)this.mDenom);
    }

    public String toString() {
        if (this.mDenom == 0) {
            return this.mNum > 0 ? "inf" : (this.mNum == 0 ? "nan" : "-inf");
        }
        if (this.mDenom == 1) {
            return String.valueOf(this.mNum);
        }
        return String.valueOf(this.mNum) + "/" + this.mDenom;
    }

    public boolean isIntegral() {
        return this.mDenom <= 1;
    }

    public Rational floor() {
        if (this.mDenom <= 1) {
            return this;
        }
        int div = this.mNum / this.mDenom;
        if (this.mNum < 0) {
            --div;
        }
        return Rational.valueOf(div, 1L);
    }

    public Rational frac() {
        if (this.mDenom <= 1) {
            return ZERO;
        }
        int newnum = this.mNum % this.mDenom;
        if (newnum < 0) {
            newnum += this.mDenom;
        }
        return Rational.valueOf(newnum, this.mDenom);
    }

    public Rational ceil() {
        if (this.mDenom <= 1) {
            return this;
        }
        int div = this.mNum / this.mDenom;
        if (this.mNum > 0) {
            ++div;
        }
        return Rational.valueOf(div, 1L);
    }

    public Rational abs() {
        return Rational.valueOf(Math.abs((long)this.mNum), this.mDenom);
    }

    public Term toTerm(Sort sort) {
        return sort.getTheory().constant(this, sort);
    }

    public boolean isRational() {
        return this.mDenom != 0;
    }

    static class BigRational
    extends Rational {
        BigInteger mBignum;
        BigInteger mBigdenom;

        private BigRational(BigInteger nom, BigInteger denom) {
            super(nom.signum(), 1);
            this.mBignum = nom;
            this.mBigdenom = denom;
        }

        @Override
        public Rational add(Rational other) {
            BigInteger odenom;
            if (other == ZERO) {
                return this;
            }
            BigInteger tdenom = this.denominator();
            if (tdenom.equals(odenom = other.denominator())) {
                return BigRational.valueOf(this.numerator().add(other.numerator()), tdenom);
            }
            BigInteger gcd = tdenom.gcd(odenom);
            BigInteger tdenomgcd = tdenom.divide(gcd);
            BigInteger odenomgcd = odenom.divide(gcd);
            BigInteger newnum = this.numerator().multiply(odenomgcd).add(other.numerator().multiply(tdenomgcd));
            BigInteger newdenom = tdenom.multiply(odenomgcd);
            return BigRational.valueOf(newnum, newdenom);
        }

        @Override
        public Rational negate() {
            return Rational.valueOf(this.mBignum.negate(), this.mBigdenom);
        }

        @Override
        public Rational mul(Rational other) {
            if (other == ONE) {
                return this;
            }
            if (other == ZERO) {
                return other;
            }
            if (other == MONE) {
                return this.negate();
            }
            BigInteger newnum = this.numerator().multiply(other.numerator());
            BigInteger newdenom = this.denominator().multiply(other.denominator());
            return BigRational.valueOf(newnum, newdenom);
        }

        @Override
        public Rational mul(BigInteger other) {
            if (other.bitLength() < 2) {
                int oint = other.intValue();
                if (oint == 1) {
                    return this;
                }
                if (oint == -1) {
                    return this.negate();
                }
                if (oint == 0) {
                    return ZERO;
                }
            }
            return BigRational.valueOf(this.numerator().multiply(other), this.denominator());
        }

        @Override
        public Rational div(Rational other) {
            if (other == ONE) {
                return this;
            }
            if (other == MONE) {
                return this.negate();
            }
            BigInteger denom = this.denominator().multiply(other.numerator());
            BigInteger nom = this.numerator().multiply(other.denominator());
            if (denom.equals(BigInteger.ZERO) && other.numerator().signum() == -1) {
                nom = nom.negate();
            }
            return BigRational.valueOf(nom, denom);
        }

        public Rational idiv(Rational other) {
            BigInteger num = this.denominator().multiply(other.numerator());
            BigInteger denom = this.numerator().multiply(other.denominator());
            if (denom.equals(BigInteger.ZERO) && this.numerator().signum() == -1) {
                num = num.negate();
            }
            return BigRational.valueOf(num, denom);
        }

        @Override
        public Rational inverse() {
            return BigRational.valueOf(this.mBigdenom, this.mBignum);
        }

        @Override
        public Rational gcd(Rational other) {
            if (other == ZERO) {
                return this;
            }
            BigInteger tdenom = this.denominator();
            BigInteger odenom = other.denominator();
            BigInteger gcddenom = tdenom.gcd(odenom);
            BigInteger denom = tdenom.divide(gcddenom).multiply(odenom);
            BigInteger num = this.numerator().gcd(other.numerator());
            return Rational.valueOf(num, denom);
        }

        @Override
        public int compareTo(Rational o) {
            BigInteger valthis = this.numerator().multiply(o.denominator());
            BigInteger valo = o.numerator().multiply(this.denominator());
            return valthis.compareTo(valo);
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof BigRational) {
                BigRational r = (BigRational)o;
                return this.mBignum.equals(r.mBignum) && this.mBigdenom.equals(r.mBigdenom);
            }
            if (o instanceof MutableRational) {
                return ((MutableRational)o).equals(this);
            }
            return false;
        }

        @Override
        public BigInteger numerator() {
            return this.mBignum;
        }

        @Override
        public BigInteger denominator() {
            return this.mBigdenom;
        }

        @Override
        public int hashCode() {
            int hashNum = HashUtils.hashJenkins((int)0, (byte[])this.mBignum.toByteArray());
            return HashUtils.hashJenkins((int)hashNum, (byte[])this.mBigdenom.toByteArray());
        }

        @Override
        public String toString() {
            if (this.mBigdenom.equals(BigInteger.ONE)) {
                return this.mBignum.toString();
            }
            return String.valueOf(this.mBignum.toString()) + "/" + this.mBigdenom.toString();
        }

        @Override
        public boolean isIntegral() {
            return this.mBigdenom.equals(BigInteger.ONE);
        }

        @Override
        public Rational floor() {
            if (this.denominator().equals(BigInteger.ONE)) {
                return this;
            }
            BigInteger div = this.numerator().divide(this.denominator());
            if (this.numerator().signum() < 0) {
                div = div.subtract(BigInteger.ONE);
            }
            return Rational.valueOf(div, BigInteger.ONE);
        }

        @Override
        public Rational frac() {
            if (this.mBigdenom.equals(BigInteger.ONE)) {
                return ZERO;
            }
            BigInteger newnum = this.mBignum.mod(this.mBigdenom);
            if (newnum.signum() < 0) {
                newnum = newnum.add(this.mBigdenom);
            }
            return Rational.valueOf(newnum, this.mBigdenom);
        }

        @Override
        public Rational ceil() {
            if (this.denominator().equals(BigInteger.ONE)) {
                return this;
            }
            BigInteger div = this.numerator().divide(this.denominator());
            if (this.numerator().signum() > 0) {
                div = div.add(BigInteger.ONE);
            }
            return Rational.valueOf(div, BigInteger.ONE);
        }

        @Override
        public Rational abs() {
            return BigRational.valueOf(this.mBignum.abs(), this.mBigdenom);
        }
    }
}

