/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.PrintTerm;
import de.uni_freiburg.informatik.ultimate.logic.SortSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.util.HashUtils;
import java.util.ArrayDeque;
import java.util.HashMap;

public final class Sort {
    final SortSymbol mSymbol;
    final Sort[] mArgs;
    final String[] mIndices;
    Sort mRealSort;
    private int mHash;

    Sort(SortSymbol sym, String[] indices, Sort[] args) {
        assert (args != null);
        assert (args.length == (sym.isSortVariable() ? 0 : sym.mNumParams)) : "Sort created with wrong number of args";
        this.mSymbol = sym;
        this.mIndices = indices;
        this.mArgs = args;
        this.mHash = HashUtils.hashJenkins((int)this.mSymbol.hashCode(), (Object[])this.mArgs);
        if (this.mIndices != null) {
            this.mHash = HashUtils.hashJenkins((int)this.mHash, (Object[])this.mIndices);
        }
    }

    public String getName() {
        return this.mSymbol.getName();
    }

    public String getIndexedName() {
        String name = PrintTerm.quoteIdentifier(this.mSymbol.getName());
        if (this.mIndices == null) {
            return name;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("(_ ").append(name);
        String[] stringArray = this.mIndices;
        int n = this.mIndices.length;
        int n2 = 0;
        while (n2 < n) {
            String i = stringArray[n2];
            sb.append(' ').append(i);
            ++n2;
        }
        sb.append(')');
        return sb.toString();
    }

    public SortSymbol getSortSymbol() {
        return this.mSymbol;
    }

    public String[] getIndices() {
        return this.mIndices;
    }

    public Sort[] getArguments() {
        return this.mArgs;
    }

    public Sort getRealSort() {
        if (this.mRealSort == null) {
            if (this.mSymbol.mSortDefinition == null) {
                if (this.mArgs.length == 0) {
                    this.mRealSort = this;
                } else {
                    Sort[] newArgs = this.mArgs;
                    int i = 0;
                    while (i < newArgs.length) {
                        Sort realArg = this.mArgs[i].getRealSort();
                        if (realArg != this.mArgs[i]) {
                            if (newArgs == this.mArgs) {
                                newArgs = (Sort[])this.mArgs.clone();
                            }
                            newArgs[i] = realArg;
                        }
                        ++i;
                    }
                    this.mRealSort = newArgs == this.mArgs ? this : this.mSymbol.getSort(this.mIndices, newArgs).getRealSort();
                }
            } else {
                this.mRealSort = this.mSymbol.mSortDefinition.mapSort(this.mArgs).getRealSort();
            }
        }
        return this.mRealSort;
    }

    boolean equalsSort(Sort other) {
        if (this == other) {
            return true;
        }
        return this.getRealSort() == other.getRealSort();
    }

    boolean unifySort(HashMap<Sort, Sort> unifier, Sort concrete) {
        assert (concrete.getRealSort() == concrete);
        Sort last = unifier.get(this);
        if (last != null) {
            return last == concrete;
        }
        if (!this.mSymbol.isSortVariable()) {
            Sort me = this.getRealSort();
            if (me.mSymbol != concrete.mSymbol) {
                return false;
            }
            int i = 0;
            while (i < me.mArgs.length) {
                if (!me.mArgs[i].unifySort(unifier, concrete.mArgs[i])) {
                    return false;
                }
                ++i;
            }
        }
        unifier.put(this, concrete);
        return true;
    }

    public Sort mapSort(Sort[] substitution) {
        if (this.mSymbol.isSortVariable()) {
            return substitution[this.mSymbol.mNumParams];
        }
        if (this.mArgs.length == 0) {
            return this;
        }
        if (this.mArgs.length == 1) {
            Sort arg = this.mArgs[0].mapSort(substitution);
            return this.mSymbol.getSort(this.mIndices, arg);
        }
        HashMap<Sort, Sort> cachedMappings = new HashMap<Sort, Sort>();
        return this.mapSort(substitution, cachedMappings);
    }

    Sort mapSort(Sort[] substitution, HashMap<Sort, Sort> cachedMappings) {
        if (this.mSymbol.isSortVariable()) {
            return substitution[this.mSymbol.mNumParams];
        }
        Sort result = cachedMappings.get(this);
        if (result != null) {
            return result;
        }
        if (this.mArgs.length == 0) {
            result = this;
        } else {
            Sort[] newArgs = new Sort[this.mArgs.length];
            int i = 0;
            while (i < this.mArgs.length) {
                newArgs[i] = this.mArgs[i].mapSort(substitution, cachedMappings);
                ++i;
            }
            result = this.mSymbol.getSort(this.mIndices, newArgs);
        }
        cachedMappings.put(this, result);
        return result;
    }

    public boolean isSortVariable() {
        return this.mSymbol.isSortVariable();
    }

    public String toString() {
        if (this.mArgs.length == 0) {
            return this.getIndexedName();
        }
        StringBuilder sb = new StringBuilder();
        new PrintTerm().append((Appendable)sb, this);
        return sb.toString();
    }

    void toStringHelper(ArrayDeque<Object> mTodo) {
        String name = this.getIndexedName();
        Sort[] args = this.getArguments();
        if (args.length == 0) {
            mTodo.addLast(name);
        } else {
            mTodo.addLast(")");
            int i = args.length - 1;
            while (i >= 0) {
                mTodo.addLast(args[i]);
                mTodo.addLast(" ");
                --i;
            }
            mTodo.addLast(name);
            mTodo.addLast("(");
        }
    }

    public Theory getTheory() {
        return this.mSymbol.mTheory;
    }

    public boolean isArraySort() {
        return this.getRealSort().mSymbol.isArray();
    }

    public boolean isNumericSort() {
        return this.getRealSort().mSymbol.isNumeric();
    }

    public boolean isInternal() {
        return this.mSymbol.isIntern();
    }

    public int hashCode() {
        return this.mHash;
    }
}

