/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.LambdaTerm;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.MatchTerm;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ScopedHashMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class TermTransformer
extends NonRecursive {
    private final ArrayList<HashMap<Term, Term>> mCache = new ArrayList();
    private final ScopedHashMap<TermVariable, Integer> mScopeMap = new ScopedHashMap();
    private final ArrayDeque<Term> mConverted = new ArrayDeque();
    private final ArrayDeque<Object[]> mConvertedArrays = new ArrayDeque();

    protected final void pushTerms(Term[] terms) {
        int i = terms.length - 1;
        while (i >= 0) {
            this.pushTerm(terms[i]);
            --i;
        }
    }

    protected final void pushTerm(Term term) {
        this.enqueueWalker(new Convert(term));
    }

    protected final void setResult(Term term) {
        this.mConverted.addLast(term);
    }

    private int findScope(TermVariable[] tvs) {
        int maxScopeNr = 0;
        TermVariable[] termVariableArray = tvs;
        int n = tvs.length;
        int n2 = 0;
        while (n2 < n) {
            TermVariable tv = termVariableArray[n2];
            Integer scopeNr = (Integer)this.mScopeMap.get((Object)tv);
            if (scopeNr != null && scopeNr > maxScopeNr) {
                maxScopeNr = scopeNr;
            }
            ++n2;
        }
        return maxScopeNr;
    }

    private void cacheConvert(Term term) {
        int scopeNr = this.findScope(term.getFreeVars());
        Term result = this.mCache.get(scopeNr).get(term);
        if (result == null) {
            this.enqueueWalker(new AddCache(term));
            this.convert(term);
        } else {
            this.setResult(result);
        }
    }

    protected void beginScope(TermVariable[] vars) {
        Integer scopeNumber = this.mCache.size();
        this.mCache.add(new HashMap());
        this.mScopeMap.beginScope();
        TermVariable[] termVariableArray = vars;
        int n = vars.length;
        int n2 = 0;
        while (n2 < n) {
            TermVariable var = termVariableArray[n2];
            this.mScopeMap.put((Object)var, (Object)scopeNumber);
            ++n2;
        }
    }

    protected void endScope() {
        int scopeNr = this.mCache.size() - 1;
        this.mCache.remove(scopeNr);
        this.mScopeMap.endScope();
    }

    protected void convert(Term term) {
        if (term instanceof ConstantTerm || term instanceof TermVariable) {
            this.mConverted.addLast(term);
        } else if (term instanceof ApplicationTerm) {
            this.enqueueWalker(new BuildApplicationTerm((ApplicationTerm)term));
            this.pushTerms(((ApplicationTerm)term).getParameters());
        } else if (term instanceof LetTerm) {
            this.enqueueWalker(new StartLetTerm((LetTerm)term));
            this.pushTerms(((LetTerm)term).getValues());
        } else if (term instanceof QuantifiedFormula) {
            QuantifiedFormula qf = (QuantifiedFormula)term;
            this.enqueueWalker(new BuildQuantifier(qf));
            this.pushTerm(qf.getSubformula());
            this.beginScope(qf.getVariables());
        } else if (term instanceof LambdaTerm) {
            LambdaTerm lambda = (LambdaTerm)term;
            this.enqueueWalker(new BuildLambda(lambda));
            this.pushTerm(lambda.getSubterm());
            this.beginScope(lambda.getVariables());
        } else {
            if (term instanceof AnnotatedTerm) {
                AnnotatedTerm annterm = (AnnotatedTerm)term;
                this.enqueueWalker(new BuildAnnotation(annterm));
                ArrayDeque<Object> todo = new ArrayDeque<Object>();
                Annotation[] annotationArray = annterm.getAnnotations();
                int n = annotationArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Annotation annot = annotationArray[n2];
                    if (annot.getValue() != null) {
                        todo.add(annot.getValue());
                    }
                    ++n2;
                }
                while (!todo.isEmpty()) {
                    Object value = todo.removeLast();
                    if (value instanceof Term) {
                        this.pushTerm((Term)value);
                        continue;
                    }
                    if (!(value instanceof Object[])) continue;
                    this.enqueueWalker(new BuildObjectArray((Object[])value));
                    Object[] objectArray = (Object[])value;
                    int n3 = objectArray.length;
                    n = 0;
                    while (n < n3) {
                        Object elem = objectArray[n];
                        todo.add(elem);
                        ++n;
                    }
                }
                this.pushTerm(annterm.getSubterm());
                return;
            }
            if (term instanceof MatchTerm) {
                MatchTerm matchTerm = (MatchTerm)term;
                this.enqueueWalker(new WalkMatchTerm(matchTerm));
                this.pushTerm(matchTerm.getDataTerm());
            } else {
                throw new AssertionError((Object)("Unknown Term: " + term.toStringDirect()));
            }
        }
    }

    public void convertApplicationTerm(ApplicationTerm appTerm, Term[] newArgs) {
        Term newTerm = appTerm;
        if (newArgs != appTerm.getParameters()) {
            FunctionSymbol fun = appTerm.getFunction();
            Theory theory = fun.getTheory();
            newTerm = theory.term(fun, newArgs);
        }
        this.setResult(newTerm);
    }

    public void preConvertLet(LetTerm oldLet, Term[] newValues) {
        this.beginScope(oldLet.getVariables());
        this.enqueueWalker(new BuildLetTerm(oldLet, newValues));
        this.pushTerm(oldLet.getSubTerm());
    }

    public void postConvertLet(LetTerm oldLet, Term[] newValues, Term newBody) {
        Term result = oldLet;
        if (oldLet.getValues() != newValues || oldLet.getSubTerm() != newBody) {
            result = oldLet.getTheory().let(oldLet.getVariables(), newValues, newBody);
        }
        this.setResult(result);
    }

    public void postConvertLambda(LambdaTerm old, Term newBody) {
        Term newFormula = old;
        if (newBody != old.getSubterm()) {
            Theory theory = old.getTheory();
            TermVariable[] vars = old.getVariables();
            newFormula = theory.lambda(vars, newBody);
        }
        this.setResult(newFormula);
    }

    public void postConvertQuantifier(QuantifiedFormula old, Term newBody) {
        Term newFormula = old;
        if (newBody != old.getSubformula()) {
            Theory theory = old.getTheory();
            TermVariable[] vars = old.getVariables();
            newFormula = old.getQuantifier() == 0 ? theory.exists(vars, newBody) : theory.forall(vars, newBody);
        }
        this.setResult(newFormula);
    }

    public void postConvertAnnotation(AnnotatedTerm old, Annotation[] newAnnots, Term newBody) {
        Annotation[] annots = old.getAnnotations();
        Term result = old;
        if (newBody != old.getSubterm() || newAnnots != annots) {
            result = old.getTheory().annotatedTerm(newAnnots, newBody);
        }
        this.setResult(result);
    }

    public void preConvertMatchCase(MatchTerm oldMatch, int caseNr) {
        this.beginScope(oldMatch.getVariables()[caseNr]);
        this.pushTerm(oldMatch.getCases()[caseNr]);
    }

    public void postConvertMatch(MatchTerm oldMatch, Term newDataTerm, Term[] newCases) {
        Term result = oldMatch;
        if (newDataTerm != oldMatch.getDataTerm() || newCases != oldMatch.getCases()) {
            Theory theory = oldMatch.getTheory();
            result = theory.match(newDataTerm, oldMatch.getVariables(), newCases, oldMatch.getConstructors());
        }
        this.setResult(result);
    }

    public final Term transform(Term term) {
        this.beginScope(new TermVariable[0]);
        this.run(new Convert(term));
        this.endScope();
        return this.mConverted.removeLast();
    }

    protected final Term getConverted() {
        return this.mConverted.removeLast();
    }

    protected final Object[] getConvertedObjectArray() {
        return this.mConvertedArrays.removeLast();
    }

    protected final Term[] getConverted(Term[] oldArgs) {
        Term[] newArgs = oldArgs;
        int i = oldArgs.length - 1;
        while (i >= 0) {
            Term newTerm = this.getConverted();
            if (newTerm != oldArgs[i]) {
                if (newArgs == oldArgs) {
                    newArgs = (Term[])oldArgs.clone();
                }
                newArgs[i] = newTerm;
            }
            --i;
        }
        return newArgs;
    }

    @Override
    public void reset() {
        super.reset();
        this.mConverted.clear();
        this.mCache.clear();
        this.mScopeMap.clear();
    }

    private static class AddCache
    implements NonRecursive.Walker {
        Term mOldTerm;

        public AddCache(Term term) {
            this.mOldTerm = term;
        }

        @Override
        public void walk(NonRecursive engine) {
            TermTransformer transformer = (TermTransformer)engine;
            int scopeNr = transformer.findScope(this.mOldTerm.getFreeVars());
            transformer.mCache.get(scopeNr).put(this.mOldTerm, transformer.mConverted.getLast());
        }

        public String toString() {
            return "AddCache[" + this.mOldTerm.toStringDirect() + "]";
        }
    }

    protected static class BuildAnnotation
    implements NonRecursive.Walker {
        private final AnnotatedTerm mAnnotatedTerm;

        public BuildAnnotation(AnnotatedTerm term) {
            this.mAnnotatedTerm = term;
        }

        @Override
        public void walk(NonRecursive engine) {
            Annotation[] annots;
            TermTransformer transformer = (TermTransformer)engine;
            Annotation[] newAnnots = annots = this.mAnnotatedTerm.getAnnotations();
            int i = annots.length - 1;
            while (i >= 0) {
                Object value = annots[i].getValue();
                Object newValue = value instanceof Term ? transformer.getConverted() : (value instanceof Object[] ? transformer.getConvertedObjectArray() : value);
                if (newValue != value) {
                    if (annots == newAnnots) {
                        newAnnots = (Annotation[])annots.clone();
                    }
                    newAnnots[i] = new Annotation(annots[i].getKey(), newValue);
                }
                --i;
            }
            Term sub = transformer.getConverted();
            transformer.postConvertAnnotation(this.mAnnotatedTerm, newAnnots, sub);
        }

        public String toString() {
            return "annotate";
        }
    }

    protected static class BuildApplicationTerm
    implements NonRecursive.Walker {
        private final ApplicationTerm mAppTerm;

        public BuildApplicationTerm(ApplicationTerm term) {
            this.mAppTerm = term;
        }

        @Override
        public void walk(NonRecursive engine) {
            TermTransformer transformer = (TermTransformer)engine;
            Term[] oldArgs = this.mAppTerm.getParameters();
            Term[] newArgs = transformer.getConverted(oldArgs);
            transformer.convertApplicationTerm(this.mAppTerm, newArgs);
        }

        public String toString() {
            return this.mAppTerm.getFunction().getApplicationString();
        }
    }

    protected static class BuildLambda
    implements NonRecursive.Walker {
        private final LambdaTerm mLambda;

        public BuildLambda(LambdaTerm term) {
            this.mLambda = term;
        }

        @Override
        public void walk(NonRecursive engine) {
            TermTransformer transformer = (TermTransformer)engine;
            Term sub = transformer.getConverted();
            transformer.postConvertLambda(this.mLambda, sub);
            transformer.endScope();
        }

        public String toString() {
            return "lambda";
        }
    }

    protected static class BuildLetTerm
    implements NonRecursive.Walker {
        private final LetTerm mLetTerm;
        private final Term[] mNewValues;

        public BuildLetTerm(LetTerm term, Term[] newValues) {
            this.mLetTerm = term;
            this.mNewValues = newValues;
        }

        @Override
        public void walk(NonRecursive engine) {
            TermTransformer transformer = (TermTransformer)engine;
            Term newBody = transformer.getConverted();
            transformer.postConvertLet(this.mLetTerm, this.mNewValues, newBody);
            transformer.endScope();
        }

        public String toString() {
            return "let" + Arrays.toString(this.mLetTerm.getVariables());
        }
    }

    protected static class BuildObjectArray
    implements NonRecursive.Walker {
        private final Object[] mArray;

        public BuildObjectArray(Object[] array) {
            this.mArray = array;
        }

        @Override
        public void walk(NonRecursive engine) {
            TermTransformer transformer = (TermTransformer)engine;
            Object[] newArray = this.mArray;
            int i = newArray.length - 1;
            while (i >= 0) {
                Object value = newArray[i];
                Object newValue = value instanceof Term ? transformer.getConverted() : (value instanceof Object[] ? transformer.getConvertedObjectArray() : value);
                if (newValue != value) {
                    if (this.mArray == newArray) {
                        newArray = (Object[])this.mArray.clone();
                    }
                    newArray[i] = newValue;
                }
                --i;
            }
            transformer.mConvertedArrays.addLast(newArray);
        }

        public String toString() {
            return "annotate";
        }
    }

    protected static class BuildQuantifier
    implements NonRecursive.Walker {
        private final QuantifiedFormula mQuant;

        public BuildQuantifier(QuantifiedFormula term) {
            this.mQuant = term;
        }

        @Override
        public void walk(NonRecursive engine) {
            TermTransformer transformer = (TermTransformer)engine;
            Term sub = transformer.getConverted();
            transformer.postConvertQuantifier(this.mQuant, sub);
            transformer.endScope();
        }

        public String toString() {
            return this.mQuant.getQuantifier() == 0 ? "exists" : "forall";
        }
    }

    private static class Convert
    implements NonRecursive.Walker {
        private final Term mTerm;

        public Convert(Term term) {
            this.mTerm = term;
        }

        public String toString() {
            return "Convert " + this.mTerm.toStringDirect();
        }

        @Override
        public void walk(NonRecursive walker) {
            ((TermTransformer)walker).cacheConvert(this.mTerm);
        }
    }

    protected static class StartLetTerm
    implements NonRecursive.Walker {
        private final LetTerm mLetTerm;

        public StartLetTerm(LetTerm term) {
            this.mLetTerm = term;
        }

        @Override
        public void walk(NonRecursive engine) {
            TermTransformer transformer = (TermTransformer)engine;
            Term[] values = transformer.getConverted(this.mLetTerm.getValues());
            transformer.preConvertLet(this.mLetTerm, values);
        }

        public String toString() {
            return "let" + Arrays.toString(this.mLetTerm.getVariables());
        }
    }

    protected static class WalkMatchTerm
    implements NonRecursive.Walker {
        private final MatchTerm mMatchTerm;
        private int mCaseNr;

        public WalkMatchTerm(MatchTerm term) {
            this.mMatchTerm = term;
            this.mCaseNr = 0;
        }

        @Override
        public void walk(NonRecursive engine) {
            TermTransformer transformer = (TermTransformer)engine;
            Term[] cases = this.mMatchTerm.getCases();
            if (this.mCaseNr > 0) {
                transformer.endScope();
            }
            if (this.mCaseNr < cases.length) {
                transformer.enqueueWalker(this);
                transformer.preConvertMatchCase(this.mMatchTerm, this.mCaseNr);
                ++this.mCaseNr;
            } else {
                Term[] newCases = transformer.getConverted(cases);
                Term newDataTerm = transformer.getConverted();
                transformer.postConvertMatch(this.mMatchTerm, newDataTerm, newCases);
            }
        }

        public String toString() {
            return "annotate";
        }
    }
}

