/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.llvm_j;

import com.google.common.base.Preconditions;
import com.sun.jna.Pointer;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.sosy_lab.llvm_j.Value;
import org.sosy_lab.llvm_j.binding.LLVMLibrary;

public final class BasicBlock
implements Iterable<Value> {
    private final LLVMLibrary.LLVMBasicBlockRef bb;

    LLVMLibrary.LLVMBasicBlockRef bb() {
        return this.bb;
    }

    BasicBlock(LLVMLibrary.LLVMBasicBlockRef bb) {
        Preconditions.checkNotNull((Object)((Object)bb));
        this.bb = bb;
    }

    public boolean equals(Object pObj) {
        if (!(pObj instanceof BasicBlock)) {
            return false;
        }
        BasicBlock rhs = (BasicBlock)pObj;
        if (this.bb == null) {
            return rhs.bb == null;
        }
        return rhs.bb.getPointer().equals((Object)this.bb.getPointer());
    }

    public Value basicBlockAsValue() {
        return new Value(LLVMLibrary.LLVMBasicBlockAsValue(this.bb));
    }

    public Value getBasicBlockParent() {
        return new Value(LLVMLibrary.LLVMGetBasicBlockParent(this.bb));
    }

    public BasicBlock getNextBasicBlock() {
        LLVMLibrary.LLVMBasicBlockRef nextBb = LLVMLibrary.LLVMGetNextBasicBlock(this.bb);
        if (nextBb == null) {
            return null;
        }
        return new BasicBlock(nextBb);
    }

    public BasicBlock getPreviousBasicBlock() {
        LLVMLibrary.LLVMBasicBlockRef nextBb = LLVMLibrary.LLVMGetPreviousBasicBlock(this.bb);
        if (nextBb == null) {
            return null;
        }
        return new BasicBlock(nextBb);
    }

    public Value getFirstInstruction() {
        LLVMLibrary.LLVMValueRef firstInstRef = LLVMLibrary.LLVMGetFirstInstruction(this.bb);
        if (firstInstRef == null) {
            return null;
        }
        return new Value(firstInstRef);
    }

    public Value getLastInstruction() {
        LLVMLibrary.LLVMValueRef lastInstRef = LLVMLibrary.LLVMGetLastInstruction(this.bb);
        if (lastInstRef == null) {
            return null;
        }
        return new Value(lastInstRef);
    }

    public int hashCode() {
        long address = Pointer.nativeValue((Pointer)this.bb.getPointer());
        return Long.hashCode(address);
    }

    @Override
    public Iterator<Value> iterator() {
        return new BasicBlockIterator();
    }

    private class BasicBlockIterator
    implements Iterator<Value> {
        private Value current;
        private final Value last;

        BasicBlockIterator() {
            this.current = BasicBlock.this.getFirstInstruction();
            this.last = BasicBlock.this.getLastInstruction();
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public Value next() {
            if (this.hasNext()) {
                Value tmp = this.current;
                this.current = this.current.equals(this.last) ? null : this.current.getNextInstruction();
                return tmp;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

