/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.llvm_j;

import java.io.Closeable;
import org.sosy_lab.llvm_j.Module;
import org.sosy_lab.llvm_j.TypeRef;
import org.sosy_lab.llvm_j.binding.LLVMLibrary;

public final class Context
implements Closeable {
    private LLVMLibrary.LLVMContextRef context;

    LLVMLibrary.LLVMContextRef context() {
        return this.context;
    }

    private Context(LLVMLibrary.LLVMContextRef context) {
        this.context = context;
    }

    public static Context create() {
        LLVMLibrary.instantiate();
        return new Context(LLVMLibrary.LLVMContextCreate());
    }

    public static Context getGlobalContext() {
        return new Context(LLVMLibrary.LLVMGetGlobalContext());
    }

    public static Context getModuleContext(Module m) {
        return new Context(LLVMLibrary.LLVMGetModuleContext(m.getModule()));
    }

    public static Context getTypeContext(TypeRef pType) {
        return new Context(LLVMLibrary.LLVMGetTypeContext(pType.type()));
    }

    @Override
    public void close() {
        if (this.context != null) {
            LLVMLibrary.LLVMContextDispose(this.context);
        }
        this.context = null;
    }
}

