/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.llvm_j;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.sosy_lab.llvm_j.BasicBlock;
import org.sosy_lab.llvm_j.Value;
import org.sosy_lab.llvm_j.binding.LLVMLibrary;

public final class Function
extends Value
implements Iterable<BasicBlock> {
    Function(LLVMLibrary.LLVMValueRef value) {
        super(value);
    }

    @Override
    public Iterator<BasicBlock> iterator() {
        return new FunctionIterator();
    }

    private class FunctionIterator
    implements Iterator<BasicBlock> {
        private BasicBlock current;
        private final BasicBlock last;

        FunctionIterator() {
            this.current = Function.this.getFirstBasicBlock();
            this.last = Function.this.getLastBasicBlock();
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public BasicBlock next() {
            if (this.hasNext()) {
                BasicBlock tmp = this.current;
                this.current = this.current.equals(this.last) ? null : this.current.getNextBasicBlock();
                return tmp;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

