/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.llvm_j;

import com.google.common.base.Preconditions;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.NativeMappedConverter;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import java.io.Closeable;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.llvm_j.Context;
import org.sosy_lab.llvm_j.Function;
import org.sosy_lab.llvm_j.LLVMException;
import org.sosy_lab.llvm_j.TypeRef;
import org.sosy_lab.llvm_j.Utils;
import org.sosy_lab.llvm_j.Value;
import org.sosy_lab.llvm_j.binding.LLVMLibrary;

public final class Module
implements Iterable<Value>,
Closeable {
    private LLVMLibrary.LLVMModuleRef module;
    private String fileName;

    LLVMLibrary.LLVMModuleRef getModule() {
        return this.module;
    }

    private Module(LLVMLibrary.LLVMModuleRef pModule, String pFileName) {
        this.module = pModule;
        this.fileName = pFileName;
    }

    private Module(LLVMLibrary.LLVMModuleRef pModule) {
        this.module = pModule;
    }

    public static void addLibraryLookupPaths(List<Path> pDirectories) {
        Preconditions.checkNotNull(pDirectories);
        for (Path p : pDirectories) {
            NativeLibrary.addSearchPath((String)"LLVM-9", (String)p.toAbsolutePath().toString());
        }
    }

    @Deprecated
    public static Module parseIR(String path) throws LLVMException {
        Context context = Context.create();
        return Module.parseIR(path, context);
    }

    public static Module parseIR(String path, Context pContext) throws LLVMException {
        PointerByReference outMsg;
        Preconditions.checkNotNull((Object)path);
        if (pContext == null) {
            throw new NullPointerException();
        }
        LLVMLibrary.LLVMContextRef context = pContext.context();
        long messageBufferLength = 1000000L;
        Memory outMsgAddr = new Memory(messageBufferLength);
        PointerByReference pointerToBuffer = new PointerByReference();
        LLVMLibrary.LLVMMemoryBufferRef pointerToBufferWrapped = new LLVMLibrary.LLVMMemoryBufferRef(pointerToBuffer.getPointer());
        LLVMLibrary.LLVMBool success = LLVMLibrary.LLVMCreateMemoryBufferWithContentsOfFile(path, pointerToBufferWrapped, outMsg = new PointerByReference((Pointer)outMsgAddr));
        if (Utils.llvmBoolToJavaBool(success)) {
            String errorMessage = Module.refToString(outMsg);
            throw new LLVMException("Reading bitcode failed. " + errorMessage);
        }
        LLVMLibrary.LLVMMemoryBufferRef buffer = new LLVMLibrary.LLVMMemoryBufferRef(pointerToBuffer.getValue());
        long moduleRefSize = Module.getSize(LLVMLibrary.LLVMModuleRef.class);
        PointerByReference pointerToModule = new PointerByReference((Pointer)new Memory(moduleRefSize));
        LLVMLibrary.LLVMModuleRef pointerToModuleWrapped = new LLVMLibrary.LLVMModuleRef(pointerToModule.getPointer());
        if (path.endsWith(".bc")) {
            success = LLVMLibrary.LLVMParseBitcodeInContext2(context, buffer, pointerToModuleWrapped);
            if (Utils.llvmBoolToJavaBool(success)) {
                throw new LLVMException("Parsing bitcode failed");
            }
            LLVMLibrary.LLVMDisposeMemoryBuffer(buffer);
        } else {
            success = LLVMLibrary.LLVMParseIRInContext(context, buffer, pointerToModuleWrapped, outMsg);
            if (Utils.llvmBoolToJavaBool(success)) {
                throw new LLVMException("Parsing bitcode (human-readable format) failed. " + Module.refToString(outMsg));
            }
        }
        LLVMLibrary.LLVMModuleRef module = new LLVMLibrary.LLVMModuleRef(pointerToModule.getValue());
        return new Module(module, path);
    }

    private static String refToString(PointerByReference pRef) {
        return pRef.getValue().getString(0L);
    }

    private static long getSize(Class<?> pClass) {
        Class nativeClass = NativeMappedConverter.getInstance(pClass).nativeType();
        return Native.getNativeSize((Class)nativeClass);
    }

    public static Module createWithName(String moduleID) {
        Preconditions.checkNotNull((Object)moduleID);
        return new Module(LLVMLibrary.LLVMModuleCreateWithName(moduleID));
    }

    public static Module createWithNameInContext(String moduleID, Context c) {
        Preconditions.checkNotNull((Object)moduleID);
        if (c == null) {
            throw new NullPointerException();
        }
        return new Module(LLVMLibrary.LLVMModuleCreateWithNameInContext(moduleID, c.context()));
    }

    public static Module createGlobalParentOf(Value pValue) {
        return new Module(LLVMLibrary.LLVMGetGlobalParent(pValue.value()));
    }

    public @Nullable String getOriginFileName() {
        return this.fileName;
    }

    public String getDataLayoutString() {
        return LLVMLibrary.LLVMGetDataLayout(this.module);
    }

    public LLVMLibrary.LLVMTargetDataRef getDataLayout() {
        return LLVMLibrary.LLVMCreateTargetData(this.getDataLayoutString());
    }

    public String getTargetString() {
        return LLVMLibrary.LLVMGetTarget(this.module);
    }

    public TypeRef getTypeByName(String name) {
        Preconditions.checkNotNull((Object)name);
        return new TypeRef(LLVMLibrary.LLVMGetTypeByName(this.module, name));
    }

    public int writeBitcodeToFile(String path) {
        Preconditions.checkNotNull((Object)path);
        return LLVMLibrary.LLVMWriteBitcodeToFile(this.module, path);
    }

    public Context getModuleContext() {
        return Context.getModuleContext(this);
    }

    public Value getNamedGlobal(String name) {
        Preconditions.checkNotNull((Object)name);
        return new Value(LLVMLibrary.LLVMGetNamedGlobal(this.getModule(), name));
    }

    public Value getFirstGlobal() {
        try {
            LLVMLibrary.LLVMValueRef ref = LLVMLibrary.LLVMGetFirstGlobal(this.getModule());
            if (ref != null) {
                return new Value(ref);
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public Value getLastGlobal() {
        try {
            return new Value(LLVMLibrary.LLVMGetLastGlobal(this.getModule()));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public Value addAlias(TypeRef ty, Value aliasee, String name) {
        Preconditions.checkNotNull((Object)ty);
        Preconditions.checkNotNull((Object)aliasee);
        Preconditions.checkNotNull((Object)name);
        return new Value(LLVMLibrary.LLVMAddAlias(this.module, ty.type(), aliasee.value(), name));
    }

    public Function getNamedFunction(String name) {
        Preconditions.checkNotNull((Object)name);
        return new Function(LLVMLibrary.LLVMGetNamedFunction(this.module, name));
    }

    public Value getFirstFunction() {
        try {
            return new Value(LLVMLibrary.LLVMGetFirstFunction(this.module));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public Value getLastFunction() {
        try {
            return new Value(LLVMLibrary.LLVMGetLastFunction(this.module));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public void close() {
        LLVMLibrary.LLVMDisposeModule(this.module);
        this.module = null;
    }

    @Override
    public Iterator<Value> iterator() {
        return new ModuleIterator();
    }

    private class ModuleIterator
    implements Iterator<Value> {
        private Value current;
        private final Value last;

        ModuleIterator() {
            this.current = Module.this.getFirstFunction();
            this.last = Module.this.getLastFunction();
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public Value next() {
            if (this.hasNext()) {
                Value tmp = this.current;
                this.current = this.current.equals(this.last) ? null : this.current.getNextFunction();
                return tmp;
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

