/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.llvm_j;

import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.sosy_lab.llvm_j.BasicBlock;
import org.sosy_lab.llvm_j.Context;
import org.sosy_lab.llvm_j.LLVMException;
import org.sosy_lab.llvm_j.Module;
import org.sosy_lab.llvm_j.Value;

public class ModuleTest {
    private Context context;

    @Before
    public void setUp_library() {
        Path libraryPath = Paths.get("lib", "java", "runtime");
        ImmutableList relevantLibDirs = ImmutableList.of((Object)libraryPath);
        Module.addLibraryLookupPaths((List<Path>)relevantLibDirs);
        this.context = Context.create();
    }

    @After
    public void tearDown_context() {
        this.context.close();
    }

    @Test
    public void test_parseBitcode_noContext_valid() throws LLVMException {
        String llvmFile = "build/test.bc";
        try (Module m = Module.parseIR(llvmFile);){
            ModuleTest.expectComponentsExist(m);
        }
    }

    @Test
    public void test_parseLl_noContext_valid() throws LLVMException {
        String llvmFile = "build/test.ll";
        try (Module m = Module.parseIR(llvmFile);){
            ModuleTest.expectComponentsExist(m);
        }
    }

    @Test
    public void test_parseBitcode_withContext_valid() throws LLVMException {
        String llvmFile = "build/test.bc";
        try (Module m = Module.parseIR(llvmFile, this.context);){
            ModuleTest.expectComponentsExist(m);
        }
    }

    @Test
    public void test_parseLl_withContext_valid() throws LLVMException {
        String llvmFile = "build/test.ll";
        try (Module m = Module.parseIR(llvmFile, this.context);){
            ModuleTest.expectComponentsExist(m);
        }
    }

    private static void expectComponentsExist(Module pModule) {
        Truth.assertThat((Iterable)pModule).isNotNull();
        Value firstFunction = pModule.getFirstFunction();
        Truth.assertThat((Object)firstFunction).isNotNull();
        BasicBlock firstBlock = firstFunction.getFirstBasicBlock();
        Truth.assertThat((Iterable)firstBlock).isNotNull();
        Value firstInstruction = firstBlock.getFirstInstruction();
        Truth.assertThat((Object)firstInstruction).isNotNull();
    }
}

