/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.llvm_j;

import com.google.common.collect.ImmutableList;
import com.google.common.testing.AbstractPackageSanityTests;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.sosy_lab.llvm_j.BasicBlock;
import org.sosy_lab.llvm_j.Context;
import org.sosy_lab.llvm_j.LLVMException;
import org.sosy_lab.llvm_j.Module;
import org.sosy_lab.llvm_j.TypeRef;
import org.sosy_lab.llvm_j.Value;
import org.sosy_lab.llvm_j.binding.LLVMLibrary;

public class PackageSanityTest
extends AbstractPackageSanityTests {
    private final Context context;
    private final Module module;

    public PackageSanityTest() {
        try {
            Path libraryPath = Paths.get("lib", "java", "runtime");
            ImmutableList relevantLibDirs = ImmutableList.of((Object)libraryPath);
            Module.addLibraryLookupPaths((List<Path>)relevantLibDirs);
            this.context = Context.create();
            this.module = Module.parseIR("build/test.bc", this.context);
            BasicBlock b1 = this.module.getFirstFunction().getFirstBasicBlock();
            BasicBlock b2 = b1.getNextBasicBlock();
            Value v = b1.getFirstInstruction();
            TypeRef t = v.typeOf();
            this.setDefault(Context.class, this.context);
            this.setDefault(TypeRef.class, t);
            this.setDistinctValues(TypeRef.class, t, b2.getFirstInstruction().typeOf());
            this.setDefault(LLVMLibrary.LLVMTypeRef.class, (Object)t.type());
            this.setDistinctValues(LLVMLibrary.LLVMTypeRef.class, (Object)t.type(), (Object)b2.getFirstInstruction().typeOf().type());
            this.setDefault(Value.class, v);
            this.setDistinctValues(Value.class, v, b1.basicBlockAsValue());
            this.setDefault(BasicBlock.class, b1);
            this.setDistinctValues(BasicBlock.class, b1, b2);
            this.setDefault(LLVMLibrary.LLVMBasicBlockRef.class, (Object)b1.bb());
            this.setDistinctValues(LLVMLibrary.LLVMBasicBlockRef.class, (Object)b1.bb(), (Object)b2.bb());
        }
        catch (LLVMException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected void tearDown() throws Exception {
        this.module.close();
        this.context.close();
        super.tearDown();
    }
}

