/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.llvm_j;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import org.sosy_lab.llvm_j.Function;
import org.sosy_lab.llvm_j.LLVMException;
import org.sosy_lab.llvm_j.Module;
import org.sosy_lab.llvm_j.Utils;
import org.sosy_lab.llvm_j.binding.LLVMLibrary;

public final class PassManager
implements Closeable {
    private LLVMLibrary.LLVMPassManagerRef manager;

    LLVMLibrary.LLVMPassManagerRef manager() {
        return this.manager;
    }

    private PassManager(LLVMLibrary.LLVMPassManagerRef manager) {
        this.manager = manager;
    }

    public static PassManager create() {
        return new PassManager(LLVMLibrary.LLVMCreatePassManager());
    }

    public static PassManager createForModule(Module m) {
        if (m == null) {
            throw new NullPointerException();
        }
        return new PassManager(LLVMLibrary.LLVMCreateFunctionPassManagerForModule(m.getModule()));
    }

    public static PassManager createFPM(LLVMLibrary.LLVMModuleProviderRef mp) {
        Preconditions.checkNotNull((Object)((Object)mp));
        return new PassManager(LLVMLibrary.LLVMCreateFunctionPassManager(mp));
    }

    public void initialize() throws LLVMException {
        LLVMLibrary.LLVMBool errB = LLVMLibrary.LLVMInitializeFunctionPassManager(this.manager);
        boolean err = Utils.llvmBoolToJavaBool(errB);
        if (err) {
            throw new LLVMException("error in LLVMInitializeFunctionPassManager");
        }
    }

    public void runForModule(Module m) throws LLVMException {
        LLVMLibrary.LLVMBool errB = LLVMLibrary.LLVMRunPassManager(this.manager, m.getModule());
        boolean err = Utils.llvmBoolToJavaBool(errB);
        if (err) {
            throw new LLVMException("error in LLVMRunPassManager");
        }
    }

    public void runForFunction(Function f) throws LLVMException {
        LLVMLibrary.LLVMBool errB = LLVMLibrary.LLVMRunFunctionPassManager(this.manager, f.value());
        boolean err = Utils.llvmBoolToJavaBool(errB);
        if (err) {
            throw new LLVMException("error in LLVMRunFunctionPassManager");
        }
    }

    public void addArgumentPromotionPass() {
        LLVMLibrary.LLVMAddArgumentPromotionPass(this.manager);
    }

    public void addConstantMergePass() {
        LLVMLibrary.LLVMAddConstantMergePass(this.manager);
    }

    public void addDeadArgEliminationPass() {
        LLVMLibrary.LLVMAddDeadArgEliminationPass(this.manager);
    }

    public void addFunctionAttrsPass() {
        LLVMLibrary.LLVMAddFunctionAttrsPass(this.manager);
    }

    public void addFunctionInliningPass() {
        LLVMLibrary.LLVMAddFunctionInliningPass(this.manager);
    }

    public void addGlobalDCEPass() {
        LLVMLibrary.LLVMAddGlobalDCEPass(this.manager);
    }

    public void addGlobalOptimizerPass() {
        LLVMLibrary.LLVMAddGlobalOptimizerPass(this.manager);
    }

    public void addIPConstantPropagationPass() {
        LLVMLibrary.LLVMAddIPConstantPropagationPass(this.manager);
    }

    public void addPruneEHPass() {
        LLVMLibrary.LLVMAddPruneEHPass(this.manager);
    }

    public void addIPSCCPPass() {
        LLVMLibrary.LLVMAddIPSCCPPass(this.manager);
    }

    public void addInternalizePass(boolean allButMain) {
        LLVMLibrary.LLVMAddInternalizePass(allButMain ? 1 : 0);
    }

    public void addStripDeadPrototypesPass() {
        LLVMLibrary.LLVMAddStripDeadPrototypesPass(this.manager);
    }

    public void addStripSymbolsPass() {
        LLVMLibrary.LLVMAddStripSymbolsPass(this.manager);
    }

    public void addAggressiveDCEPass() {
        LLVMLibrary.LLVMAddAggressiveDCEPass(this.manager);
    }

    public void addCFGSimplificationPass() {
        LLVMLibrary.LLVMAddCFGSimplificationPass(this.manager);
    }

    public void addDeadStoreEliminationPass() {
        LLVMLibrary.LLVMAddDeadStoreEliminationPass(this.manager);
    }

    public void addGVNPass() {
        LLVMLibrary.LLVMAddGVNPass(this.manager);
    }

    public void addIndVarSimplifyPass() {
        LLVMLibrary.LLVMAddIndVarSimplifyPass(this.manager);
    }

    public void addInstructionCombiningPass() {
        LLVMLibrary.LLVMAddInstructionCombiningPass(this.manager);
    }

    public void addJumpThreadingPass() {
        LLVMLibrary.LLVMAddJumpThreadingPass(this.manager);
    }

    public void addLICMPass() {
        LLVMLibrary.LLVMAddLICMPass(this.manager);
    }

    public void addLoopDeletionPass() {
        LLVMLibrary.LLVMAddLoopDeletionPass(this.manager);
    }

    public void addLoopRotatePass() {
        LLVMLibrary.LLVMAddLoopRotatePass(this.manager);
    }

    public void addLoopUnrollPass() {
        LLVMLibrary.LLVMAddLoopUnrollPass(this.manager);
    }

    public void addLoopUnswitchPass() {
        LLVMLibrary.LLVMAddLoopUnswitchPass(this.manager);
    }

    public void addMemCpyOptPass() {
        LLVMLibrary.LLVMAddMemCpyOptPass(this.manager);
    }

    public void addPromoteMemoryToRegisterPass() {
        LLVMLibrary.LLVMAddPromoteMemoryToRegisterPass(this.manager);
    }

    public void addReassociatePass() {
        LLVMLibrary.LLVMAddReassociatePass(this.manager);
    }

    public void addSCCPPass() {
        LLVMLibrary.LLVMAddSCCPPass(this.manager);
    }

    public void addScalarReplAggregatesPass() {
        LLVMLibrary.LLVMAddScalarReplAggregatesPass(this.manager);
    }

    public void addScalarReplAggregatesPassWithThreshold(int threshold) {
        LLVMLibrary.LLVMAddScalarReplAggregatesPassWithThreshold(this.manager, threshold);
    }

    public void addSimplifyLibCallsPass() {
        LLVMLibrary.LLVMAddSimplifyLibCallsPass(this.manager);
    }

    public void addTailCallEliminationPass() {
        LLVMLibrary.LLVMAddTailCallEliminationPass(this.manager);
    }

    public void addConstantPropagationPass() {
        LLVMLibrary.LLVMAddConstantPropagationPass(this.manager);
    }

    public void addDemoteMemoryToRegisterPass() {
        LLVMLibrary.LLVMAddDemoteMemoryToRegisterPass(this.manager);
    }

    public void addVerifierPass() {
        LLVMLibrary.LLVMAddVerifierPass(this.manager);
    }

    @Override
    public void close() throws IOException {
        LLVMLibrary.LLVMBool successB = LLVMLibrary.LLVMFinalizeFunctionPassManager(this.manager);
        boolean success = Utils.llvmBoolToJavaBool(successB);
        LLVMLibrary.LLVMDisposePassManager(this.manager);
        this.manager = null;
        if (success) {
            throw new IOException(new LLVMException("error in LLVMFinalizeFunctionPassManager"));
        }
    }
}

