/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.llvm_j;

import com.google.common.base.Preconditions;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.sosy_lab.llvm_j.Context;
import org.sosy_lab.llvm_j.Utils;
import org.sosy_lab.llvm_j.Value;
import org.sosy_lab.llvm_j.binding.LLVMLibrary;

public class TypeRef {
    private final LLVMLibrary.LLVMTypeRef type;

    LLVMLibrary.LLVMTypeRef type() {
        return this.type;
    }

    TypeRef(LLVMLibrary.LLVMTypeRef type) {
        Preconditions.checkNotNull((Object)((Object)type));
        this.type = type;
    }

    public TypeKind getTypeKind() {
        int typeInt = LLVMLibrary.LLVMGetTypeKind(this.type);
        if (typeInt == 1) {
            return TypeKind.Half;
        }
        if (typeInt == 2) {
            return TypeKind.Float;
        }
        if (typeInt == 3) {
            return TypeKind.Double;
        }
        if (typeInt == 4) {
            return TypeKind.X86_FP80;
        }
        if (typeInt == 5) {
            return TypeKind.FP128;
        }
        if (typeInt == 6) {
            return TypeKind.PPC_FP128;
        }
        if (typeInt == 7) {
            return TypeKind.Label;
        }
        if (typeInt == 8) {
            return TypeKind.Integer;
        }
        if (typeInt == 9) {
            return TypeKind.Function;
        }
        if (typeInt == 10) {
            return TypeKind.Struct;
        }
        if (typeInt == 11) {
            return TypeKind.Array;
        }
        if (typeInt == 12) {
            return TypeKind.Pointer;
        }
        if (typeInt == 14) {
            return TypeKind.Metadata;
        }
        if (typeInt == 16) {
            return TypeKind.Token;
        }
        if (typeInt == 0) {
            return TypeKind.Void;
        }
        if (typeInt == 15) {
            return TypeKind.X86_MMX;
        }
        if (typeInt == 13) {
            return TypeKind.Vector;
        }
        throw new AssertionError((Object)("Unhanlded type kind id " + typeInt));
    }

    public long getOffsetOfElement(int idx, LLVMLibrary.LLVMTargetDataRef td) {
        Preconditions.checkNotNull((Object)((Object)td));
        Utils.checkLlvmState(this.getTypeKind().equals((Object)TypeKind.Struct), "Type is not a struct");
        return LLVMLibrary.LLVMOffsetOfElement(td, this.type, idx);
    }

    public Context getTypeContext() {
        return Context.getTypeContext(this);
    }

    public int getIntTypeWidth() {
        Utils.checkLlvmState(this.getTypeKind().equals((Object)TypeKind.Integer), "Type is not an integer");
        return LLVMLibrary.LLVMGetIntTypeWidth(this.type);
    }

    public boolean isFunctionVarArg() {
        Utils.checkLlvmState(this.getTypeKind().equals((Object)TypeKind.Function), "Type is not a function");
        LLVMLibrary.LLVMBool b = LLVMLibrary.LLVMIsFunctionVarArg(this.type);
        return Utils.llvmBoolToJavaBool(b);
    }

    public TypeRef getReturnType() {
        Utils.checkLlvmState(this.getTypeKind().equals((Object)TypeKind.Function), "Type is not a function");
        return new TypeRef(LLVMLibrary.LLVMGetReturnType(this.type));
    }

    public int countParamTypes() {
        Utils.checkLlvmState(this.getTypeKind().equals((Object)TypeKind.Function), "Type is not a function: " + this.getTypeKind());
        return LLVMLibrary.LLVMCountParamTypes(this.type);
    }

    public List<TypeRef> getParamTypes() {
        Utils.checkLlvmState(this.getTypeKind().equals((Object)TypeKind.Function), "Type is not a function");
        int paramCount = this.countParamTypes();
        ArrayList<TypeRef> params = new ArrayList<TypeRef>(paramCount);
        if (paramCount > 0) {
            int typeRefSize = Native.getNativeSize(LLVMLibrary.LLVMTypeRef.class);
            Memory arrayPointer = new Memory((long)(paramCount * typeRefSize));
            LLVMLibrary.LLVMTypeRef typeRefArray = new LLVMLibrary.LLVMTypeRef((Pointer)arrayPointer);
            LLVMLibrary.LLVMGetParamTypes(this.type, typeRefArray);
            Pointer[] paramRefs = new Pointer[paramCount];
            arrayPointer.read(0L, paramRefs, 0, paramCount);
            for (int i = 0; i < paramCount; ++i) {
                LLVMLibrary.LLVMTypeRef paramRef = new LLVMLibrary.LLVMTypeRef(paramRefs[i]);
                params.add(new TypeRef(paramRef));
            }
        }
        return params;
    }

    public int countStructElementTypes() {
        Utils.checkLlvmState(this.getTypeKind().equals((Object)TypeKind.Struct), "Type is not a struct");
        return LLVMLibrary.LLVMCountStructElementTypes(this.type);
    }

    public List<TypeRef> getStructElementTypes() {
        Utils.checkLlvmState(this.getTypeKind().equals((Object)TypeKind.Struct), "Type is not a struct");
        int memberCount = this.countStructElementTypes();
        ArrayList<TypeRef> members = new ArrayList<TypeRef>(memberCount);
        if (memberCount > 0) {
            int typeRefSize = Native.getNativeSize(LLVMLibrary.LLVMTypeRef.class);
            Memory arrayPointer = new Memory((long)(memberCount * typeRefSize));
            LLVMLibrary.LLVMTypeRef typeRefArray = new LLVMLibrary.LLVMTypeRef((Pointer)arrayPointer);
            LLVMLibrary.LLVMGetStructElementTypes(this.type, typeRefArray);
            Pointer[] memberRefs = new Pointer[memberCount];
            arrayPointer.read(0L, memberRefs, 0, memberCount);
            for (int i = 0; i < memberCount; ++i) {
                LLVMLibrary.LLVMTypeRef memberRef = new LLVMLibrary.LLVMTypeRef(memberRefs[i]);
                members.add(new TypeRef(memberRef));
            }
        }
        return members;
    }

    public boolean isStructNamed() {
        String name = LLVMLibrary.LLVMGetStructName(this.type);
        return name != null;
    }

    public String getStructName() {
        Utils.checkLlvmState(this.isStructNamed(), "Type is not named struct");
        return LLVMLibrary.LLVMGetStructName(this.type);
    }

    public boolean isPackedStruct() {
        Utils.checkLlvmState(this.getTypeKind().equals((Object)TypeKind.Struct), "Type is not a struct");
        LLVMLibrary.LLVMBool b = LLVMLibrary.LLVMIsPackedStruct(this.type);
        return Utils.llvmBoolToJavaBool(b);
    }

    public boolean isOpaqueStruct() {
        Utils.checkLlvmState(this.getTypeKind().equals((Object)TypeKind.Struct), "Type is not a struct");
        LLVMLibrary.LLVMBool b = LLVMLibrary.LLVMIsOpaqueStruct(this.type);
        return Utils.llvmBoolToJavaBool(b);
    }

    public TypeRef getElementType() {
        TypeKind typeKind = this.getTypeKind();
        Utils.checkLlvmState(typeKind.equals((Object)TypeKind.Array) || typeKind.equals((Object)TypeKind.Vector) || typeKind.equals((Object)TypeKind.Pointer), "Type neither array, nor vector, nor pointer");
        return new TypeRef(LLVMLibrary.LLVMGetElementType(this.type));
    }

    public TypeRef getTypeAtIndex(int idx) {
        Utils.checkLlvmState(this.getTypeKind().equals((Object)TypeKind.Struct), "Type is not a struct");
        return new TypeRef(LLVMLibrary.LLVMStructGetTypeAtIndex(this.type, idx));
    }

    public int getArrayLength() {
        Utils.checkLlvmState(this.getTypeKind().equals((Object)TypeKind.Array), "Type is not an array");
        return LLVMLibrary.LLVMGetArrayLength(this.type);
    }

    public int getPointerAddressSpace() {
        Utils.checkLlvmState(this.getTypeKind().equals((Object)TypeKind.Pointer), "Type is not a pointer");
        return LLVMLibrary.LLVMGetPointerAddressSpace(this.type);
    }

    public int getVectorSize() {
        Utils.checkLlvmState(this.getTypeKind().equals((Object)TypeKind.Vector), "Type is not a vector");
        return LLVMLibrary.LLVMGetVectorSize(this.type);
    }

    public Value alignOf() {
        return new Value(LLVMLibrary.LLVMAlignOf(this.type));
    }

    public Value sizeOf() {
        return new Value(LLVMLibrary.LLVMSizeOf(this.type));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TypeRef)) {
            return false;
        }
        TypeRef typeRef = (TypeRef)o;
        return this.type.equals((Object)typeRef.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type});
    }

    public static enum TypeKind {
        Void,
        Half,
        Float,
        Double,
        X86_FP80,
        FP128,
        PPC_FP128,
        Label,
        Integer,
        Function,
        Struct,
        Array,
        Pointer,
        Vector,
        Metadata,
        X86_MMX,
        Token;

    }
}

