/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.llvm_j;

import com.sun.jna.Pointer;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Utils {
    private Utils() {
    }

    static boolean llvmBoolToJavaBool( @Nullable LLVMLibrary.LLVMBool pBool) {
        if (pBool == null) {
            return false;
        }
        Pointer boolAsPointer = pBool.getPointer();
        long bAsInt = Pointer.nativeValue((Pointer)boolAsPointer);
        assert (bAsInt == 0L || bAsInt == 1L);
        return bAsInt == 1L;
    }

    static void checkLlvmState(boolean pState) {
        if (!pState) {
            throw new IllegalStateException("Invalid state");
        }
    }

    static void checkLlvmState(boolean pState, String pMessage) {
        if (!pState) {
            throw new IllegalStateException(pMessage);
        }
    }
}

