/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.llvm_j;

import com.google.common.base.Preconditions;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import org.sosy_lab.llvm_j.BasicBlock;
import org.sosy_lab.llvm_j.Function;
import org.sosy_lab.llvm_j.Module;
import org.sosy_lab.llvm_j.TypeRef;
import org.sosy_lab.llvm_j.Use;
import org.sosy_lab.llvm_j.Utils;
import org.sosy_lab.llvm_j.binding.LLVMLibrary;
import org.sosy_lab.llvm_j.binding.ext.NativeSizeByReference;

public class Value {
    private final LLVMLibrary.LLVMValueRef value;

    LLVMLibrary.LLVMValueRef value() {
        return this.value;
    }

    public boolean equals(Object pObj) {
        if (!(pObj instanceof Value)) {
            return false;
        }
        Value rhs = (Value)pObj;
        if (this.value == null) {
            return rhs.value == null;
        }
        return this.value.getPointer().equals((Object)rhs.value.getPointer());
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    Value(LLVMLibrary.LLVMValueRef value) {
        Preconditions.checkNotNull((Object)((Object)value));
        this.value = value;
    }

    public TypeRef typeOf() {
        return new TypeRef(LLVMLibrary.LLVMTypeOf(this.value));
    }

    public long getAddress() {
        if (this.value == null) {
            return 0L;
        }
        return Pointer.nativeValue((Pointer)this.value.getPointer());
    }

    public Function asFunction() {
        Utils.checkLlvmState(this.isFunction(), "Value is not a function: " + this);
        return new Function(this.value);
    }

    public String getValueName() {
        return LLVMLibrary.LLVMGetValueName(this.value);
    }

    public String toString() {
        Pointer ret = LLVMLibrary.LLVMPrintValueToString(this.value);
        return ret.getString(0L);
    }

    public int hasMetadata() {
        return LLVMLibrary.LLVMHasMetadata(this.value);
    }

    public Value getMetadata(int kindID) {
        return new Value(LLVMLibrary.LLVMGetMetadata(this.value, kindID));
    }

    public void setMetadata(int kindID, Value node) {
        Preconditions.checkNotNull((Object)node);
        LLVMLibrary.LLVMSetMetadata(this.value, kindID, node.value());
    }

    public boolean isArgument() {
        try {
            return LLVMLibrary.LLVMIsAArgument(this.value) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isABasicBlock() {
        try {
            return LLVMLibrary.LLVMIsABasicBlock(this.value) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isInlineAsm() {
        try {
            return LLVMLibrary.LLVMIsAInlineAsm(this.value) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isUser() {
        try {
            return LLVMLibrary.LLVMIsAUser(this.value) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isConstantAggregateZero() {
        try {
            return LLVMLibrary.LLVMIsAConstantAggregateZero(this.value) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isConstantArray() {
        try {
            return LLVMLibrary.LLVMIsAConstantArray(this.value) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isConstantDataArray() {
        try {
            return LLVMLibrary.LLVMIsAConstantDataArray(this.value) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isConstantExpr() {
        try {
            return LLVMLibrary.LLVMIsAConstantExpr(this.value) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isConstantFP() {
        try {
            return LLVMLibrary.LLVMIsAConstantFP(this.value) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isConstantInt() {
        try {
            return LLVMLibrary.LLVMIsAConstantInt(this.value) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isConstantPointerNull() {
        try {
            return LLVMLibrary.LLVMIsAConstantPointerNull(this.value) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isConstantStruct() {
        try {
            return LLVMLibrary.LLVMIsAConstantStruct(this.value) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isConstantVector() {
        try {
            return LLVMLibrary.LLVMIsAConstantVector(this.value) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isGlobalValue() {
        try {
            return LLVMLibrary.LLVMIsAGlobalValue(this.value) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isFunction() {
        try {
            return LLVMLibrary.LLVMIsAFunction(this.value) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isGlobalAlias() {
        try {
            return LLVMLibrary.LLVMIsAGlobalAlias(this.value) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isGlobalVariable() {
        try {
            return LLVMLibrary.LLVMIsAGlobalVariable(this.value) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isUndefValue() {
        try {
            return LLVMLibrary.LLVMIsAUndefValue(this.value) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isInstruction() {
        try {
            return LLVMLibrary.LLVMIsAInstruction(this.value) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isBinaryOperator() {
        try {
            return LLVMLibrary.LLVMIsABinaryOperator(this.value) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isCallInst() {
        try {
            return LLVMLibrary.LLVMIsACallInst(this.value) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isIntrinsicInst() {
        try {
            return LLVMLibrary.LLVMIsAIntrinsicInst(this.value) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isDbgInfoIntrinsic() {
        try {
            return LLVMLibrary.LLVMIsADbgInfoIntrinsic(this.value) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isDbgDeclareInst() {
        try {
            return LLVMLibrary.LLVMIsADbgDeclareInst(this.value) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isMemIntrinsic() {
        try {
            return LLVMLibrary.LLVMIsAMemIntrinsic(this.value) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isMemCpyInst() {
        try {
            return LLVMLibrary.LLVMIsAMemCpyInst(this.value) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isMemMoveInst() {
        try {
            return LLVMLibrary.LLVMIsAMemMoveInst(this.value) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isMemSetInst() {
        try {
            return LLVMLibrary.LLVMIsAMemSetInst(this.value) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isCmpInst() {
        try {
            return LLVMLibrary.LLVMIsACmpInst(this.value) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isFCmpInst() {
        try {
            return LLVMLibrary.LLVMIsAFCmpInst(this.value) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isICmpInst() {
        try {
            return LLVMLibrary.LLVMIsAICmpInst(this.value) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isExtractElementInst() {
        try {
            return LLVMLibrary.LLVMIsAExtractElementInst(this.value) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isGetElementPtrInst() {
        try {
            return this.isConstantExpr() && this.getConstOpCode().equals((Object)OpCode.GetElementPtr) || LLVMLibrary.LLVMIsAGetElementPtrInst(this.value) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isInsertElementInst() {
        try {
            return LLVMLibrary.LLVMIsAInsertElementInst(this.value) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isInsertValueInst() {
        try {
            return LLVMLibrary.LLVMIsAInsertValueInst(this.value) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isPHINode() {
        try {
            return LLVMLibrary.LLVMIsAPHINode(this.value) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isSelectInst() {
        try {
            return LLVMLibrary.LLVMIsASelectInst(this.value) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isShuffleVectorInst() {
        try {
            return LLVMLibrary.LLVMIsAShuffleVectorInst(this.value) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isStoreInst() {
        try {
            return LLVMLibrary.LLVMIsAStoreInst(this.value) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isTerminatorInst() {
        try {
            return LLVMLibrary.LLVMIsATerminatorInst(this.value) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isBranchInst() {
        try {
            return LLVMLibrary.LLVMIsABranchInst(this.value) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isIndirectBranchInst() {
        try {
            return LLVMLibrary.LLVMIsAIndirectBrInst(this.value) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isInvokeInst() {
        try {
            return LLVMLibrary.LLVMIsAInvokeInst(this.value) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isReturnInst() {
        try {
            return LLVMLibrary.LLVMIsAReturnInst(this.value) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public Value getReturnValue() {
        Utils.checkLlvmState(this.isReturnInst(), "Value is not a return instruction: " + this);
        if (this.getNumOperands() > 0) {
            return this.getOperand(0);
        }
        return null;
    }

    public boolean isSwitchInst() {
        try {
            return LLVMLibrary.LLVMIsASwitchInst(this.value) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isUnreachableInst() {
        try {
            return LLVMLibrary.LLVMIsAUnreachableInst(this.value) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isUnaryInstruction() {
        try {
            return LLVMLibrary.LLVMIsAUnaryInstruction(this.value) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isAllocaInst() {
        try {
            return LLVMLibrary.LLVMIsAAllocaInst(this.value) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public TypeRef getAllocatedType() {
        return new TypeRef(LLVMLibrary.LLVMGetAllocatedType(this.value));
    }

    public boolean isCastInst() {
        try {
            return LLVMLibrary.LLVMIsACastInst(this.value) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isBitCastInst() {
        try {
            return LLVMLibrary.LLVMIsABitCastInst(this.value) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isFPExtInst() {
        try {
            return LLVMLibrary.LLVMIsAFPExtInst(this.value) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isFPToSIInst() {
        try {
            return LLVMLibrary.LLVMIsAFPToSIInst(this.value) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isFPToUIInst() {
        try {
            return LLVMLibrary.LLVMIsAFPToUIInst(this.value) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isFPTruncInst() {
        try {
            return LLVMLibrary.LLVMIsAFPTruncInst(this.value) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isIntToPtrInst() {
        try {
            return LLVMLibrary.LLVMIsAIntToPtrInst(this.value) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isPtrToIntInst() {
        try {
            return LLVMLibrary.LLVMIsAPtrToIntInst(this.value) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isSExtInst() {
        try {
            return LLVMLibrary.LLVMIsASExtInst(this.value) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isSIToFPInst() {
        try {
            return LLVMLibrary.LLVMIsASIToFPInst(this.value) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isTruncInst() {
        try {
            return LLVMLibrary.LLVMIsATruncInst(this.value) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isUIToFPInst() {
        try {
            return LLVMLibrary.LLVMIsAUIToFPInst(this.value) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isZExtInst() {
        try {
            return LLVMLibrary.LLVMIsAZExtInst(this.value) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isExtractValueInst() {
        try {
            return LLVMLibrary.LLVMIsAExtractValueInst(this.value) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isLoadInst() {
        try {
            return LLVMLibrary.LLVMIsALoadInst(this.value) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isVAArgInst() {
        try {
            return LLVMLibrary.LLVMIsAVAArgInst(this.value) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean isConstant() {
        LLVMLibrary.LLVMBool b = LLVMLibrary.LLVMIsConstant(this.value);
        return Utils.llvmBoolToJavaBool(b);
    }

    public boolean isNull() {
        LLVMLibrary.LLVMBool b = LLVMLibrary.LLVMIsNull(this.value);
        return Utils.llvmBoolToJavaBool(b);
    }

    public boolean isUndef() {
        LLVMLibrary.LLVMBool b = LLVMLibrary.LLVMIsUndef(this.value);
        return Utils.llvmBoolToJavaBool(b);
    }

    public static Value getUser(Use u) {
        Preconditions.checkNotNull((Object)u);
        return new Value(LLVMLibrary.LLVMGetUser(u.use()));
    }

    public static Value getUsedValue(Use u) {
        return new Value(LLVMLibrary.LLVMGetUsedValue(u.use()));
    }

    public Value getOperand(int index) {
        int numOperands = this.getNumOperands();
        if (numOperands <= index) {
            throw new IndexOutOfBoundsException("Index " + index + " out of bounds for " + numOperands + " operands");
        }
        return new Value(LLVMLibrary.LLVMGetOperand(this.value, index));
    }

    public void setOperand(int index, Value val) {
        Preconditions.checkNotNull((Object)val);
        LLVMLibrary.LLVMSetOperand(this.value, index, val.value());
    }

    public int getNumOperands() {
        return LLVMLibrary.LLVMGetNumOperands(this.value);
    }

    public int getNumArgOperands() {
        Utils.checkLlvmState(this.isCallInst(), "Value is not a call instruction: " + this);
        return LLVMLibrary.LLVMGetNumArgOperands(this.value);
    }

    public int getNumIndices() {
        Utils.checkLlvmState(this.isExtractValueInst() || this.isInsertValueInst(), "Value is not an extractValue or insertValue instruction: " + this);
        return LLVMLibrary.LLVMGetNumIndices(this.value);
    }

    public List<Integer> getIndices() {
        Utils.checkLlvmState(this.isExtractValueInst() || this.isInsertValueInst(), "Value is not an extractValue or insertValue instruction: " + this);
        int length = this.getNumIndices();
        Pointer arrayPointer = LLVMLibrary.LLVMGetIndices(this.value);
        ArrayList<Integer> indices = new ArrayList<Integer>(length);
        for (int i : arrayPointer.getIntArray(0L, length)) {
            indices.add(i);
        }
        return indices;
    }

    public Value getArgOperand(int index) {
        Utils.checkLlvmState(this.isCallInst(), "Value is not a call instruction: " + this);
        int numArgOperands = this.getNumArgOperands();
        if (numArgOperands <= index) {
            throw new IndexOutOfBoundsException("Index " + index + " out of bounds for " + numArgOperands + " arg operands");
        }
        return this.getOperand(index);
    }

    public Value getCalledFunction() {
        Utils.checkLlvmState(this.isCallInst(), "Value not a call instruction: " + this);
        return new Value(LLVMLibrary.LLVMGetCalledValue(this.value));
    }

    public OpCode getOpCode() {
        int opcode = LLVMLibrary.LLVMGetInstructionOpcode(this.value);
        return Value.transformOpCodeIndex(opcode);
    }

    public OpCode getConstOpCode() {
        int opcode = LLVMLibrary.LLVMGetConstOpcode(this.value);
        return Value.transformOpCodeIndex(opcode);
    }

    private static OpCode transformOpCodeIndex(int pOpCodeInt) {
        for (OpCode code : OpCode.values()) {
            if (code.getValue() != pOpCodeInt) continue;
            return code;
        }
        throw new AssertionError((Object)("Unhandled code id " + pOpCodeInt));
    }

    public IntPredicate getICmpPredicate() {
        int code = LLVMLibrary.LLVMGetICmpPredicate(this.value);
        for (IntPredicate predicate : IntPredicate.values()) {
            if (code != predicate.getValue()) continue;
            return predicate;
        }
        throw new AssertionError((Object)("Unhandled code id " + code));
    }

    public boolean isConditional() {
        LLVMLibrary.LLVMBool b = LLVMLibrary.LLVMIsConditional(this.value);
        return Utils.llvmBoolToJavaBool(b);
    }

    public Value getCondition() {
        Utils.checkLlvmState(this.isConditional(), "Value not a conditional: " + this);
        return new Value(LLVMLibrary.LLVMGetCondition(this.value));
    }

    public static Value blockAddress(Value f, BasicBlock bb) {
        return new Value(LLVMLibrary.LLVMBlockAddress(f.value(), bb.bb()));
    }

    public Module getGlobalParent() {
        return Module.createGlobalParentOf(this);
    }

    public boolean isDeclaration() {
        if (this.value == null) {
            throw new NullPointerException("Null pointer value");
        }
        LLVMLibrary.LLVMBool b = LLVMLibrary.LLVMIsDeclaration(this.value);
        return Utils.llvmBoolToJavaBool(b);
    }

    public Linkage getLinkage() {
        int code = LLVMLibrary.LLVMGetLinkage(this.value);
        for (Linkage l : Linkage.values()) {
            if (code != l.getValue()) continue;
            return l;
        }
        throw new AssertionError((Object)("Unhandled code id " + code));
    }

    public String getSection() {
        return LLVMLibrary.LLVMGetSection(this.value);
    }

    public Visibility getVisibility() {
        int code = LLVMLibrary.LLVMGetVisibility(this.value);
        for (Visibility v : Visibility.values()) {
            if (code != v.getValue()) continue;
            return v;
        }
        throw new AssertionError((Object)("Unhandled code id " + code));
    }

    public int getAlignment() {
        return LLVMLibrary.LLVMGetAlignment(this.value);
    }

    public Value getNextGlobal() {
        return new Value(LLVMLibrary.LLVMGetNextGlobal(this.value));
    }

    public Value getPreviousGlobal() {
        return new Value(LLVMLibrary.LLVMGetPreviousGlobal(this.value));
    }

    public Value getInitializer() {
        assert (this.isGlobalValue()) : "Only global values have initializer: " + this;
        LLVMLibrary.LLVMValueRef init = LLVMLibrary.LLVMGetInitializer(this.value);
        if (init != null) {
            return new Value(init);
        }
        return null;
    }

    public boolean isExternallyInitialized() {
        LLVMLibrary.LLVMBool b = LLVMLibrary.LLVMIsExternallyInitialized(this.value);
        return Utils.llvmBoolToJavaBool(b);
    }

    public boolean isThreadLocal() {
        LLVMLibrary.LLVMBool b = LLVMLibrary.LLVMIsThreadLocal(this.value);
        return Utils.llvmBoolToJavaBool(b);
    }

    public boolean isGlobalConstant() {
        LLVMLibrary.LLVMBool b = LLVMLibrary.LLVMIsGlobalConstant(this.value);
        return Utils.llvmBoolToJavaBool(b);
    }

    public Value getNextFunction() {
        LLVMLibrary.LLVMValueRef nextFunc = LLVMLibrary.LLVMGetNextFunction(this.value);
        if (nextFunc == null) {
            return null;
        }
        return new Value(nextFunc);
    }

    public Value getPreviousFunction() {
        LLVMLibrary.LLVMValueRef previousFunc = LLVMLibrary.LLVMGetPreviousFunction(this.value);
        if (previousFunc == null) {
            return null;
        }
        return new Value(previousFunc);
    }

    public void deleteFunction() {
        LLVMLibrary.LLVMDeleteFunction(this.value);
    }

    public void getIntrinsicID() {
        LLVMLibrary.LLVMGetIntrinsicID(this.value);
    }

    public CallConv getFunctionCallConv() {
        int code = LLVMLibrary.LLVMGetFunctionCallConv(this.value);
        for (CallConv v : CallConv.values()) {
            if (code != v.getValue()) continue;
            return v;
        }
        throw new AssertionError((Object)("Unhandled code id " + code));
    }

    public String getGC() {
        return LLVMLibrary.LLVMGetGC(this.value);
    }

    public Attribute getFunctionAttr() {
        throw new UnsupportedOperationException();
    }

    public int countParams() {
        return LLVMLibrary.LLVMCountParams(this.value);
    }

    public List<Value> getParams() {
        int paramCount = this.countParams();
        ArrayList<Value> params = new ArrayList<Value>(paramCount);
        if (paramCount > 0) {
            int valueRefOffset = Native.getNativeSize(LLVMLibrary.LLVMValueRef.class);
            Memory arrayPointer = new Memory((long)(paramCount * valueRefOffset));
            LLVMLibrary.LLVMValueRef paramArray = new LLVMLibrary.LLVMValueRef((Pointer)arrayPointer);
            LLVMLibrary.LLVMGetParams(this.value, paramArray);
            Pointer[] paramRefs = new Pointer[paramCount];
            arrayPointer.read(0L, paramRefs, 0, paramCount);
            for (int i = 0; i < paramCount; ++i) {
                LLVMLibrary.LLVMValueRef valueRef = new LLVMLibrary.LLVMValueRef(paramRefs[i]);
                params.add(new Value(valueRef));
            }
        }
        return params;
    }

    public Value getParam(int index) {
        return new Value(LLVMLibrary.LLVMGetParam(this.value, index));
    }

    public Value getParamParent() {
        return new Value(LLVMLibrary.LLVMGetParamParent(this.value));
    }

    public Value getFirstParam() {
        try {
            return new Value(LLVMLibrary.LLVMGetFirstParam(this.value));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public Value getLastParam() {
        try {
            return new Value(LLVMLibrary.LLVMGetLastParam(this.value));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public Value getNextParam() {
        return new Value(LLVMLibrary.LLVMGetNextParam(this.value));
    }

    public Value getPreviousParam() {
        return new Value(LLVMLibrary.LLVMGetPreviousParam(this.value));
    }

    public Attribute getAttribute() {
        throw new UnsupportedOperationException();
    }

    public long constIntGetZExtValue() {
        return LLVMLibrary.LLVMConstIntGetZExtValue(this.value);
    }

    public long constIntGetSExtValue() {
        return LLVMLibrary.LLVMConstIntGetSExtValue(this.value);
    }

    public double constRealGetDouble() {
        LLVMLibrary.LLVMBool precisionLoss = new LLVMLibrary.LLVMBool();
        double ret = LLVMLibrary.LLVMConstRealGetDouble(this.value, precisionLoss);
        if (Utils.llvmBoolToJavaBool(precisionLoss)) {
            throw new AssertionError((Object)("Lost precision while convering float: " + this.value));
        }
        return ret;
    }

    public String getGetElementPtrAsString() {
        Utils.checkLlvmState(this.canBeTransformedFromGetElementPtrToString(), "Not a fitting getelementptr instruction: " + this);
        Value startPointer = this.getOperand(0);
        Value initializer = startPointer.getInitializer();
        long stringLength = initializer.typeOf().getArrayLength();
        return LLVMLibrary.LLVMGetAsString(initializer.value(), new NativeSizeByReference(stringLength));
    }

    public boolean canBeTransformedFromGetElementPtrToString() {
        Utils.checkLlvmState(this.isGetElementPtrInst(), "Not a getelementptr instruction: " + this);
        Value startPointer = this.getOperand(0);
        if (!startPointer.isGlobalValue()) {
            return false;
        }
        Value initializer = startPointer.getInitializer();
        if (initializer == null) {
            return false;
        }
        return startPointer.isGlobalConstant() && initializer.isConstant() && initializer.typeOf().getTypeKind().equals((Object)TypeRef.TypeKind.Array) && this.getNumOperands() == 3 && this.getOperand(1).constIntGetSExtValue() == 0L && this.getOperand(2).constIntGetSExtValue() == 0L;
    }

    public Value getElementAsConstant(int pElementIndex) {
        return new Value(LLVMLibrary.LLVMGetElementAsConstant(this.value, pElementIndex));
    }

    public Value getElement(int pElementIndex, int pSize) {
        IntBuffer intBuffer = IntBuffer.allocate(pSize);
        return new Value(LLVMLibrary.LLVMConstExtractValue(this.value, intBuffer, pElementIndex));
    }

    public boolean isBasicBlock() {
        LLVMLibrary.LLVMBool b = LLVMLibrary.LLVMValueIsBasicBlock(this.value);
        return Utils.llvmBoolToJavaBool(b);
    }

    public BasicBlock asBasicBlock() {
        return new BasicBlock(LLVMLibrary.LLVMValueAsBasicBlock(this.value));
    }

    public int countBasicBlocks() {
        return LLVMLibrary.LLVMCountBasicBlocks(this.value);
    }

    public List<BasicBlock> getBasicBlocks() {
        int blockCount = this.countBasicBlocks();
        ArrayList<BasicBlock> blocks = new ArrayList<BasicBlock>(blockCount);
        if (blockCount > 0) {
            int blockRefSize = Native.getNativeSize(LLVMLibrary.LLVMBasicBlockRef.class);
            Memory arrayPointer = new Memory((long)(blockCount * blockRefSize));
            LLVMLibrary.LLVMBasicBlockRef blockArray = new LLVMLibrary.LLVMBasicBlockRef((Pointer)arrayPointer);
            LLVMLibrary.LLVMGetBasicBlocks(this.value, blockArray);
            Pointer[] blockRefs = new Pointer[blockCount];
            arrayPointer.read(0L, blockRefs, 0, blockCount);
            for (int i = 0; i < blockCount; ++i) {
                LLVMLibrary.LLVMBasicBlockRef blockRef = new LLVMLibrary.LLVMBasicBlockRef(blockRefs[i]);
                blocks.add(new BasicBlock(blockRef));
            }
        }
        return blocks;
    }

    public BasicBlock getFirstBasicBlock() {
        try {
            return new BasicBlock(LLVMLibrary.LLVMGetFirstBasicBlock(this.value));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public BasicBlock getLastBasicBlock() {
        try {
            return new BasicBlock(LLVMLibrary.LLVMGetLastBasicBlock(this.value));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public BasicBlock getEntryBasicBlock() {
        try {
            return new BasicBlock(LLVMLibrary.LLVMGetEntryBasicBlock(this.value));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public BasicBlock getInstructionParent() {
        return new BasicBlock(LLVMLibrary.LLVMGetInstructionParent(this.value));
    }

    public Value getNextInstruction() {
        return new Value(LLVMLibrary.LLVMGetNextInstruction(this.value));
    }

    public Value getPreviousInstruction() {
        return new Value(LLVMLibrary.LLVMGetPreviousInstruction(this.value));
    }

    public int getInstructionCallConv() {
        return LLVMLibrary.LLVMGetInstructionCallConv(this.value);
    }

    public boolean isTailCall() {
        LLVMLibrary.LLVMBool b = LLVMLibrary.LLVMIsTailCall(this.value);
        return Utils.llvmBoolToJavaBool(b);
    }

    public int countIncoming() {
        return LLVMLibrary.LLVMCountIncoming(this.value);
    }

    public Value getIncomingValue(int index) {
        return new Value(LLVMLibrary.LLVMGetIncomingValue(this.value, index));
    }

    public BasicBlock getIncomingBlock(int index) {
        return new BasicBlock(LLVMLibrary.LLVMGetIncomingBlock(this.value, index));
    }

    public int getNumSuccessors() {
        Utils.checkLlvmState(this.isTerminatorInst(), "Value not termination instruction: " + this);
        return LLVMLibrary.LLVMGetNumSuccessors(this.value);
    }

    public BasicBlock getSuccessor(int i) {
        Utils.checkLlvmState(this.isTerminatorInst(), "Value not termination instruction: " + this);
        return new BasicBlock(LLVMLibrary.LLVMGetSuccessor(this.value, i));
    }

    public static enum Attribute {
        ZExtAttribute(1),
        SExtAttribute(2),
        NoReturnAttribute(4),
        InRegAttribute(8),
        StructRetAttribute(16),
        NoUnwindAttribute(32),
        NoAliasAttribute(64),
        ByValAttribute(128),
        NestAttribute(256),
        ReadNoneAttribute(512),
        ReadOnlyAttribute(1024),
        NoInlineAttribute(2048),
        AlwaysInlineAttribute(4096),
        OptimizeForSizeAttribute(8192),
        StackProtectAttribute(16384),
        StackProtectReqAttribute(32768),
        Alignment(65536),
        NoCaptureAttribute(0x200000),
        NoRedZoneAttribute(0x400000),
        NoImplicitFloatAttribute(0x800000),
        NakedAttribute(0x1000000),
        InlineHintAttribute(0x2000000),
        StackAlignment(0x1C000000),
        ReturnsTwice(0x20000000),
        UWTable(0x40000000),
        NonLazyBind(Integer.MIN_VALUE);

        private final int value;

        private Attribute(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum Visibility {
        Default(0),
        Hidden(1),
        Protected(2);

        private final int value;

        private Visibility(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum Linkage {
        ExternalLinkage(0),
        AvailableExternallyLinkage(1),
        LinkOnceAnyLinkage(2),
        LinkOnceODRLinkage(3),
        LinkOnceODRAutoHideLinkage(4),
        WeakAnyLinkage(5),
        WeakODRLinkage(6),
        AppendingLinkage(7),
        InternalLinkage(8),
        PrivateLinkage(9),
        DLLImportLinkage(10),
        DLLExportLinkage(11),
        ExternalWeakLinkage(12),
        GhostLinkage(13),
        CommonLinkage(14),
        LinkerPrivateLinkage(15),
        LinkerPrivateWeakLinkage(16);

        private final int value;

        private Linkage(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum IntPredicate {
        IntEQ(32),
        IntNE(33),
        IntUGT(34),
        IntUGE(35),
        IntULT(36),
        IntULE(37),
        IntSGT(38),
        IntSGE(39),
        IntSLT(40),
        IntSLE(41);

        private final int value;

        private IntPredicate(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum CallConv {
        CCallConv(0),
        FastCallConv(8),
        ColdCallConv(9),
        WebKitJSCallConv(12),
        AnyRegCallConv(13),
        X86StdcallCallConv(64),
        X86FastcallCallConv(65);

        private final int value;

        private CallConv(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum OpCode {
        Ret(1),
        Br(2),
        Switch(3),
        IndirectBr(4),
        Invoke(5),
        Unreachable(7),
        Add(8),
        FAdd(9),
        Sub(10),
        FSub(11),
        Mul(12),
        FMul(13),
        UDiv(14),
        SDiv(15),
        FDiv(16),
        URem(17),
        SRem(18),
        FRem(19),
        Shl(20),
        LShr(21),
        AShr(22),
        And(23),
        Or(24),
        Xor(25),
        Alloca(26),
        Load(27),
        Store(28),
        GetElementPtr(29),
        Trunc(30),
        ZExt(31),
        SExt(32),
        FPToUI(33),
        FPToSI(34),
        UIToFP(35),
        SIToFP(36),
        FPTrunc(37),
        FPExt(38),
        PtrToInt(39),
        IntToPtr(40),
        BitCast(41),
        AddrSpaceCast(60),
        ICmp(42),
        FCmp(43),
        PHI(44),
        Call(45),
        Select(46),
        UserOp1(47),
        UserOp2(48),
        VAArg(49),
        ExtractElement(50),
        InsertElement(51),
        ShuffleVector(52),
        ExtractValue(53),
        InsertValue(54),
        Fence(55),
        AtomicCmpXchg(56),
        AtomicRMW(57),
        Resume(58),
        LandingPad(59),
        CleanupRet(61),
        CatchRet(62),
        CatchPad(63),
        CleanupPad(64),
        CatchSwitch(65);

        private final int value;

        private OpCode(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

