/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.llvm_j.binding.ext;

import com.google.common.base.Preconditions;
import com.sun.jna.ptr.ByReference;
import org.sosy_lab.llvm_j.binding.ext.NativeSize;

public class NativeSizeByReference
extends ByReference {
    public NativeSizeByReference() {
        this(new NativeSize(0L));
    }

    public NativeSizeByReference(NativeSize value) {
        super(NativeSize.SIZE);
        this.setValue(value);
    }

    public NativeSizeByReference(long value) {
        this(new NativeSize(value));
    }

    public void setValue(NativeSize value) {
        Preconditions.checkNotNull((Object)((Object)value));
        if (NativeSize.SIZE == 4) {
            this.getPointer().setInt(0L, value.intValue());
        } else {
            if (NativeSize.SIZE != 8) {
                throw new AssertionError((Object)"GCCLong has to be either 4 or 8 bytes.");
            }
            this.getPointer().setLong(0L, value.longValue());
        }
    }

    public NativeSize getValue() {
        if (NativeSize.SIZE == 4) {
            return new NativeSize(this.getPointer().getInt(0L));
        }
        if (NativeSize.SIZE == 8) {
            return new NativeSize(this.getPointer().getLong(0L));
        }
        throw new AssertionError((Object)"GCCLong has to be either 4 or 8 bytes.");
    }
}

