/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.common;

import com.google.common.base.Preconditions;
import java.lang.management.ManagementFactory;
import java.util.logging.Level;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.RuntimeErrorException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.log.LogManager;

public abstract class AbstractMBean {
    private static final @Nullable MBeanServer MBEAN_SERVER = AbstractMBean.getMBeanServer();
    private @Nullable ObjectName oname = null;
    private final LogManager logger;

    private static @Nullable MBeanServer getMBeanServer() {
        try {
            return ManagementFactory.getPlatformMBeanServer();
        }
        catch (SecurityException e) {
            return null;
        }
    }

    protected AbstractMBean(String name, LogManager logger) {
        this.logger = (LogManager)Preconditions.checkNotNull((Object)logger);
        if (MBEAN_SERVER != null) {
            try {
                this.oname = new ObjectName((String)Preconditions.checkNotNull((Object)name));
            }
            catch (MalformedObjectNameException e) {
                logger.logException(Level.WARNING, e, "Invalid object name specified for management interface");
            }
        }
    }

    protected RuntimeErrorException handleRuntimeErrorException(RuntimeErrorException e) {
        if (e.getTargetError() != null) {
            throw e.getTargetError();
        }
        throw e;
    }

    public void register() {
        if (MBEAN_SERVER != null && this.oname != null) {
            try {
                if (MBEAN_SERVER.isRegistered(this.oname)) {
                    MBEAN_SERVER.unregisterMBean(this.oname);
                    assert (!MBEAN_SERVER.isRegistered(this.oname));
                }
                MBEAN_SERVER.registerMBean(this, this.oname);
            }
            catch (RuntimeErrorException e) {
                throw this.handleRuntimeErrorException(e);
            }
            catch (SecurityException | JMException e) {
                this.logger.logfUserException(Level.WARNING, e, "Error during registration of management interface %s", this.getClass().getSimpleName());
                this.oname = null;
            }
        } else {
            this.logger.log(Level.WARNING, "Cannot register management interface ", this.getClass().getSimpleName());
        }
    }

    public void unregister() {
        if (MBEAN_SERVER != null && this.oname != null) {
            try {
                MBEAN_SERVER.unregisterMBean(this.oname);
            }
            catch (RuntimeErrorException e) {
                throw this.handleRuntimeErrorException(e);
            }
            catch (SecurityException | JMException e) {
                this.logger.logException(Level.WARNING, e, "Error during unregistration of management interface");
            }
        }
    }
}

